/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.DateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.builtins.Options;
import org.jline.builtins.ScreenTerminal;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Attributes;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.LineDisciplineTerminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.jline.utils.Log;

public class Tmux {
    public static final String OPT_PREFIX = "prefix";
    public static final String CMD_COMMANDS = "commands";
    public static final String CMD_SEND_PREFIX = "send-prefix";
    public static final String CMD_SPLIT_WINDOW = "split-window";
    public static final String CMD_SPLITW = "splitw";
    public static final String CMD_SELECT_PANE = "select-pane";
    public static final String CMD_SELECTP = "selectp";
    public static final String CMD_RESIZE_PANE = "resize-pane";
    public static final String CMD_RESIZEP = "resizep";
    public static final String CMD_DISPLAY_PANES = "display-panes";
    public static final String CMD_DISPLAYP = "displayp";
    public static final String CMD_CLOCK_MODE = "clock-mode";
    public static final String CMD_SET_OPTION = "set-option";
    public static final String CMD_SET = "set";
    public static final String CMD_LIST_KEYS = "list-keys";
    public static final String CMD_LSK = "lsk";
    public static final String CMD_SEND_KEYS = "send-keys";
    public static final String CMD_SEND = "send";
    public static final String CMD_BIND_KEY = "bind-key";
    public static final String CMD_BIND = "bind";
    public static final String CMD_UNBIND_KEY = "unbind-key";
    public static final String CMD_UNBIND = "unbind";
    private static final int[][][] WINDOW_CLOCK_TABLE = new int[][][]{new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 0, 0, 0, 0}}, new int[][]{{1, 0, 0, 0, 1}, {1, 1, 0, 1, 1}, {1, 0, 1, 0, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}}};
    private final AtomicBoolean dirty = new AtomicBoolean(true);
    private final AtomicBoolean resized = new AtomicBoolean(true);
    private final Terminal terminal;
    private final Display display;
    private final PrintStream err;
    private final String term;
    private final Consumer<Terminal> runner;
    private List<VirtualConsole> panes = new ArrayList<VirtualConsole>();
    private VirtualConsole active;
    private int lastActive;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Size size = new Size();
    private final AtomicInteger paneId = new AtomicInteger();
    private Layout layout;
    private boolean identify;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> clockFuture;
    private final Map<String, String> serverOptions = new HashMap<String, String>();
    private KeyMap<Object> keyMap;
    int ACTIVE_COLOR = 3908;
    int INACTIVE_COLOR = 1103;
    int CLOCK_COLOR = 1103;

    public Tmux(Terminal terminal, PrintStream err, Consumer<Terminal> runner) throws IOException {
        this.terminal = terminal;
        this.err = err;
        this.runner = runner;
        this.display = new Display(terminal, true);
        Integer colors = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
        this.term = colors != null && colors >= 256 ? "screen-256color" : "screen";
        this.serverOptions.put(OPT_PREFIX, "`");
        this.keyMap = this.createKeyMap(this.serverOptions.get(OPT_PREFIX));
    }

    protected KeyMap<Object> createKeyMap(String prefix) {
        KeyMap<Object> keyMap = this.createEmptyKeyMap(prefix);
        keyMap.bind((Object)CMD_SEND_PREFIX, (CharSequence)(prefix + prefix));
        keyMap.bind((Object)"split-window -v", (CharSequence)(prefix + "\""));
        keyMap.bind((Object)"split-window -h", (CharSequence)(prefix + "%"));
        keyMap.bind((Object)"select-pane -U", (CharSequence)(prefix + KeyMap.key(this.terminal, InfoCmp.Capability.key_up)));
        keyMap.bind((Object)"select-pane -D", (CharSequence)(prefix + KeyMap.key(this.terminal, InfoCmp.Capability.key_down)));
        keyMap.bind((Object)"select-pane -L", (CharSequence)(prefix + KeyMap.key(this.terminal, InfoCmp.Capability.key_left)));
        keyMap.bind((Object)"select-pane -R", (CharSequence)(prefix + KeyMap.key(this.terminal, InfoCmp.Capability.key_right)));
        keyMap.bind((Object)"resize-pane -U 5", (CharSequence)(prefix + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_up)));
        keyMap.bind((Object)"resize-pane -D 5", (CharSequence)(prefix + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_down)));
        keyMap.bind((Object)"resize-pane -L 5", (CharSequence)(prefix + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_left)));
        keyMap.bind((Object)"resize-pane -R 5", (CharSequence)(prefix + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_right)));
        keyMap.bind((Object)"resize-pane -U", prefix + KeyMap.translate("^[[1;5A"), prefix + KeyMap.alt(KeyMap.translate("^[[A")));
        keyMap.bind((Object)"resize-pane -D", prefix + KeyMap.translate("^[[1;5B"), prefix + KeyMap.alt(KeyMap.translate("^[[B")));
        keyMap.bind((Object)"resize-pane -L", prefix + KeyMap.translate("^[[1;5C"), prefix + KeyMap.alt(KeyMap.translate("^[[C")));
        keyMap.bind((Object)"resize-pane -R", prefix + KeyMap.translate("^[[1;5D"), prefix + KeyMap.alt(KeyMap.translate("^[[D")));
        keyMap.bind((Object)CMD_DISPLAY_PANES, (CharSequence)(prefix + "q"));
        keyMap.bind((Object)CMD_CLOCK_MODE, (CharSequence)(prefix + "t"));
        return keyMap;
    }

    protected KeyMap<Object> createEmptyKeyMap(String prefix) {
        KeyMap<Object> keyMap = new KeyMap<Object>();
        keyMap.setUnicode((Object)Binding.SelfInsert);
        keyMap.setNomatch((Object)Binding.SelfInsert);
        for (int i2 = 0; i2 < 255; ++i2) {
            keyMap.bind((Object)Binding.Discard, (CharSequence)(prefix + (char)i2));
        }
        keyMap.bind((Object)Binding.Mouse, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        return keyMap;
    }

    public void run() throws IOException {
        Terminal.SignalHandler prevWinchHandler = this.terminal.handle(Terminal.Signal.WINCH, this::resize);
        Terminal.SignalHandler prevIntHandler = this.terminal.handle(Terminal.Signal.INT, this::interrupt);
        Terminal.SignalHandler prevSuspHandler = this.terminal.handle(Terminal.Signal.TSTP, this::suspend);
        Attributes attributes2 = this.terminal.enterRawMode();
        this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
        this.terminal.trackMouse(Terminal.MouseTracking.Any);
        this.terminal.flush();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        try {
            this.size.copy(this.terminal.getSize());
            this.layout = new Layout();
            this.layout.sx = this.size.getColumns();
            this.layout.sy = this.size.getRows();
            this.layout.type = Layout.Type.WindowPane;
            this.active = new VirtualConsole(this.paneId.incrementAndGet(), this.term, 0, 0, this.size.getColumns(), this.size.getRows() - 1, this::setDirty, this::close, this.layout);
            this.active.active = this.lastActive++;
            this.active.getConsole().setAttributes(this.terminal.getAttributes());
            this.panes.add(this.active);
            this.runner.accept(this.active.getConsole());
            new Thread(this::inputLoop, "Mux input loop").start();
            this.redrawLoop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.executor.shutdown();
            this.terminal.trackMouse(Terminal.MouseTracking.Off);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.flush();
            this.terminal.setAttributes(attributes2);
            this.terminal.handle(Terminal.Signal.WINCH, prevWinchHandler);
            this.terminal.handle(Terminal.Signal.INT, prevIntHandler);
            this.terminal.handle(Terminal.Signal.TSTP, prevSuspHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawLoop() {
        while (this.running.get()) {
            try {
                AtomicBoolean atomicBoolean = this.dirty;
                synchronized (atomicBoolean) {
                    while (this.running.get() && !this.dirty.compareAndSet(true, false)) {
                        this.dirty.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.handleResize();
            this.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty() {
        AtomicBoolean atomicBoolean = this.dirty;
        synchronized (atomicBoolean) {
            this.dirty.set(true);
            this.dirty.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputLoop() {
        try {
            BindingReader reader = new BindingReader(this.terminal.reader());
            boolean first = true;
            while (this.running.get()) {
                Object b = first ? reader.readBinding(this.keyMap) : (reader.peekCharacter(100L) >= 0 ? reader.readBinding(this.keyMap, null, false) : null);
                if (b == Binding.SelfInsert) {
                    if (this.active.clock) {
                        this.active.clock = false;
                        if (this.clockFuture != null && this.panes.stream().noneMatch(vc -> ((VirtualConsole)vc).clock)) {
                            this.clockFuture.cancel(false);
                            this.clockFuture = null;
                        }
                        this.setDirty();
                        continue;
                    }
                    this.active.getMasterInputOutput().write(reader.getLastBinding().getBytes());
                    first = false;
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    this.active.getMasterInputOutput().flush();
                    first = true;
                }
                if (b == Binding.Mouse) {
                    MouseEvent mouseEvent = this.terminal.readMouseEvent();
                    continue;
                }
                if (!(b instanceof String) && !(b instanceof String[])) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                try {
                    PrintStream pout = new PrintStream(out);
                    Throwable throwable = null;
                    try {
                        PrintStream perr = new PrintStream(err);
                        Throwable throwable2 = null;
                        try {
                            if (b instanceof String) {
                                this.execute(pout, perr, (String)b);
                                continue;
                            }
                            this.execute(pout, perr, Arrays.asList((String[])b));
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (perr == null) continue;
                            if (throwable2 != null) {
                                try {
                                    perr.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            perr.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (pout == null) continue;
                        if (throwable != null) {
                            try {
                                pout.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        pout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            if (this.running.get()) {
                Log.info("Error in tmux input loop", e);
            }
        }
        finally {
            this.running.set(false);
            this.setDirty();
        }
    }

    private synchronized void close(VirtualConsole terminal) {
        int idx = this.panes.indexOf(terminal);
        if (idx >= 0) {
            this.panes.remove(idx);
            if (this.panes.isEmpty()) {
                this.running.set(false);
                this.setDirty();
            } else {
                terminal.layout.remove();
                if (this.active == terminal) {
                    this.active = this.panes.stream().sorted(Comparator.comparingInt(p -> ((VirtualConsole)p).active).reversed()).findFirst().get();
                }
                this.layout = this.active.layout;
                while (this.layout.parent != null) {
                    this.layout = this.layout.parent;
                }
                this.layout.fixOffsets();
                this.layout.fixPanes(this.size.getColumns(), this.size.getRows());
                this.resize(Terminal.Signal.WINCH);
            }
        }
    }

    private void resize(Terminal.Signal signal) {
        this.resized.set(true);
        this.setDirty();
    }

    private void interrupt(Terminal.Signal signal) {
        this.active.getConsole().raise(signal);
    }

    private void suspend(Terminal.Signal signal) {
        this.active.getConsole().raise(signal);
    }

    private void handleResize() {
        if (this.resized.compareAndSet(true, false)) {
            this.size.copy(this.terminal.getSize());
        }
        this.layout.resize(this.size.getColumns(), this.size.getRows() - 1);
        this.panes.forEach(vc -> {
            if (vc.width() != ((VirtualConsole)vc).layout.sx || vc.height() != ((VirtualConsole)vc).layout.sy || vc.left() != ((VirtualConsole)vc).layout.xoff || vc.top() != ((VirtualConsole)vc).layout.yoff) {
                vc.resize(((VirtualConsole)vc).layout.xoff, ((VirtualConsole)vc).layout.yoff, ((VirtualConsole)vc).layout.sx, ((VirtualConsole)vc).layout.sy);
                this.display.clear();
            }
        });
    }

    public void execute(PrintStream out, PrintStream err, String command) throws Exception {
        ParsedLine line = new DefaultParser().parse(command.trim(), 0);
        this.execute(out, err, line.words());
    }

    public synchronized void execute(PrintStream out, PrintStream err, List<String> command) throws Exception {
        String name2 = command.get(0);
        List<String> args = command.subList(1, command.size());
        switch (name2) {
            case "send-prefix": {
                this.sendPrefix(out, err, args);
                break;
            }
            case "split-window": 
            case "splitw": {
                this.splitWindow(out, err, args);
                break;
            }
            case "select-pane": 
            case "selectp": {
                this.selectPane(out, err, args);
                break;
            }
            case "resize-pane": 
            case "resizep": {
                this.resizePane(out, err, args);
                break;
            }
            case "display-panes": 
            case "displayp": {
                this.displayPanes(out, err, args);
                break;
            }
            case "clock-mode": {
                this.clockMode(out, err, args);
                break;
            }
            case "bind-key": 
            case "bind": {
                this.bindKey(out, err, args);
                break;
            }
            case "unbind-key": 
            case "unbind": {
                this.unbindKey(out, err, args);
                break;
            }
            case "list-keys": 
            case "lsk": {
                this.listKeys(out, err, args);
                break;
            }
            case "send-keys": 
            case "send": {
                this.sendKeys(out, err, args);
                break;
            }
            case "set-option": 
            case "set": {
                this.setOption(out, err, args);
            }
        }
    }

    protected void setOption(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String value2;
        String[] usage = new String[]{"set-option - ", "Usage: set-option [-agosquw] option [value]", "  -? --help                    Show help", "  -u --unset                   Unset the option"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        int nbargs = opt.args().size();
        if (nbargs < 1 || nbargs > 2) {
            opt.usage(err);
            return;
        }
        String name2 = opt.args().get(0);
        String string2 = value2 = nbargs > 1 ? opt.args().get(1) : null;
        if (!name2.startsWith("@")) {
            switch (name2) {
                case "prefix": {
                    if (value2 == null) {
                        throw new IllegalArgumentException("Missing argument");
                    }
                    String prefix = KeyMap.translate(value2);
                    String oldPrefix = this.serverOptions.put(OPT_PREFIX, prefix);
                    KeyMap<Object> newKeys = this.createEmptyKeyMap(prefix);
                    for (Map.Entry<String, Object> e : this.keyMap.getBoundKeys().entrySet()) {
                        if (!(e.getValue() instanceof String)) continue;
                        if (e.getKey().equals(oldPrefix + oldPrefix)) {
                            newKeys.bind(e.getValue(), (CharSequence)(prefix + prefix));
                            continue;
                        }
                        if (e.getKey().startsWith(oldPrefix)) {
                            newKeys.bind(e.getValue(), (CharSequence)(prefix + e.getKey().substring(oldPrefix.length())));
                            continue;
                        }
                        newKeys.bind(e.getValue(), (CharSequence)e.getKey());
                    }
                    this.keyMap = newKeys;
                }
            }
        }
    }

    protected void bindKey(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"bind-key - ", "Usage: bind-key key command [arguments]", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).setOptionsFirst(true).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        List<String> vargs = opt.args();
        if (vargs.size() < 2) {
            opt.usage(err);
            return;
        }
        String prefix = this.serverOptions.get(OPT_PREFIX);
        String key = prefix + KeyMap.translate(vargs.remove(0));
        this.keyMap.unbind((CharSequence)key.substring(0, 2));
        this.keyMap.bind((Object)vargs.toArray(new String[vargs.size()]), (CharSequence)key);
    }

    protected void unbindKey(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"unbind-key - ", "Usage: unbind-key key", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).setOptionsFirst(true).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        List<String> vargs = opt.args();
        if (vargs.size() != 1) {
            opt.usage(err);
            return;
        }
        String prefix = this.serverOptions.get(OPT_PREFIX);
        String key = prefix + KeyMap.translate(vargs.remove(0));
        this.keyMap.unbind((CharSequence)key);
        this.keyMap.bind((Object)Binding.Discard, (CharSequence)key);
    }

    protected void listKeys(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"list-keys - ", "Usage: list-keys ", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        String prefix = this.serverOptions.get(OPT_PREFIX);
        this.keyMap.getBoundKeys().entrySet().stream().filter(e -> e.getValue() instanceof String).map(e -> {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append("bind-key -T ");
            if (key.startsWith(prefix)) {
                sb.append("prefix ");
                key = key.substring(prefix.length());
            } else {
                sb.append("root   ");
            }
            sb.append(KeyMap.display(key));
            while (sb.length() < 32) {
                sb.append(" ");
            }
            sb.append(val);
            return sb.toString();
        }).sorted().forEach(out::println);
    }

    protected void sendKeys(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"send-keys - ", "Usage: send-keys [-lXRM] [-N repeat-count] [-t target-pane] key...", "  -? --help                    Show help", "  -l --literal                Send key literally", "  -N --number=repeat-count     Specifies a repeat count"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        int n = opt.getNumber("number");
        for (int i2 = 0; i2 < n; ++i2) {
            for (String arg : opt.args()) {
                String s = opt.isSet("literal") ? arg : KeyMap.translate(arg);
                this.active.getMasterInputOutput().write(s.getBytes());
            }
        }
    }

    protected void clockMode(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"clock-mode - ", "Usage: clock-mode", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        this.active.clock = true;
        if (this.clockFuture == null) {
            long initial = Instant.now().until(Instant.now().truncatedTo(ChronoUnit.MINUTES).plusSeconds(60L), ChronoUnit.MILLIS);
            long delay = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
            this.clockFuture = this.executor.scheduleWithFixedDelay(this::setDirty, initial, delay, TimeUnit.MILLISECONDS);
        }
        this.setDirty();
    }

    protected void displayPanes(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"display-panes - ", "Usage: display-panes", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        this.identify = true;
        this.setDirty();
        this.executor.schedule(() -> {
            this.identify = false;
            this.setDirty();
        }, 1L, TimeUnit.SECONDS);
    }

    protected void resizePane(PrintStream out, PrintStream err, List<String> args) throws IOException {
        int adjust;
        String[] usage = new String[]{"resize-pane - ", "Usage: resize-pane [-UDLR] [-x width] [-y height] [-t target-pane] [adjustment]", "  -? --help                    Show help", "  -U                           Resize pane upward", "  -D                           Select pane downward", "  -L                           Select pane to the left", "  -R                           Select pane to the right", "  -x --width=width             Set the width of the pane", "  -y --height=height           Set the height of the pane"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        if (opt.args().size() == 0) {
            adjust = 1;
        } else if (opt.args().size() == 1) {
            adjust = Integer.parseInt(opt.args().get(0));
        } else {
            opt.usage(err);
            return;
        }
        if (opt.isSet("width")) {
            int x = opt.getNumber("width");
            this.active.layout().resizeTo(Layout.Type.LeftRight, x);
        }
        if (opt.isSet("height")) {
            int y = opt.getNumber("height");
            this.active.layout().resizeTo(Layout.Type.TopBottom, y);
        }
        if (opt.isSet("L")) {
            this.active.layout().resize(Layout.Type.LeftRight, -adjust, true);
        } else if (opt.isSet("R")) {
            this.active.layout().resize(Layout.Type.LeftRight, adjust, true);
        } else if (opt.isSet("U")) {
            this.active.layout().resize(Layout.Type.TopBottom, -adjust, true);
        } else if (opt.isSet("D")) {
            this.active.layout().resize(Layout.Type.TopBottom, adjust, true);
        }
        this.setDirty();
    }

    protected void selectPane(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"select-pane - ", "Usage: select-pane [-UDLR] [-t target-pane]", "  -? --help                    Show help", "  -U                           Select pane up", "  -D                           Select pane down", "  -L                           Select pane left", "  -R                           Select pane right"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        VirtualConsole prevActive = this.active;
        if (opt.isSet("L")) {
            this.active = this.panes.stream().filter(c -> c.bottom() > this.active.top() && c.top() < this.active.bottom()).filter(c -> c != this.active).sorted(Comparator.comparingInt(c -> c.left() > this.active.left() ? c.left() : c.left() + this.size.getColumns()).reversed().thenComparingInt(c -> -((VirtualConsole)c).active)).findFirst().orElse(this.active);
        } else if (opt.isSet("R")) {
            this.active = this.panes.stream().filter(c -> c.bottom() > this.active.top() && c.top() < this.active.bottom()).filter(c -> c != this.active).sorted(Comparator.comparingInt(c -> c.left() > this.active.left() ? c.left() : c.left() + this.size.getColumns()).thenComparingInt(c -> -((VirtualConsole)c).active)).findFirst().orElse(this.active);
        } else if (opt.isSet("U")) {
            this.active = this.panes.stream().filter(c -> c.right() > this.active.left() && c.left() < this.active.right()).filter(c -> c != this.active).sorted(Comparator.comparingInt(c -> c.top() > this.active.top() ? c.top() : c.top() + this.size.getRows()).reversed().thenComparingInt(c -> -((VirtualConsole)c).active)).findFirst().orElse(this.active);
        } else if (opt.isSet("D")) {
            this.active = this.panes.stream().filter(c -> c.right() > this.active.left() && c.left() < this.active.right()).filter(c -> c != this.active).sorted(Comparator.comparingInt(c -> c.top() > this.active.top() ? c.top() : c.top() + this.size.getRows()).thenComparingInt(c -> -((VirtualConsole)c).active)).findFirst().orElse(this.active);
        }
        if (prevActive != this.active) {
            this.setDirty();
            this.active.active = this.lastActive++;
        }
    }

    protected void sendPrefix(PrintStream out, PrintStream err, List<String> args) throws IOException {
        String[] usage = new String[]{"send-prefix - ", "Usage: send-prefix [-2] [-t target-pane]", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        this.active.getMasterInputOutput().write(this.serverOptions.get(OPT_PREFIX).getBytes());
    }

    protected void splitWindow(PrintStream out, PrintStream err, List<String> args) throws IOException {
        Layout.Type type2;
        String[] usage = new String[]{"split-window - ", "Usage: split-window [-bdfhvP] [-c start-directory] [-F format] [-p percentage|-l size] [-t target-pane] [command]", "  -? --help                    Show help", "  -h --horizontal              Horizontal split", "  -v --vertical                Vertical split", "  -l --size=size               Size", "  -p --perc=percentage         Percentage", "  -b --before                  Insert the new pane before the active one", "  -f                           Split the full window instead of the active pane", "  -d                           Do not make the new pane the active one"};
        Options opt = Options.compile(usage).parse(args);
        if (opt.isSet("help")) {
            opt.usage(err);
            return;
        }
        Layout.Type type3 = type2 = opt.isSet("horizontal") ? Layout.Type.LeftRight : Layout.Type.TopBottom;
        if (this.layout.type == Layout.Type.WindowPane) {
            Layout p = new Layout();
            p.sx = this.layout.sx;
            p.sy = this.layout.sy;
            p.type = type2;
            p.cells.add(this.layout);
            this.layout.parent = p;
            this.layout = p;
        }
        Layout cell = this.active.layout();
        if (opt.isSet("f")) {
            while (cell.parent != this.layout) {
                cell = cell.parent;
            }
        }
        int size = -1;
        if (opt.isSet("size")) {
            size = opt.getNumber("size");
        } else if (opt.isSet("perc")) {
            int p = opt.getNumber("perc");
            size = type2 == Layout.Type.TopBottom ? cell.sy * p / 100 : cell.sx * p / 100;
        }
        Layout newCell = cell.split(type2, size, opt.isSet("before"));
        if (newCell == null) {
            err.println("create pane failed: pane too small");
            return;
        }
        VirtualConsole newConsole = new VirtualConsole(this.paneId.incrementAndGet(), this.term, newCell.xoff, newCell.yoff, newCell.sx, newCell.sy, this::setDirty, this::close, newCell);
        this.panes.add(newConsole);
        newConsole.getConsole().setAttributes(this.terminal.getAttributes());
        if (!opt.isSet("d")) {
            this.active = newConsole;
            this.active.active = this.lastActive++;
        }
        this.runner.accept(newConsole.getConsole());
        this.setDirty();
    }

    protected void layoutResize() {
    }

    protected synchronized void redraw() {
        long[] screen = new long[this.size.getRows() * this.size.getColumns()];
        Arrays.fill(screen, 32L);
        int[] cursor = new int[2];
        for (VirtualConsole terminal : this.panes) {
            if (terminal.clock) {
                String str = DateFormat.getTimeInstance(3).format(new Date());
                this.print(screen, terminal, str, this.CLOCK_COLOR);
            } else {
                terminal.dump(screen, terminal.top(), terminal.left(), this.size.getRows(), this.size.getColumns(), (int[])(terminal == this.active ? cursor : null));
            }
            if (this.identify) {
                String id = Integer.toString(terminal.id);
                this.print(screen, terminal, id, terminal == this.active ? this.ACTIVE_COLOR : this.INACTIVE_COLOR);
            }
            this.drawBorder(screen, this.size, terminal, 0L);
        }
        this.drawBorder(screen, this.size, this.active, 0x1008000000000000L);
        Arrays.fill(screen, (this.size.getRows() - 1) * this.size.getColumns(), this.size.getRows() * this.size.getColumns(), 0x2000008000000020L);
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
        int prevBg = 0;
        int prevFg = 0;
        boolean prevInv = false;
        boolean prevUl = false;
        boolean prevBold = false;
        boolean prevConceal = false;
        boolean prevHasFg = false;
        boolean prevHasBg = false;
        for (int y = 0; y < this.size.getRows(); ++y) {
            AttributedStringBuilder sb = new AttributedStringBuilder(this.size.getColumns());
            for (int x = 0; x < this.size.getColumns(); ++x) {
                int col;
                boolean hasBg;
                long d = screen[y * this.size.getColumns() + x];
                int c = (int)(d & 0xFFFFFFFFL);
                int a = (int)(d >> 32);
                int bg = a & 0xFFF;
                int fg = (a & 0xFFF000) >> 12;
                boolean ul = (a & 0x1000000) != 0;
                boolean inv = (a & 0x2000000) != 0;
                boolean conceal = (a & 0x4000000) != 0;
                boolean bold = (a & 0x8000000) != 0;
                boolean hasFg = (a & 0x10000000) != 0;
                boolean bl = hasBg = (a & 0x20000000) != 0;
                if (hasBg && prevHasBg && bg != prevBg || prevHasBg != hasBg) {
                    if (!hasBg) {
                        sb.style(sb.style().backgroundDefault());
                    } else {
                        col = bg;
                        col = AttributedCharSequence.roundRgbColor((col & 0xF00) >> 4, col & 0xF0, (col & 0xF) << 4, 256);
                        sb.style(sb.style().background(col));
                    }
                    prevBg = bg;
                    prevHasBg = hasBg;
                }
                if (hasFg && prevHasFg && fg != prevFg || prevHasFg != hasFg) {
                    if (!hasFg) {
                        sb.style(sb.style().foregroundDefault());
                    } else {
                        col = fg;
                        col = AttributedCharSequence.roundRgbColor((col & 0xF00) >> 4, col & 0xF0, (col & 0xF) << 4, 256);
                        sb.style(sb.style().foreground(col));
                    }
                    prevFg = fg;
                    prevHasFg = hasFg;
                }
                if (conceal != prevConceal) {
                    sb.style(conceal ? sb.style().conceal() : sb.style().concealOff());
                    prevConceal = conceal;
                }
                if (inv != prevInv) {
                    sb.style(inv ? sb.style().inverse() : sb.style().inverseOff());
                    prevInv = inv;
                }
                if (ul != prevUl) {
                    sb.style(ul ? sb.style().underline() : sb.style().underlineOff());
                    prevUl = ul;
                }
                if (bold != prevBold) {
                    sb.style(bold ? sb.style().bold() : sb.style().boldOff());
                    prevBold = bold;
                }
                sb.append((char)c);
            }
            lines.add(sb.toAttributedString());
        }
        this.display.resize(this.size.getRows(), this.size.getColumns());
        this.display.update(lines, this.size.cursorPos(cursor[1], cursor[0]));
    }

    private void print(long[] screen, VirtualConsole terminal, String id, int color) {
        if (terminal.height() > 5) {
            long attr = (long)color << 32 | 0x2000000000000000L;
            int yoff = (terminal.height() - 5) / 2;
            int xoff = (terminal.width() - id.length() * 6) / 2;
            for (int i2 = 0; i2 < id.length(); ++i2) {
                int idx;
                char ch = id.charAt(i2);
                switch (ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        idx = ch - 48;
                        break;
                    }
                    case ':': {
                        idx = 10;
                        break;
                    }
                    case 'A': {
                        idx = 11;
                        break;
                    }
                    case 'P': {
                        idx = 12;
                        break;
                    }
                    case 'M': {
                        idx = 13;
                        break;
                    }
                    default: {
                        idx = -1;
                    }
                }
                if (idx < 0) continue;
                int[][] data2 = WINDOW_CLOCK_TABLE[idx];
                for (int y = 0; y < data2.length; ++y) {
                    for (int x = 0; x < data2[y].length; ++x) {
                        if (data2[y][x] == 0) continue;
                        int off = (terminal.top + yoff + y) * this.size.getColumns() + terminal.left() + xoff + x + 6 * i2;
                        screen[off] = attr | 0x20L;
                    }
                }
            }
        } else {
            long attr = (long)color << 44 | 0x1000000000000000L;
            int yoff = (terminal.height() + 1) / 2;
            int xoff = (terminal.width() - id.length()) / 2;
            int off = (terminal.top + yoff) * this.size.getColumns() + terminal.left() + xoff;
            for (int i3 = 0; i3 < id.length(); ++i3) {
                screen[off + i3] = attr | (long)id.charAt(i3);
            }
        }
    }

    private void drawBorder(long[] screen, Size size, VirtualConsole terminal, long attr) {
        int i2;
        for (i2 = terminal.left(); i2 < terminal.right(); ++i2) {
            int y0 = terminal.top() - 1;
            int y1 = terminal.bottom();
            this.drawBorderChar(screen, size, i2, y0, attr, 9472);
            this.drawBorderChar(screen, size, i2, y1, attr, 9472);
        }
        for (i2 = terminal.top(); i2 < terminal.bottom(); ++i2) {
            int x0 = terminal.left() - 1;
            int x1 = terminal.right();
            this.drawBorderChar(screen, size, x0, i2, attr, 9474);
            this.drawBorderChar(screen, size, x1, i2, attr, 9474);
        }
        this.drawBorderChar(screen, size, terminal.left() - 1, terminal.top() - 1, attr, 9484);
        this.drawBorderChar(screen, size, terminal.right(), terminal.top() - 1, attr, 9488);
        this.drawBorderChar(screen, size, terminal.left() - 1, terminal.bottom(), attr, 9492);
        this.drawBorderChar(screen, size, terminal.right(), terminal.bottom(), attr, 9496);
    }

    private void drawBorderChar(long[] screen, Size size, int x, int y, long attr, int c) {
        if (x >= 0 && x < size.getColumns() && y >= 0 && y < size.getRows() - 1) {
            int oldc = (int)(screen[y * size.getColumns() + x] & 0xFFFFFFFFL);
            c = this.addBorder(c, oldc);
            screen[y * size.getColumns() + x] = attr | (long)c;
        }
    }

    private int addBorder(int c, int oldc) {
        if (oldc == 32) {
            return c;
        }
        if (oldc == 9532) {
            return 9532;
        }
        switch (c) {
            case 9474: {
                return this.addBorder(9591, this.addBorder(9589, oldc));
            }
            case 9472: {
                return this.addBorder(9588, this.addBorder(9590, oldc));
            }
            case 9484: {
                return this.addBorder(9590, this.addBorder(9591, oldc));
            }
            case 9488: {
                return this.addBorder(9588, this.addBorder(9591, oldc));
            }
            case 9492: {
                return this.addBorder(9590, this.addBorder(9589, oldc));
            }
            case 9496: {
                return this.addBorder(9588, this.addBorder(9589, oldc));
            }
            case 9500: {
                return this.addBorder(9590, this.addBorder(9474, oldc));
            }
            case 9508: {
                return this.addBorder(9588, this.addBorder(9474, oldc));
            }
            case 9516: {
                return this.addBorder(9591, this.addBorder(9472, oldc));
            }
            case 9524: {
                return this.addBorder(9589, this.addBorder(9472, oldc));
            }
            case 9588: {
                switch (oldc) {
                    case 9474: {
                        return 9508;
                    }
                    case 9472: {
                        return 9472;
                    }
                    case 9484: {
                        return 9516;
                    }
                    case 9488: {
                        return 9488;
                    }
                    case 9492: {
                        return 9524;
                    }
                    case 9496: {
                        return 9496;
                    }
                    case 9500: {
                        return 9532;
                    }
                    case 9508: {
                        return 9508;
                    }
                    case 9516: {
                        return 9516;
                    }
                    case 9524: {
                        return 9524;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 9589: {
                switch (oldc) {
                    case 9474: {
                        return 9474;
                    }
                    case 9472: {
                        return 9524;
                    }
                    case 9484: {
                        return 9500;
                    }
                    case 9488: {
                        return 9508;
                    }
                    case 9492: {
                        return 9492;
                    }
                    case 9496: {
                        return 9496;
                    }
                    case 9500: {
                        return 9500;
                    }
                    case 9508: {
                        return 9508;
                    }
                    case 9516: {
                        return 9532;
                    }
                    case 9524: {
                        return 9524;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 9590: {
                switch (oldc) {
                    case 9474: {
                        return 9500;
                    }
                    case 9472: {
                        return 9472;
                    }
                    case 9484: {
                        return 9484;
                    }
                    case 9488: {
                        return 9516;
                    }
                    case 9492: {
                        return 9492;
                    }
                    case 9496: {
                        return 9524;
                    }
                    case 9500: {
                        return 9500;
                    }
                    case 9508: {
                        return 9532;
                    }
                    case 9516: {
                        return 9516;
                    }
                    case 9524: {
                        return 9524;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 9591: {
                switch (oldc) {
                    case 9474: {
                        return 9474;
                    }
                    case 9472: {
                        return 9516;
                    }
                    case 9484: {
                        return 9484;
                    }
                    case 9488: {
                        return 9488;
                    }
                    case 9492: {
                        return 9500;
                    }
                    case 9496: {
                        return 9508;
                    }
                    case 9500: {
                        return 9500;
                    }
                    case 9508: {
                        return 9508;
                    }
                    case 9516: {
                        return 9516;
                    }
                    case 9524: {
                        return 9532;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    private static int findMatch(String layout, char c0, char c1) {
        int i2;
        if (layout.charAt(0) != c0) {
            throw new IllegalArgumentException();
        }
        int nb = 0;
        for (i2 = 0; i2 < layout.length(); ++i2) {
            char c = layout.charAt(i2);
            if (c == c0) {
                ++nb;
                continue;
            }
            if (c != c1 || --nb != 0) continue;
            return i2;
        }
        if (nb > 0) {
            throw new IllegalArgumentException("No matching '" + c1 + "'");
        }
        return i2;
    }

    private static class VirtualConsole
    implements Closeable {
        private final ScreenTerminal terminal;
        private final Consumer<VirtualConsole> closer;
        private final int id;
        private int left;
        private int top;
        private final Layout layout;
        private int active;
        private boolean clock;
        private final OutputStream masterOutput;
        private final OutputStream masterInputOutput;
        private final LineDisciplineTerminal console;

        public VirtualConsole(int id, String type2, int left, int top, int columns, int rows, final Runnable dirty, final Consumer<VirtualConsole> closer, Layout layout) throws IOException {
            String name2 = String.format("tmux%02d", id);
            this.id = id;
            this.left = left;
            this.top = top;
            this.closer = closer;
            this.terminal = new ScreenTerminal(columns, rows){

                @Override
                protected void setDirty() {
                    super.setDirty();
                    dirty.run();
                }
            };
            this.masterOutput = new MasterOutputStream();
            this.masterInputOutput = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    console.processInputByte(b);
                }
            };
            this.console = new LineDisciplineTerminal(name2, type2, this.masterOutput, Charset.defaultCharset().name()){

                @Override
                public void close() throws IOException {
                    super.close();
                    closer.accept(this);
                }
            };
            this.console.setSize(new Size(columns, rows));
            this.layout = layout;
        }

        Layout layout() {
            return this.layout;
        }

        public int left() {
            return this.left;
        }

        public int top() {
            return this.top;
        }

        public int right() {
            return this.left() + this.width();
        }

        public int bottom() {
            return this.top() + this.height();
        }

        public int width() {
            return this.console.getWidth();
        }

        public int height() {
            return this.console.getHeight();
        }

        public LineDisciplineTerminal getConsole() {
            return this.console;
        }

        public OutputStream getMasterInputOutput() {
            return this.masterInputOutput;
        }

        public void resize(int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.console.setSize(new Size(width, height));
            this.terminal.setSize(width, height);
            this.console.raise(Terminal.Signal.WINCH);
        }

        public void dump(long[] fullscreen, int ftop, int fleft, int fheight, int fwidth, int[] cursor) {
            this.terminal.dump(fullscreen, ftop, fleft, fheight, fwidth, cursor);
        }

        @Override
        public void close() throws IOException {
            this.console.close();
        }

        private class MasterOutputStream
        extends OutputStream {
            private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            private final CharsetDecoder decoder = Charset.defaultCharset().newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

            private MasterOutputStream() {
            }

            @Override
            public synchronized void write(int b) {
                this.buffer.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.buffer.write(b, off, len);
            }

            @Override
            public synchronized void flush() throws IOException {
                int size = this.buffer.size();
                if (size > 0) {
                    ByteBuffer in;
                    CharBuffer out;
                    while (true) {
                        out = CharBuffer.allocate(size);
                        in = ByteBuffer.wrap(this.buffer.toByteArray());
                        CoderResult result2 = this.decoder.decode(in, out, false);
                        if (!result2.isOverflow()) break;
                        size *= 2;
                    }
                    this.buffer.reset();
                    this.buffer.write(in.array(), in.arrayOffset(), in.remaining());
                    if (out.position() > 0) {
                        out.flip();
                        VirtualConsole.this.terminal.write(out);
                        VirtualConsole.this.masterInputOutput.write(VirtualConsole.this.terminal.read().getBytes());
                    }
                }
            }

            @Override
            public void close() throws IOException {
                this.flush();
            }
        }
    }

    static class Layout {
        static final Pattern PATTERN = Pattern.compile("([0-9]+)x([0-9]+),([0-9]+),([0-9]+)([^0-9]\\S*)?");
        private static final int PANE_MINIMUM = 3;
        Type type;
        Layout parent;
        int sx;
        int sy;
        int xoff;
        int yoff;
        List<Layout> cells = new ArrayList<Layout>();

        Layout() {
        }

        public static Layout parse(String layout) {
            if (layout.length() < 6) {
                throw new IllegalArgumentException("Bad syntax");
            }
            String chk = layout.substring(0, 4);
            if (layout.charAt(4) != ',') {
                throw new IllegalArgumentException("Bad syntax");
            }
            layout = layout.substring(5);
            if (Integer.parseInt(chk, 16) != Layout.checksum(layout)) {
                throw new IllegalArgumentException("Bad checksum");
            }
            return Layout.parseCell(null, layout);
        }

        public String dump() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("0000,");
            this.doDump(sb);
            int chk = Layout.checksum(sb, 5);
            sb.setCharAt(0, Layout.toHexChar(chk >> 12 & 0xF));
            sb.setCharAt(1, Layout.toHexChar(chk >> 8 & 0xF));
            sb.setCharAt(2, Layout.toHexChar(chk >> 4 & 0xF));
            sb.setCharAt(3, Layout.toHexChar(chk & 0xF));
            return sb.toString();
        }

        private static char toHexChar(int i2) {
            return i2 < 10 ? (char)(i2 + 48) : (char)(i2 - 10 + 97);
        }

        private void doDump(StringBuilder sb) {
            sb.append(this.sx).append('x').append(this.sy).append(',').append(this.xoff).append(',').append(this.yoff);
            switch (this.type) {
                case WindowPane: {
                    sb.append(',').append('0');
                    break;
                }
                case TopBottom: 
                case LeftRight: {
                    sb.append(this.type == Type.TopBottom ? (char)'[' : '{');
                    boolean first = true;
                    for (Layout c : this.cells) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(',');
                        }
                        c.doDump(sb);
                    }
                    sb.append(this.type == Type.TopBottom ? (char)']' : '}');
                }
            }
        }

        public void resize(Type type2, int change, boolean opposite) {
            Layout lc = this;
            Layout lcparent = lc.parent;
            while (lcparent != null && lcparent.type != type2) {
                lc = lcparent;
                lcparent = lc.parent;
            }
            if (lcparent == null) {
                return;
            }
            if (lc.nextSibling() == null) {
                lc = lc.prevSibling();
            }
            int needed = change;
            while (needed != 0) {
                int size;
                if (change > 0) {
                    size = lc.resizePaneGrow(type2, needed, opposite);
                    needed -= size;
                } else {
                    size = lc.resizePaneShrink(type2, needed);
                    needed += size;
                }
                if (size != 0) continue;
            }
            this.fixOffsets();
            this.fixPanes();
        }

        int resizePaneGrow(Type type2, int needed, boolean opposite) {
            Layout lcremove;
            int size = 0;
            Layout lcadd = this;
            for (lcremove = this.nextSibling(); lcremove != null && (size = lcremove.resizeCheck(type2)) <= 0; lcremove = lcremove.nextSibling()) {
            }
            if (opposite && lcremove == null) {
                for (lcremove = this.prevSibling(); lcremove != null && (size = lcremove.resizeCheck(type2)) <= 0; lcremove = lcremove.prevSibling()) {
                }
            }
            if (lcremove == null) {
                return 0;
            }
            if (size > needed) {
                size = needed;
            }
            lcadd.resizeAdjust(type2, size);
            lcremove.resizeAdjust(type2, -size);
            return size;
        }

        int resizePaneShrink(Type type2, int needed) {
            int size = 0;
            Layout lcremove = this;
            while ((size = lcremove.resizeCheck(type2)) <= 0 && (lcremove = lcremove.prevSibling()) != null) {
            }
            if (lcremove == null) {
                return 0;
            }
            Layout lcadd = this.nextSibling();
            if (lcadd == null) {
                return 0;
            }
            if (size > -needed) {
                size = -needed;
            }
            lcadd.resizeAdjust(type2, size);
            lcremove.resizeAdjust(type2, -size);
            return size;
        }

        Layout prevSibling() {
            int idx = this.parent.cells.indexOf(this);
            if (idx > 0) {
                return this.parent.cells.get(idx - 1);
            }
            return null;
        }

        Layout nextSibling() {
            int idx = this.parent.cells.indexOf(this);
            if (idx < this.parent.cells.size() - 1) {
                return this.parent.cells.get(idx + 1);
            }
            return null;
        }

        public void resizeTo(Type type2, int new_size) {
            Layout lc = this;
            Layout lcparent = lc.parent;
            while (lcparent != null && lcparent.type != type2) {
                lc = lcparent;
                lcparent = lc.parent;
            }
            if (lcparent == null) {
                return;
            }
            int size = type2 == Type.LeftRight ? lc.sx : lc.sy;
            int change = lc.nextSibling() == null ? size - new_size : new_size - size;
            lc.resize(type2, change, true);
        }

        public void resize(int sx, int sy) {
            int xchange = sx - this.sx;
            int xlimit = this.resizeCheck(Type.LeftRight);
            if (xchange < 0 && xchange < -xlimit) {
                xchange = -xlimit;
            }
            if (xlimit == 0) {
                xchange = sx <= this.sx ? 0 : sx - this.sx;
            }
            if (xchange != 0) {
                this.resizeAdjust(Type.LeftRight, xchange);
            }
            int ychange = sy - this.sy;
            int ylimit = this.resizeCheck(Type.TopBottom);
            if (ychange < 0 && ychange < -ylimit) {
                ychange = -ylimit;
            }
            if (ylimit == 0) {
                ychange = sy <= this.sy ? 0 : sy - this.sy;
            }
            if (ychange != 0) {
                this.resizeAdjust(Type.TopBottom, ychange);
            }
            this.fixOffsets();
            this.fixPanes(sx, sy);
        }

        public void remove() {
            if (this.parent == null) {
                throw new IllegalStateException();
            }
            int idx = this.parent.cells.indexOf(this);
            Layout other = this.parent.cells.get(idx == 0 ? 1 : idx - 1);
            other.resizeAdjust(this.parent.type, this.parent.type == Type.LeftRight ? this.sx + 1 : this.sy + 1);
            this.parent.cells.remove(this);
            if (other.parent.cells.size() == 1) {
                if (other.parent.parent == null) {
                    other.parent = null;
                } else {
                    other.parent.parent.cells.set(other.parent.parent.cells.indexOf(other.parent), other);
                    other.parent = other.parent.parent;
                }
            }
        }

        private int resizeCheck(Type type2) {
            if (this.type == Type.WindowPane) {
                int avail;
                int min = 3;
                if (type2 == Type.LeftRight) {
                    avail = this.sx;
                } else {
                    avail = this.sy;
                    ++min;
                }
                avail = avail > min ? (avail -= min) : 0;
                return avail;
            }
            if (this.type == type2) {
                return this.cells.stream().mapToInt(c -> c.resizeCheck(type2)).sum();
            }
            return this.cells.stream().mapToInt(c -> c.resizeCheck(type2)).min().orElse(Integer.MAX_VALUE);
        }

        private void resizeAdjust(Type type2, int change) {
            if (type2 == Type.LeftRight) {
                this.sx += change;
            } else {
                this.sy += change;
            }
            if (this.type == Type.WindowPane) {
                return;
            }
            if (this.type != type2) {
                for (Layout c : this.cells) {
                    c.resizeAdjust(type2, change);
                }
                return;
            }
            block1: while (change != 0) {
                for (Layout c : this.cells) {
                    if (change == 0) continue block1;
                    if (change > 0) {
                        c.resizeAdjust(type2, 1);
                        --change;
                        continue;
                    }
                    if (c.resizeCheck(type2) <= 0) continue;
                    c.resizeAdjust(type2, -1);
                    ++change;
                }
            }
        }

        public void fixOffsets() {
            block3: {
                block2: {
                    if (this.type != Type.LeftRight) break block2;
                    int xoff = this.xoff;
                    for (Layout cell : this.cells) {
                        cell.xoff = xoff;
                        cell.yoff = this.yoff;
                        cell.fixOffsets();
                        xoff += cell.sx + 1;
                    }
                    break block3;
                }
                if (this.type != Type.TopBottom) break block3;
                int yoff = this.yoff;
                for (Layout cell : this.cells) {
                    cell.xoff = this.xoff;
                    cell.yoff = yoff;
                    cell.fixOffsets();
                    yoff += cell.sy + 1;
                }
            }
        }

        public void fixPanes() {
        }

        public void fixPanes(int sx, int sy) {
        }

        public int countCells() {
            switch (this.type) {
                case TopBottom: 
                case LeftRight: {
                    return this.cells.stream().mapToInt(Layout::countCells).sum();
                }
            }
            return 1;
        }

        public Layout split(Type type2, int size, boolean insertBefore) {
            Layout cell2;
            Layout cell1;
            int size2;
            int saved_size;
            if (type2 == Type.WindowPane) {
                throw new IllegalStateException();
            }
            if ((type2 == Type.LeftRight ? this.sx : this.sy) < 7) {
                return null;
            }
            if (this.parent == null) {
                throw new IllegalStateException();
            }
            int n = saved_size = type2 == Type.LeftRight ? this.sx : this.sy;
            int n2 = size < 0 ? (saved_size + 1) / 2 - 1 : (size2 = insertBefore ? saved_size - size - 1 : size);
            if (size2 < 3) {
                size2 = 3;
            } else if (size2 > saved_size - 2) {
                size2 = saved_size - 2;
            }
            int size1 = saved_size - 1 - size2;
            if (this.parent.type != type2) {
                Layout p = new Layout();
                p.type = type2;
                p.parent = this.parent;
                p.sx = this.sx;
                p.sy = this.sy;
                p.xoff = this.xoff;
                p.yoff = this.yoff;
                this.parent.cells.set(this.parent.cells.indexOf(this), p);
                p.cells.add(this);
                this.parent = p;
            }
            Layout cell = new Layout();
            cell.type = Type.WindowPane;
            cell.parent = this.parent;
            this.parent.cells.add(this.parent.cells.indexOf(this) + (insertBefore ? 0 : 1), cell);
            int sx = this.sx;
            int sy = this.sy;
            int xoff = this.xoff;
            int yoff = this.yoff;
            if (insertBefore) {
                cell1 = cell;
                cell2 = this;
            } else {
                cell1 = this;
                cell2 = cell;
            }
            if (type2 == Type.LeftRight) {
                cell1.setSize(size1, sy, xoff, yoff);
                cell2.setSize(size2, sy, xoff + size1 + 1, yoff);
            } else {
                cell1.setSize(sx, size1, xoff, yoff);
                cell2.setSize(sx, size2, xoff, yoff + size1 + 1);
            }
            return cell;
        }

        private void setSize(int sx, int sy, int xoff, int yoff) {
            this.sx = sx;
            this.sy = sy;
            this.xoff = xoff;
            this.yoff = yoff;
        }

        private static int checksum(CharSequence layout) {
            return Layout.checksum(layout, 0);
        }

        private static int checksum(CharSequence layout, int start) {
            int csum = 0;
            for (int i2 = start; i2 < layout.length(); ++i2) {
                csum = (csum >> 1) + ((csum & 1) << 15);
                csum += layout.charAt(i2);
            }
            return csum;
        }

        private static Layout parseCell(Layout parent2, String layout) {
            Matcher matcher = PATTERN.matcher(layout);
            if (matcher.matches()) {
                int i2;
                Layout cell = new Layout();
                cell.type = Type.WindowPane;
                cell.parent = parent2;
                cell.sx = Integer.parseInt(matcher.group(1));
                cell.sy = Integer.parseInt(matcher.group(2));
                cell.xoff = Integer.parseInt(matcher.group(3));
                cell.yoff = Integer.parseInt(matcher.group(4));
                if (parent2 != null) {
                    parent2.cells.add(cell);
                }
                if ((layout = matcher.group(5)) == null || layout.isEmpty()) {
                    return cell;
                }
                if (layout.charAt(0) == ',') {
                    for (i2 = 1; i2 < layout.length() && Character.isDigit(layout.charAt(i2)); ++i2) {
                    }
                    if (i2 == layout.length()) {
                        return cell;
                    }
                    if (layout.charAt(i2) == ',') {
                        layout = layout.substring(i2);
                    }
                }
                switch (layout.charAt(0)) {
                    case '{': {
                        cell.type = Type.LeftRight;
                        i2 = Tmux.findMatch(layout, '{', '}');
                        Layout.parseCell(cell, layout.substring(1, i2));
                        layout = layout.substring(i2 + 1);
                        if (!layout.isEmpty() && layout.charAt(0) == ',') {
                            Layout.parseCell(parent2, layout.substring(1));
                        }
                        return cell;
                    }
                    case '[': {
                        cell.type = Type.TopBottom;
                        i2 = Tmux.findMatch(layout, '[', ']');
                        Layout.parseCell(cell, layout.substring(1, i2));
                        layout = layout.substring(i2 + 1);
                        if (!layout.isEmpty() && layout.charAt(0) == ',') {
                            Layout.parseCell(parent2, layout.substring(1));
                        }
                        return cell;
                    }
                    case ',': {
                        Layout.parseCell(parent2, layout.substring(1));
                        return cell;
                    }
                }
                throw new IllegalArgumentException("Unexpected '" + layout.charAt(0) + "'");
            }
            throw new IllegalArgumentException("Bad syntax");
        }

        static enum Type {
            LeftRight,
            TopBottom,
            WindowPane;

        }
    }

    static enum Binding {
        Discard,
        SelfInsert,
        Mouse;

    }
}

