/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.deserialization.LibraryPathFilter;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.deserialization.MultipleModuleDataProvider;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/MultipleModuleDataProvider;", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "moduleDataWithFilters", "", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "Lorg/jetbrains/kotlin/fir/deserialization/LibraryPathFilter;", "(Ljava/util/Map;)V", "allModuleData", "", "getAllModuleData", "()Ljava/util/Collection;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getModuleData", "path", "Ljava/nio/file/Path;", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nModuleDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDataProvider.kt\norg/jetbrains/kotlin/fir/deserialization/MultipleModuleDataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,71:1\n1#2:72\n204#3,10:73\n204#3,10:83\n*S KotlinDebug\n*F\n+ 1 ModuleDataProvider.kt\norg/jetbrains/kotlin/fir/deserialization/MultipleModuleDataProvider\n*L\n38#1:73,10\n41#1:83,10\n*E\n"})
public final class MultipleModuleDataProvider
extends ModuleDataProvider {
    @NotNull
    private final Map<FirModuleData, LibraryPathFilter> moduleDataWithFilters;
    @NotNull
    private final TargetPlatform platform;
    @NotNull
    private final PlatformDependentAnalyzerServices analyzerServices;

    public MultipleModuleDataProvider(@NotNull Map<FirModuleData, ? extends LibraryPathFilter> moduleDataWithFilters) {
        boolean bl;
        block6: {
            boolean bl2;
            Object value$iv;
            FirModuleData it;
            Object firstValue$iv;
            FirModuleData it2;
            Iterator iterator$iv;
            boolean $i$f$same;
            Iterable $this$same$iv;
            block5: {
                Intrinsics.checkNotNullParameter(moduleDataWithFilters, (String)"moduleDataWithFilters");
                this.moduleDataWithFilters = moduleDataWithFilters;
                if (!(!this.moduleDataWithFilters.isEmpty())) {
                    boolean $i$a$-require-MultipleModuleDataProvider$22 = false;
                    String $i$a$-require-MultipleModuleDataProvider$22 = "ModuleDataProvider must contain at least one module data";
                    throw new IllegalArgumentException($i$a$-require-MultipleModuleDataProvider$22.toString());
                }
                $this$same$iv = this.moduleDataWithFilters.keySet();
                $i$f$same = false;
                iterator$iv = $this$same$iv.iterator();
                it2 = (FirModuleData)iterator$iv.next();
                boolean bl3 = false;
                firstValue$iv = it2.getPlatform();
                while (iterator$iv.hasNext()) {
                    Object item$iv = iterator$iv.next();
                    it = (FirModuleData)item$iv;
                    $i$a$-same-MultipleModuleDataProvider$2 = false;
                    value$iv = it.getPlatform();
                    if (Intrinsics.areEqual((Object)value$iv, (Object)firstValue$iv)) continue;
                    bl2 = false;
                    break block5;
                }
                bl2 = true;
            }
            if (!bl2) {
                boolean $i$a$-require-MultipleModuleDataProvider$42 = false;
                String $i$a$-require-MultipleModuleDataProvider$42 = "All module data should have same target platform, but was: " + CollectionsKt.joinToString$default((Iterable)this.moduleDataWithFilters.keySet(), null, null, null, (int)0, null, (Function1)3.1.INSTANCE, (int)31, null);
                throw new IllegalArgumentException($i$a$-require-MultipleModuleDataProvider$42.toString());
            }
            $this$same$iv = this.moduleDataWithFilters.keySet();
            $i$f$same = false;
            iterator$iv = $this$same$iv.iterator();
            it2 = (FirModuleData)iterator$iv.next();
            boolean bl4 = false;
            firstValue$iv = it2.getAnalyzerServices();
            while (iterator$iv.hasNext()) {
                Object item$iv = iterator$iv.next();
                it = (FirModuleData)item$iv;
                $i$a$-same-MultipleModuleDataProvider$4 = false;
                value$iv = it.getAnalyzerServices();
                if (Intrinsics.areEqual((Object)value$iv, (Object)firstValue$iv)) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl5 = false;
            String string2 = "All module data should have same analyzerServices, but was: " + CollectionsKt.joinToString$default((Iterable)this.moduleDataWithFilters.keySet(), null, null, null, (int)0, null, (Function1)5.1.INSTANCE, (int)31, null);
            throw new IllegalArgumentException(string2.toString());
        }
        this.platform = ((FirModuleData)CollectionsKt.first((Iterable)this.getAllModuleData())).getPlatform();
        this.analyzerServices = ((FirModuleData)CollectionsKt.first((Iterable)this.getAllModuleData())).getAnalyzerServices();
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.platform;
    }

    @Override
    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.analyzerServices;
    }

    @Override
    @NotNull
    public Collection<FirModuleData> getAllModuleData() {
        return this.moduleDataWithFilters.keySet();
    }

    @Override
    @Nullable
    public FirModuleData getModuleData(@Nullable Path path2) {
        for (Map.Entry<FirModuleData, LibraryPathFilter> entry : this.moduleDataWithFilters.entrySet()) {
            FirModuleData session2 = entry.getKey();
            LibraryPathFilter filter2 = entry.getValue();
            if (!filter2.accepts(path2)) continue;
            return session2;
        }
        return null;
    }
}

