/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u001a\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a-\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017H\u0082\b\u001a\\\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u001a\b\u0002\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0\u00172\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE", "", "MAX_PORT_NUMBER", "", "getMAX_PORT_NUMBER", "()I", "ORPHANED_RUN_FILE_AGE_THRESHOLD_MS", "", "validFlagFileKeywordChars", "makeAutodeletingFlagFile", "Ljava/io/File;", "keyword", "baseDir", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "digest", "makeRunFilenameString", "timestamp", "port", "escapeSequence", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "walkDaemons", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/daemon/common/DaemonWithMetadata;", "registryDir", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "fileToCompareTimestamp", "filter", "", "daemon-common"})
@SourceDebugExtension(value={"SMAP\nClientUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientUtils.kt\norg/jetbrains/kotlin/daemon/common/ClientUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,135:1\n429#2:136\n502#2,5:137\n*S KotlinDebug\n*F\n+ 1 ClientUtils.kt\norg/jetbrains/kotlin/daemon/common/ClientUtilsKt\n*L\n110#1:136\n110#1:137,5\n*E\n"})
public final class ClientUtilsKt {
    private static final int MAX_PORT_NUMBER = 65535;
    private static final long ORPHANED_RUN_FILE_AGE_THRESHOLD_MS = 1000000L;
    @NotNull
    private static final String validFlagFileKeywordChars = "abcdefghijklmnopqrstuvwxyz0123456789-_";
    @NotNull
    public static final String LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE = "Assuming other daemons have";

    public static final int getMAX_PORT_NUMBER() {
        return MAX_PORT_NUMBER;
    }

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)escapeSequence, (String)"escapeSequence");
        return "kotlin-daemon" + escapeSequence + '.' + timestamp + escapeSequence + '.' + digest + escapeSequence + '.' + port + escapeSequence + ".run";
    }

    public static /* synthetic */ String makeRunFilenameString$default(String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 8) != 0) {
            string5 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string2, string3, string4, string5);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Regex regex = new Regex(ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\"));
        return (Function1)new Function1<String, Integer>(regex){
            final /* synthetic */ Regex $regex;
            {
                this.$regex = $regex;
                super(1);
            }

            @Nullable
            public final Integer invoke(@NotNull String it) {
                String string2;
                MatchGroup matchGroup;
                MatchGroupCollection matchGroupCollection;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MatchResult matchResult = Regex.find$default((Regex)this.$regex, (CharSequence)it, (int)0, (int)2, null);
                return matchResult != null && (matchGroupCollection = matchResult.getGroups()) != null && (matchGroup = matchGroupCollection.get(1)) != null && (string2 = matchGroup.getValue()) != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
            }
        };
    }

    @NotNull
    public static final Sequence<DaemonWithMetadata> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull File fileToCompareTimestamp, @NotNull Function2<? super File, ? super Integer, Boolean> filter2, @NotNull Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        Intrinsics.checkNotNullParameter((Object)registryDir, (String)"registryDir");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)fileToCompareTimestamp, (String)"fileToCompareTimestamp");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(report2, (String)"report");
        String classPathDigest = compilerId.digest();
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)((Sequence)FilesKt.walk$default((File)registryDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(portExtractor){
            final /* synthetic */ Function1<String, Integer> $portExtractor;
            {
                this.$portExtractor = $portExtractor;
                super(1);
            }

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                return new Pair((Object)it, this.$portExtractor.invoke((Object)string2));
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, Boolean>(filter2){
            final /* synthetic */ Function2<File, Integer, Boolean> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<? extends File, Integer> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                File file2 = (File)pair.component1();
                Integer port = (Integer)pair.component2();
                return port != null && (Boolean)this.$filter.invoke((Object)file2, (Object)port) != false;
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, DaemonWithMetadata>(fileToCompareTimestamp, report2){
            final /* synthetic */ File $fileToCompareTimestamp;
            final /* synthetic */ Function2<DaemonReportCategory, String, Unit> $report;
            {
                this.$fileToCompareTimestamp = $fileToCompareTimestamp;
                this.$report = $report;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final DaemonWithMetadata invoke(@NotNull Pair<? extends File, Integer> pair) {
                DaemonWithMetadata daemonWithMetadata;
                CompileService daemon;
                long relativeAge;
                File file2;
                block15: {
                    CompileService compileService;
                    block14: {
                        Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                        file2 = (File)pair.component1();
                        Integer port = (Integer)pair.component2();
                        int n = ClientUtilsKt.getMAX_PORT_NUMBER() - 1;
                        Integer n2 = port;
                        Intrinsics.checkNotNull((Object)n2);
                        int n3 = n2;
                        int n4 = 1 <= n3 ? (n3 <= n ? 1 : 0) : (n = 0);
                        if (_Assertions.ENABLED && n == 0) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        relativeAge = this.$fileToCompareTimestamp.lastModified() - file2.lastModified();
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found daemon on port " + port + " (" + relativeAge + " ms old), trying to connect"));
                        int n5 = port;
                        Function2<DaemonReportCategory, String, Unit> report$iv = this.$report;
                        boolean $i$f$tryConnectToDaemon = false;
                        try {
                            void port$iv;
                            Remote remote = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), (int)port$iv, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
                            Remote daemon$iv = remote != null ? remote.lookup("KotlinJvmCompilerService") : null;
                            remote = daemon$iv;
                            if (remote == null) {
                                report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)"daemon not found");
                                break block14;
                            }
                            if (remote instanceof CompileService) {
                                compileService = (CompileService)daemon$iv;
                                break block15;
                            }
                            report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)("Unable to cast compiler service, actual class received: " + daemon$iv.getClass().getName()));
                        }
                        catch (Throwable e$iv) {
                            StringBuilder stringBuilder2 = new StringBuilder().append("cannot connect to registry: ");
                            Object object = e$iv.getCause();
                            if ((object == null || (object = ((Throwable)object).getMessage()) == null) && (object = e$iv.getMessage()) == null) {
                                object = "unknown error";
                            }
                            report$iv.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)stringBuilder2.append((String)object).toString());
                        }
                    }
                    compileService = daemon = null;
                }
                if (daemon == null) {
                    if (relativeAge - 1000000L <= 0L) {
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found fresh run file '" + file2.getAbsolutePath() + "' (" + relativeAge + " ms old), but no daemon, ignoring it"));
                    } else {
                        this.$report.invoke((Object)((Object)DaemonReportCategory.DEBUG), (Object)("found seemingly orphaned run file '" + file2.getAbsolutePath() + "' (" + relativeAge + " ms old), deleting it"));
                        if (!file2.delete()) {
                            this.$report.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)("WARNING: unable to delete seemingly orphaned file '" + file2.getAbsolutePath() + "', cleanup recommended"));
                        }
                    }
                }
                try {
                    DaemonWithMetadata daemonWithMetadata2;
                    CompileService compileService = daemon;
                    if (compileService != null) {
                        CompileService it = compileService;
                        boolean bl = false;
                        daemonWithMetadata2 = new DaemonWithMetadata(it, file2, it.getDaemonJVMOptions().get());
                    } else {
                        daemonWithMetadata2 = null;
                    }
                    daemonWithMetadata = daemonWithMetadata2;
                }
                catch (Exception e) {
                    this.$report.invoke((Object)((Object)DaemonReportCategory.INFO), (Object)("ERROR: unable to retrieve daemon JVM options, assuming daemon is dead: " + e.getMessage()));
                    daemonWithMetadata = null;
                }
                return daemonWithMetadata;
            }
        }));
    }

    public static /* synthetic */ Sequence walkDaemons$default(File file2, CompilerId compilerId, File file3, Function2 function2, Function2 function22, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = walkDaemons.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = walkDaemons.2.INSTANCE;
        }
        return ClientUtilsKt.walkDaemons(file2, compilerId, file3, (Function2<? super File, ? super Integer, Boolean>)function2, (Function2<? super DaemonReportCategory, ? super String, Unit>)function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        boolean $i$f$tryConnectToDaemon = false;
        try {
            Remote remote = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
            Remote daemon = remote != null ? remote.lookup("KotlinJvmCompilerService") : null;
            remote = daemon;
            if (remote == null) {
                report2.invoke((Object)DaemonReportCategory.INFO, (Object)"daemon not found");
            } else {
                if (remote instanceof CompileService) {
                    return (CompileService)daemon;
                }
                report2.invoke((Object)DaemonReportCategory.INFO, (Object)("Unable to cast compiler service, actual class received: " + daemon.getClass().getName()));
            }
        }
        catch (Throwable e) {
            StringBuilder stringBuilder2 = new StringBuilder().append("cannot connect to registry: ");
            Object object = e.getCause();
            if ((object == null || (object = ((Throwable)object).getMessage()) == null) && (object = e.getMessage()) == null) {
                object = "unknown error";
            }
            report2.invoke((Object)DaemonReportCategory.INFO, (Object)stringBuilder2.append((String)object).toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File makeAutodeletingFlagFile(@NotNull String keyword, @Nullable File baseDir) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        String string2 = keyword;
        StringBuilder stringBuilder2 = new StringBuilder().append("kotlin-");
        boolean $i$f$filter = false;
        CharSequence charSequence2 = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)validFlagFileKeywordChars, (char)Character.toLowerCase(it), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string3 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"filterTo(StringBuilder(), predicate).toString()");
        String prefix = stringBuilder2.append(string3).append('-').toString();
        File file2 = baseDir;
        File flagFile = (file2 != null ? file2.isDirectory() : false) ? Files.createTempFile(baseDir.toPath(), prefix, "-is-running", new FileAttribute[0]).toFile() : Files.createTempFile(prefix, "-is-running", new FileAttribute[0]).toFile();
        flagFile.deleteOnExit();
        Intrinsics.checkNotNullExpressionValue((Object)flagFile, (String)"flagFile");
        return flagFile;
    }

    public static /* synthetic */ File makeAutodeletingFlagFile$default(String string2, File file2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "compiler-client";
        }
        if ((n & 2) != 0) {
            file2 = null;
        }
        return ClientUtilsKt.makeAutodeletingFlagFile(string2, file2);
    }
}

