/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ByteArrayCharSequence;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipImplementationKt$WhenMappings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e*\u00020\u0007\u001a\u0018\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010*\u00020\u0007H\u0002\u001a\u0018\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010*\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"END_OF_CENTRAL_DIR_SIZE", "", "END_OF_CENTRAL_DIR_ZIP64_SIZE", "LOCAL_FILE_HEADER_EXTRA_OFFSET", "LOCAL_FILE_HEADER_SIZE", "contentsToByteArray", "", "Ljava/nio/MappedByteBuffer;", "zipEntryDescription", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription;", "getUnsignedShort", "Ljava/nio/ByteBuffer;", "offset", "parseCentralDirectory", "", "parseCentralDirectoryRecordsNumberAndOffset", "Lkotlin/Pair;", "parseZip64CentralDirectoryRecordsNumberAndOffset", "cli-base"})
@SourceDebugExtension(value={"SMAP\nZipImplementation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipImplementation.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipImplementationKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,166:1\n12285#2,2:167\n*E\n*S KotlinDebug\n*F\n+ 1 ZipImplementation.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipImplementationKt\n*L\n97#1,2:167\n*E\n"})
public final class ZipImplementationKt {
    private static final int END_OF_CENTRAL_DIR_SIZE = 22;
    private static final int END_OF_CENTRAL_DIR_ZIP64_SIZE = 56;
    private static final int LOCAL_FILE_HEADER_EXTRA_OFFSET = 28;
    private static final int LOCAL_FILE_HEADER_SIZE = 30;

    @NotNull
    public static final byte[] contentsToByteArray(@NotNull MappedByteBuffer $this$contentsToByteArray, @NotNull ZipEntryDescription zipEntryDescription) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$contentsToByteArray, (String)"$this$contentsToByteArray");
        Intrinsics.checkNotNullParameter((Object)zipEntryDescription, (String)"zipEntryDescription");
        $this$contentsToByteArray.order(ByteOrder.LITTLE_ENDIAN);
        int extraSize = ZipImplementationKt.getUnsignedShort($this$contentsToByteArray, zipEntryDescription.getOffsetInFile() + 28);
        $this$contentsToByteArray.position(zipEntryDescription.getOffsetInFile() + 30 + zipEntryDescription.getFileNameSize() + extraSize);
        byte[] compressed = new byte[zipEntryDescription.getCompressedSize() + 1];
        $this$contentsToByteArray.get(compressed, 0, zipEntryDescription.getCompressedSize());
        switch (ZipImplementationKt$WhenMappings.$EnumSwitchMapping$0[zipEntryDescription.getCompressionKind().ordinal()]) {
            case 1: {
                Inflater inflater = new Inflater(true);
                inflater.setInput(compressed, 0, zipEntryDescription.getCompressedSize());
                byte[] result2 = new byte[zipEntryDescription.getUncompressedSize()];
                inflater.inflate(result2);
                byArray = result2;
                break;
            }
            case 2: {
                byte[] byArray2 = compressed;
                int n = zipEntryDescription.getCompressedSize();
                byte[] byArray3 = Arrays.copyOf(byArray2, n);
                byArray = byArray3;
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, newSize)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ZipEntryDescription> parseCentralDirectory(@NotNull MappedByteBuffer $this$parseCentralDirectory) {
        void entriesNumber;
        int offsetOfCentralDirectory;
        Intrinsics.checkNotNullParameter((Object)$this$parseCentralDirectory, (String)"$this$parseCentralDirectory");
        $this$parseCentralDirectory.order(ByteOrder.LITTLE_ENDIAN);
        Pair<Integer, Integer> pair = ZipImplementationKt.parseCentralDirectoryRecordsNumberAndOffset($this$parseCentralDirectory);
        int n = ((Number)pair.component1()).intValue();
        int currentOffset = offsetOfCentralDirectory = ((Number)pair.component2()).intValue();
        List result2 = new ArrayList();
        boolean bl = false;
        void var6_7 = entriesNumber;
        while (bl < var6_7) {
            ZipEntryDescription.CompressionKind compressionKind;
            CharSequence charSequence2;
            boolean bl2;
            Object $this$all$iv2;
            byte[] bytesForName;
            int offsetOfFileData;
            int fileCommentLength;
            int extraLength;
            int fileNameLength;
            int uncompressedSize;
            int compressedSize;
            short compressionMethod;
            short versionNeededToExtract;
            void i2;
            block10: {
                boolean bl3;
                int headerConst = $this$parseCentralDirectory.getInt(currentOffset);
                boolean bl4 = bl3 = headerConst == 33639248;
                if (!bl3) {
                    boolean $i$a$-require-ZipImplementationKt$parseCentralDirectory$32 = false;
                    String $i$a$-require-ZipImplementationKt$parseCentralDirectory$32 = (int)i2 + ": " + headerConst;
                    throw new IllegalArgumentException($i$a$-require-ZipImplementationKt$parseCentralDirectory$32.toString());
                }
                versionNeededToExtract = $this$parseCentralDirectory.getShort(currentOffset + 6);
                compressionMethod = $this$parseCentralDirectory.getShort(currentOffset + 10);
                compressedSize = $this$parseCentralDirectory.getInt(currentOffset + 20);
                uncompressedSize = $this$parseCentralDirectory.getInt(currentOffset + 24);
                fileNameLength = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectory, currentOffset + 28);
                extraLength = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectory, currentOffset + 30);
                fileCommentLength = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectory, currentOffset + 32);
                offsetOfFileData = $this$parseCentralDirectory.getInt(currentOffset + 42);
                bytesForName = new byte[fileNameLength];
                $this$parseCentralDirectory.position(currentOffset + 46);
                $this$parseCentralDirectory.get(bytesForName);
                $this$all$iv2 = bytesForName;
                boolean $i$f$all = false;
                int n2 = ((byte[])$this$all$iv2).length;
                for (int j = 0; j < n2; ++j) {
                    byte element$iv;
                    byte it = element$iv = $this$all$iv2[j];
                    boolean bl5 = false;
                    if (it >= 0) continue;
                    bl2 = false;
                    break block10;
                }
                bl2 = true;
            }
            if (bl2) {
                charSequence2 = new ByteArrayCharSequence(bytesForName, 0, 0, 6, null);
            } else {
                $this$all$iv2 = Charsets.UTF_8;
                charSequence2 = new String(bytesForName, (Charset)$this$all$iv2);
            }
            CharSequence name2 = charSequence2;
            currentOffset += 46 + fileNameLength + extraLength + fileCommentLength;
            short $this$all$iv2 = versionNeededToExtract;
            short s = $this$all$iv2 = 0 <= $this$all$iv2 && 20 >= $this$all$iv2 ? (short)1 : 0;
            if ($this$all$iv2 == 0) {
                boolean bl6 = false;
                String string2 = "Unexpected versionNeededToExtract (" + versionNeededToExtract + ") at " + name2;
                throw new IllegalArgumentException(string2.toString());
            }
            switch (compressionMethod) {
                case 0: {
                    compressionKind = ZipEntryDescription.CompressionKind.PLAIN;
                    break;
                }
                case 8: {
                    compressionKind = ZipEntryDescription.CompressionKind.DEFLATE;
                    break;
                }
                default: {
                    String string3 = "Unexpected compression method (" + compressionMethod + ") at " + name2;
                    throw new IllegalStateException(string3.toString());
                }
            }
            ZipEntryDescription.CompressionKind compressionKind2 = compressionKind;
            Collection collection = result2;
            ZipEntryDescription zipEntryDescription = new ZipEntryDescription(name2, compressedSize, uncompressedSize, offsetOfFileData, compressionKind2, fileNameLength);
            collection.add(zipEntryDescription);
            ++i2;
        }
        return result2;
    }

    private static final Pair<Integer, Integer> parseCentralDirectoryRecordsNumberAndOffset(MappedByteBuffer $this$parseCentralDirectoryRecordsNumberAndOffset) {
        int endOfCentralDirectoryOffset;
        for (endOfCentralDirectoryOffset = $this$parseCentralDirectoryRecordsNumberAndOffset.capacity() - 22; endOfCentralDirectoryOffset >= 0 && $this$parseCentralDirectoryRecordsNumberAndOffset.getInt(endOfCentralDirectoryOffset) != 101010256; --endOfCentralDirectoryOffset) {
        }
        int entriesNumber = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectoryRecordsNumberAndOffset, endOfCentralDirectoryOffset + 10);
        int offsetOfCentralDirectory = $this$parseCentralDirectoryRecordsNumberAndOffset.getInt(endOfCentralDirectoryOffset + 16);
        if (entriesNumber == 65535 || offsetOfCentralDirectory == -1) {
            return ZipImplementationKt.parseZip64CentralDirectoryRecordsNumberAndOffset($this$parseCentralDirectoryRecordsNumberAndOffset);
        }
        return new Pair((Object)entriesNumber, (Object)offsetOfCentralDirectory);
    }

    private static final Pair<Integer, Integer> parseZip64CentralDirectoryRecordsNumberAndOffset(MappedByteBuffer $this$parseZip64CentralDirectoryRecordsNumberAndOffset) {
        boolean bl;
        int endOfCentralDirectoryOffset;
        for (endOfCentralDirectoryOffset = $this$parseZip64CentralDirectoryRecordsNumberAndOffset.capacity() - 56; endOfCentralDirectoryOffset >= 0 && $this$parseZip64CentralDirectoryRecordsNumberAndOffset.getInt(endOfCentralDirectoryOffset) != 101075792; --endOfCentralDirectoryOffset) {
        }
        long entriesNumber = $this$parseZip64CentralDirectoryRecordsNumberAndOffset.getLong(endOfCentralDirectoryOffset + 32);
        long offsetOfCentralDirectory = $this$parseZip64CentralDirectoryRecordsNumberAndOffset.getLong(endOfCentralDirectoryOffset + 48);
        boolean bl2 = bl = entriesNumber <= (long)Integer.MAX_VALUE;
        if (!bl) {
            boolean $i$a$-require-ZipImplementationKt$parseZip64CentralDirectoryRecordsNumberAndOffset$32 = false;
            String $i$a$-require-ZipImplementationKt$parseZip64CentralDirectoryRecordsNumberAndOffset$32 = "Jar " + entriesNumber + " entries number equal or more than 2147483647 is not supported by FastJarFS";
            throw new IllegalArgumentException($i$a$-require-ZipImplementationKt$parseZip64CentralDirectoryRecordsNumberAndOffset$32.toString());
        }
        boolean bl3 = bl = offsetOfCentralDirectory <= (long)Integer.MAX_VALUE;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Jar " + offsetOfCentralDirectory + " offset equal or more than 2147483647 is not supported by FastJarFS";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Pair((Object)((int)entriesNumber), (Object)((int)offsetOfCentralDirectory));
    }

    private static final int getUnsignedShort(ByteBuffer $this$getUnsignedShort, int offset2) {
        return Short.toUnsignedInt($this$getUnsignedShort.getShort(offset2));
    }
}

