/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CountDownConsumer;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.MessageError;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseValue;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.Promises__PromiseKt;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;

@Metadata(mv={1, 8, 0}, k=5, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00010\u001f2\u0006\u0010 \u001a\u00020!\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d\u001a\u001e\u0010#\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010$\u001a\u00020!2\b\b\u0002\u0010%\u001a\u00020\u0019H\u0007\u001a\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0001\u001a\u001a\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010$\u001a\u00020!\u001a\u0012\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d\u001a\u001a\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u0006\u0010$\u001a\u00020!\u001a\u001c\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\b\u0010$\u001a\u0004\u0018\u00010)\u001a\u001f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010+\u001a\u0002H\u001d\u00a2\u0006\u0002\u0010,\u001a\u0012\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d\u001a\u001f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u0006\u0010+\u001a\u0002H\u001d\u00a2\u0006\u0002\u0010.\u001a(\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d2\u000e\b\u0004\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001d01H\u0086\b\u00f8\u0001\u0000\u001a\u0018\u00102\u001a\u0006\u0012\u0002\b\u00030\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u001f\u001a9\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u001f2\u0006\u00103\u001a\u0002H\u001d2\b\b\u0002\u00104\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u00105\u001a\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d07\u001a\u000e\u00106\u001a\u0006\u0012\u0002\b\u00030\u0001*\u000208\u001a8\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0:0\u0001\"\b\b\u0000\u0010\u001d*\u00020\u0002*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00010\u001f2\b\b\u0002\u00104\u001a\u00020\u0019H\u0007\u001a*\u0010;\u001a\u00020<\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0=2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001d01H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010>\u001a\u00020\u0019*\u00020?2\u0006\u0010@\u001a\u00020)\u001a:\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010B\u001a\u00020C2\u0014\b\u0004\u0010D\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020<0EH\u0086\b\u00f8\u0001\u0000\u001a@\u0010F\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010B\u001a\u00020C2\u0014\b\u0004\u0010D\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020<0EH\u0086\b\u00f8\u0001\u0000\u001a4\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010B\u001a\u00020C2\u000e\b\u0004\u0010D\u001a\b\u0012\u0004\u0012\u00020<01H\u0086\b\u00f8\u0001\u0000\u001a(\u0010H\u001a\u0006\u0012\u0002\b\u00030\u0001*\u0006\u0012\u0002\b\u00030\u00012\u000e\b\u0004\u0010D\u001a\b\u0012\u0004\u0012\u00020<01H\u0086\b\u00f8\u0001\u0000\u001aF\u0010I\u001a\b\u0012\u0004\u0012\u0002HJ0\u0001\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010J*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010K\u001a\u00020C2\u0014\b\u0004\u0010D\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002HJ0EH\u0086\b\u00f8\u0001\u0000\u001aL\u0010L\u001a\b\u0012\u0004\u0012\u0002HJ0\u0001\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010J*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010B\u001a\u00020C2\u001a\b\u0004\u0010D\u001a\u0014\u0012\u0004\u0012\u0002H\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002HJ0\u00010EH\u0086\b\u00f8\u0001\u0000\u001a>\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0018\b\u0004\u0010D\u001a\u0012\u0012\u0004\u0012\u0002H\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010EH\u0086\b\u00f8\u0001\u0000\u001aF\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010B\u001a\u00020C2\u0018\b\u0004\u0010D\u001a\u0012\u0012\u0004\u0012\u0002H\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010EH\u0086\b\u00f8\u0001\u0000\u001a0\u0010N\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\u0006\u0012\u0002\b\u00030\u00012\u000e\b\u0004\u0010D\u001a\b\u0012\u0004\u0012\u0002H\u001d01H\u0086\b\u00f8\u0001\u0000\u001a\u000e\u0010O\u001a\u00020P*\u0006\u0012\u0002\b\u00030\u0001\u001a\u0012\u0010Q\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001*\u00020P\")\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u001f\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\")\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\b\u0012\u0004\b\u000e\u0010\u0004\u001a\u0004\b\u000f\u0010\u0010\"\u001f\u0010\u0012\u001a\u00060\u0013j\u0002`\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016\"\u0019\u0010\u0018\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\"\u0019\u0010\u001b\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006R"}, d2={"CANCELLED_PROMISE", "Lorg/jetbrains/concurrency/Promise;", "", "getCANCELLED_PROMISE$annotations$Promises__PromiseKt", "()V", "getCANCELLED_PROMISE$Promises__PromiseKt", "()Lorg/jetbrains/concurrency/Promise;", "CANCELLED_PROMISE$delegate", "Lkotlin/Lazy;", "REJECTED", "getREJECTED$Promises__PromiseKt", "REJECTED$delegate", "fulfilledPromise", "Lorg/jetbrains/concurrency/CancellablePromise;", "getFulfilledPromise$annotations$Promises__PromiseKt", "getFulfilledPromise$Promises__PromiseKt", "()Lorg/jetbrains/concurrency/CancellablePromise;", "fulfilledPromise$delegate", "obsoleteError", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "getObsoleteError$Promises__PromiseKt", "()Ljava/lang/RuntimeException;", "obsoleteError$delegate", "isPending", "", "(Lorg/jetbrains/concurrency/Promise;)Z", "isRejected", "any", "T", "promises", "", "totalError", "", "cancelledPromise", "createError", "error", "log", "nullPromise", "rejectedCancellablePromise", "rejectedPromise", "", "resolvedCancellablePromise", "result", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/CancellablePromise;", "resolvedPromise", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "runAsync", "runnable", "Lkotlin/Function0;", "all", "totalResult", "ignoreErrors", "(Ljava/util/Collection;Ljava/lang/Object;Z)Lorg/jetbrains/concurrency/Promise;", "asPromise", "Ljava/util/concurrent/CompletableFuture;", "Lkotlinx/coroutines/Job;", "collectResults", "", "compute", "", "Lorg/jetbrains/concurrency/AsyncPromise;", "errorIfNotMessage", "Lcom/intellij/openapi/diagnostic/Logger;", "e", "onError", "node", "Lorg/jetbrains/concurrency/Obsolescent;", "handler", "Lkotlin/Function1;", "onSuccess", "processed", "processedRun", "then", "SUB_RESULT", "obsolescent", "thenAsync", "thenAsyncAccept", "thenRun", "toActionCallback", "Lcom/intellij/openapi/util/ActionCallback;", "toPromise", "intellij.platform.concurrency"}, xs="org/jetbrains/concurrency/Promises")
final class Promises__PromiseKt {
    @NotNull
    private static final Lazy obsoleteError$delegate = LazyKt.lazy((Function0)obsoleteError.2.INSTANCE);
    @NotNull
    private static final Lazy REJECTED$delegate = LazyKt.lazy((Function0)REJECTED.2.INSTANCE);
    @NotNull
    private static final Lazy fulfilledPromise$delegate = LazyKt.lazy((Function0)fulfilledPromise.2.INSTANCE);
    @NotNull
    private static final Lazy CANCELLED_PROMISE$delegate = LazyKt.lazy((Function0)CANCELLED_PROMISE.2.INSTANCE);

    private static final RuntimeException getObsoleteError$Promises__PromiseKt() {
        Lazy lazy = obsoleteError$delegate;
        return (RuntimeException)lazy.getValue();
    }

    public static final boolean isRejected(@NotNull Promise<?> $this$isRejected) {
        Intrinsics.checkNotNullParameter($this$isRejected, (String)"<this>");
        return $this$isRejected.getState() == Promise.State.REJECTED;
    }

    public static final boolean isPending(@NotNull Promise<?> $this$isPending) {
        Intrinsics.checkNotNullParameter($this$isPending, (String)"<this>");
        return $this$isPending.getState() == Promise.State.PENDING;
    }

    private static final Promise<?> getREJECTED$Promises__PromiseKt() {
        Lazy lazy = REJECTED$delegate;
        return (Promise)lazy.getValue();
    }

    private static final CancellablePromise<Object> getFulfilledPromise$Promises__PromiseKt() {
        Lazy lazy = fulfilledPromise$delegate;
        return (CancellablePromise)lazy.getValue();
    }

    private static /* synthetic */ void getFulfilledPromise$annotations$Promises__PromiseKt() {
    }

    @NotNull
    public static final <T> Promise<T> resolvedPromise() {
        CancellablePromise<Object> cancellablePromise = Promises__PromiseKt.getFulfilledPromise$Promises__PromiseKt();
        Intrinsics.checkNotNull(cancellablePromise, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.resolvedPromise>");
        return cancellablePromise;
    }

    @NotNull
    public static final Promise<?> nullPromise() {
        return Promises__PromiseKt.getFulfilledPromise$Promises__PromiseKt();
    }

    @NotNull
    public static final <T> Promise<T> resolvedPromise(T result2) {
        return Promises.resolvedCancellablePromise(result2);
    }

    @NotNull
    public static final <T> CancellablePromise<T> resolvedCancellablePromise(T result2) {
        CancellablePromise cancellablePromise;
        if (result2 == null) {
            CancellablePromise cancellablePromise2 = Promises__PromiseKt.getFulfilledPromise$Promises__PromiseKt();
            cancellablePromise = cancellablePromise2;
            Intrinsics.checkNotNull(cancellablePromise2, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.CancellablePromise<T of org.jetbrains.concurrency.Promises__PromiseKt.resolvedCancellablePromise>");
        } else {
            cancellablePromise = new DonePromise<T>(PromiseValue.Companion.createFulfilled(result2));
        }
        return cancellablePromise;
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise() {
        Promise<?> promise = Promises__PromiseKt.getREJECTED$Promises__PromiseKt();
        Intrinsics.checkNotNull(promise, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.rejectedPromise>");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return Promises.rejectedCancellablePromise(error);
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise(@Nullable Throwable error) {
        Promise promise;
        if (error == null) {
            Promise promise2 = Promises__PromiseKt.getREJECTED$Promises__PromiseKt();
            promise = promise2;
            Intrinsics.checkNotNull(promise2, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.rejectedPromise>");
        } else {
            promise = new DonePromise(PromiseValue.Companion.createRejected(error));
        }
        return promise;
    }

    @NotNull
    public static final <T> CancellablePromise<T> rejectedCancellablePromise(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return new DonePromise(PromiseValue.Companion.createRejected(Promises.createError(error, true)));
    }

    private static final Promise<Object> getCANCELLED_PROMISE$Promises__PromiseKt() {
        Lazy lazy = CANCELLED_PROMISE$delegate;
        return (Promise)lazy.getValue();
    }

    private static /* synthetic */ void getCANCELLED_PROMISE$annotations$Promises__PromiseKt() {
    }

    @NotNull
    public static final <T> Promise<T> cancelledPromise() {
        Promise<Object> promise = Promises__PromiseKt.getCANCELLED_PROMISE$Promises__PromiseKt();
        Intrinsics.checkNotNull(promise, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T of org.jetbrains.concurrency.Promises__PromiseKt.cancelledPromise>");
        return promise;
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Promise<T> $this$then, @NotNull Obsolescent obsolescent, @NotNull Function1<? super T, ? extends SUB_RESULT> handler) {
        Intrinsics.checkNotNullParameter($this$then, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)obsolescent, (String)"obsolescent");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$then = false;
        Promise promise = $this$then.then(new ObsolescentFunction<T, SUB_RESULT>(handler, obsolescent){
            final /* synthetic */ Function1<T, SUB_RESULT> $handler;
            final /* synthetic */ Obsolescent $obsolescent;
            {
                this.$handler = $handler;
                this.$obsolescent = $obsolescent;
            }

            public SUB_RESULT fun(T param) {
                return (SUB_RESULT)this.$handler.invoke(param);
            }

            public boolean isObsolete() {
                return this.$obsolescent.isObsolete();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"obsolescent: Obsolescent\u2026obsolescent.isObsolete\n})");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> onSuccess(@NotNull Promise<T> $this$onSuccess, @NotNull Obsolescent node, @NotNull Function1<? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter($this$onSuccess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$onSuccess = false;
        Promise<T> promise = $this$onSuccess.onSuccess(new ObsolescentConsumer<T>(node, handler){
            final /* synthetic */ Function1<T, Unit> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            public void accept(T param) {
                this.$handler.invoke(param);
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"node: Obsolescent, cross\u2026m: T) = handler(param)\n})");
        return promise;
    }

    @NotNull
    public static final Promise<Object> processed(@NotNull Promise<?> $this$processed, @NotNull Obsolescent node, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter($this$processed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$processed = false;
        Promise<Object> promise = $this$processed.onProcessed((Consumer)new ObsolescentConsumer<Object>(node, handler){
            final /* synthetic */ Function0<Unit> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            public void accept(@Nullable Object param) {
                this.$handler.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"node: Obsolescent, cross\u2026 Any?) = handler()\n    })");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> thenRun(@NotNull Promise<?> $this$thenRun, @NotNull Function0<? extends T> handler) {
        Intrinsics.checkNotNullParameter($this$thenRun, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$thenRun = false;
        Promise promise = $this$thenRun.then(new Function(handler){
            final /* synthetic */ Function0<T> $handler;
            {
                this.$handler = $handler;
            }

            public final T fun(@Nullable Object it) {
                return (T)this.$handler.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"crossinline handler: () \u2026Any?>).then { handler() }");
        return promise;
    }

    @NotNull
    public static final Promise<?> processedRun(@NotNull Promise<?> $this$processedRun, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter($this$processedRun, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$processedRun = false;
        Promise<?> promise = $this$processedRun.onProcessed(new Consumer(handler){
            final /* synthetic */ Function0<Unit> $handler;
            {
                this.$handler = $handler;
            }

            public final void accept(@Nullable Object it) {
                this.$handler.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"crossinline handler: () \u2026onProcessed { handler() }");
        return promise;
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Promise<T> $this$thenAsync, @NotNull Obsolescent node, @NotNull Function1<? super T, ? extends Promise<SUB_RESULT>> handler) {
        Intrinsics.checkNotNullParameter($this$thenAsync, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$thenAsync = false;
        Promise promise = $this$thenAsync.thenAsync(new ValueNodeAsyncFunction<T, SUB_RESULT>(node, handler){
            final /* synthetic */ Function1<T, Promise<SUB_RESULT>> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            @NotNull
            public Promise<SUB_RESULT> fun(T param) {
                return (Promise)this.$handler.invoke(param);
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"node: Obsolescent, cross\u2026m: T) = handler(param)\n})");
        return promise;
    }

    @NotNull
    public static final <T> Promise<Object> thenAsyncAccept(@NotNull Promise<T> $this$thenAsyncAccept, @NotNull Obsolescent node, @NotNull Function1<? super T, ? extends Promise<?>> handler) {
        Intrinsics.checkNotNullParameter($this$thenAsyncAccept, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$thenAsyncAccept = false;
        Promise<Object> promise = $this$thenAsyncAccept.thenAsync(new ValueNodeAsyncFunction<T, Object>(node, handler){
            final /* synthetic */ Function1<T, Promise<?>> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            @NotNull
            public Promise<Object> fun(T param) {
                Object object = this.$handler.invoke(param);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                return (Promise)object;
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"node: Obsolescent, cross\u2026am) as Promise<Any?>\n  })");
        return promise;
    }

    @NotNull
    public static final <T> Promise<Object> thenAsyncAccept(@NotNull Promise<T> $this$thenAsyncAccept, @NotNull Function1<? super T, ? extends Promise<?>> handler) {
        Intrinsics.checkNotNullParameter($this$thenAsyncAccept, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$thenAsyncAccept = false;
        Promise<Object> promise = $this$thenAsyncAccept.thenAsync(new Function(handler){
            final /* synthetic */ Function1<T, Promise<?>> $handler;
            {
                this.$handler = $handler;
            }

            public final Promise<Object> fun(T param) {
                Object object = this.$handler.invoke(param);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                return (Promise)object;
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"crossinline handler: (T)\u2026ram) as Promise<Any?>)\n})");
        return promise;
    }

    @NotNull
    public static final Promise<? extends Object> onError(@NotNull Promise<?> $this$onError, @NotNull Obsolescent node, @NotNull Function1<? super Throwable, Unit> handler) {
        Intrinsics.checkNotNullParameter($this$onError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$onError = false;
        Promise<?> promise = $this$onError.onError((Consumer<Throwable>)new ObsolescentConsumer<Throwable>(node, handler){
            final /* synthetic */ Function1<Throwable, Unit> $handler;
            {
                this.$handler = $handler;
                super($node);
            }

            public void accept(@NotNull Throwable param) {
                Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                this.$handler.invoke((Object)param);
            }
        });
        Intrinsics.checkNotNullExpressionValue(promise, (String)"node: Obsolescent, cross\u2026able) = handler(param)\n})");
        return promise;
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<List<T>> collectResults(@NotNull Collection<? extends Promise<T>> $this$collectResults, boolean ignoreErrors) {
        Intrinsics.checkNotNullParameter($this$collectResults, (String)"<this>");
        if ($this$collectResults.isEmpty()) {
            return Promises.resolvedPromise(CollectionsKt.emptyList());
        }
        AsyncPromise result2 = new AsyncPromise();
        AtomicInteger latch = new AtomicInteger($this$collectResults.size());
        List<Object> list = Collections.nCopies($this$collectResults.size(), null);
        Intrinsics.checkNotNullExpressionValue(list, (String)"nCopies<T?>(size, null)");
        List list2 = Collections.synchronizedList(CollectionsKt.toMutableList((Collection)list));
        Iterator<Promise<T>> iterator2 = $this$collectResults.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            Promise<Object> promise = iterator2.next();
            promise.onSuccess(arg_0 -> Promises__PromiseKt.collectResults$lambda$1$Promises__PromiseKt((Function1)new Function1<T, Unit>(list2, i2, latch, ignoreErrors, result2){
                final /* synthetic */ List<T> $list;
                final /* synthetic */ int $i;
                final /* synthetic */ AtomicInteger $latch;
                final /* synthetic */ boolean $ignoreErrors;
                final /* synthetic */ AsyncPromise<List<T>> $result;
                {
                    this.$list = $list;
                    this.$i = $i;
                    this.$latch = $latch;
                    this.$ignoreErrors = $ignoreErrors;
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(T it) {
                    this.$list.set(this.$i, it);
                    Promises__PromiseKt.access$collectResults$arrive(this.$latch, this.$ignoreErrors, this.$list, this.$result);
                }
            }, arg_0));
            promise.onError(arg_0 -> Promises__PromiseKt.collectResults$lambda$2$Promises__PromiseKt((Function1)new Function1<Throwable, Unit>(ignoreErrors, result2, latch, list2){
                final /* synthetic */ boolean $ignoreErrors;
                final /* synthetic */ AsyncPromise<List<T>> $result;
                final /* synthetic */ AtomicInteger $latch;
                final /* synthetic */ List<T> $list;
                {
                    this.$ignoreErrors = $ignoreErrors;
                    this.$result = $result;
                    this.$latch = $latch;
                    this.$list = $list;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    if (this.$ignoreErrors) {
                        Promises__PromiseKt.access$collectResults$arrive(this.$latch, this.$ignoreErrors, this.$list, this.$result);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.$result.setError(it);
                    }
                }
            }, arg_0));
        }
        return result2;
    }

    public static /* synthetic */ Promise collectResults$default(Collection collection, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return Promises.collectResults(collection, bl);
    }

    @JvmOverloads
    @NotNull
    public static final RuntimeException createError(@NotNull String error, boolean log) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return new MessageError(error, log);
    }

    public static /* synthetic */ RuntimeException createError$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Promises.createError(string2, bl);
    }

    public static final <T> void compute(@NotNull AsyncPromise<T> $this$compute, @NotNull Function0<? extends T> runnable) {
        Object object;
        Intrinsics.checkNotNullParameter($this$compute, (String)"<this>");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$compute = false;
        try {
            object = runnable.invoke();
        }
        catch (Throwable e) {
            $this$compute.setError(e);
            return;
        }
        Object result2 = object;
        $this$compute.setResult(result2);
    }

    @NotNull
    public static final <T> Promise<T> runAsync(@NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$runAsync = false;
        AsyncPromise promise = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(runnable, promise){
            final /* synthetic */ Function0<T> $runnable;
            final /* synthetic */ AsyncPromise<T> $promise;
            {
                this.$runnable = $runnable;
                this.$promise = $promise;
            }

            public final void run() {
                Object object;
                try {
                    object = this.$runnable.invoke();
                }
                catch (Throwable e) {
                    this.$promise.setError(e);
                    return;
                }
                Object result2 = object;
                this.$promise.setResult(result2);
            }
        });
        return promise;
    }

    public static final boolean errorIfNotMessage(@NotNull Logger $this$errorIfNotMessage, @NotNull Throwable e) {
        block5: {
            block3: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)$this$errorIfNotMessage, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!(e instanceof MessageError)) break block3;
                    ThreeState log = ((MessageError)e).getLog();
                    if (log == ThreeState.YES) break block4;
                    if (log != ThreeState.UNSURE) break block5;
                    Application application = ApplicationManager.getApplication();
                    boolean bl = application != null ? application.isUnitTestMode() : false;
                    if (!bl) break block5;
                }
                $this$errorIfNotMessage.error(e);
                return true;
            }
            if (!(e instanceof ControlFlowException) && !(e instanceof CancellationException)) {
                $this$errorIfNotMessage.error(e);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final <T> Promise<T> asPromise(@NotNull CompletableFuture<T> $this$asPromise) {
        Intrinsics.checkNotNullParameter($this$asPromise, (String)"<this>");
        AsyncPromise promise = new AsyncPromise();
        $this$asPromise.whenComplete((arg_0, arg_1) -> Promises__PromiseKt.asPromise$lambda$3$Promises__PromiseKt((Function2)new Function2<T, Throwable, Unit>(promise){
            final /* synthetic */ AsyncPromise<T> $promise;
            {
                this.$promise = $promise;
                super(2);
            }

            public final void invoke(T result2, Throwable throwable) {
                if (throwable == null) {
                    this.$promise.setResult(result2);
                } else {
                    this.$promise.setError(throwable);
                }
            }
        }, arg_0, arg_1));
        return promise;
    }

    @NotNull
    public static final Promise<?> asPromise(@NotNull Job $this$asPromise) {
        Intrinsics.checkNotNullParameter((Object)$this$asPromise, (String)"<this>");
        AsyncPromise<Object> promise = new AsyncPromise<Object>();
        promise.onError(arg_0 -> Promises__PromiseKt.asPromise$lambda$4$Promises__PromiseKt((Function1)new Function1<Throwable, Unit>($this$asPromise){
            final /* synthetic */ Job $this_asPromise;
            {
                this.$this_asPromise = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                CancellationException cancellationException = throwable instanceof CancellationException ? (CancellationException)throwable : null;
                if (cancellationException == null) {
                    cancellationException = ExceptionsKt.CancellationException("Promise was completed exceptionally", throwable);
                }
                CancellationException cancellationException2 = cancellationException;
                this.$this_asPromise.cancel(cancellationException2);
            }
        }, arg_0));
        $this$asPromise.invokeOnCompletion((Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(promise){
            final /* synthetic */ AsyncPromise<Object> $promise;
            {
                this.$promise = $promise;
                super(1);
            }

            public final void invoke(@Nullable Throwable throwable) {
                if (throwable == null) {
                    this.$promise.setResult(null);
                } else {
                    this.$promise.setError(throwable);
                }
            }
        }));
        return promise;
    }

    @NotNull
    public static final Promise<Object> toPromise(@NotNull ActionCallback $this$toPromise) {
        Intrinsics.checkNotNullParameter((Object)$this$toPromise, (String)"<this>");
        AsyncPromise<Object> promise = new AsyncPromise<Object>();
        $this$toPromise.doWhenDone(() -> Promises__PromiseKt.toPromise$lambda$5$Promises__PromiseKt(promise)).doWhenRejected(arg_0 -> Promises__PromiseKt.toPromise$lambda$6$Promises__PromiseKt((Function1)new Function1<String, Unit>(promise){
            final /* synthetic */ AsyncPromise<Object> $promise;
            {
                this.$promise = $promise;
                super(1);
            }

            public final void invoke(String error) {
                String string2 = error;
                if (string2 == null) {
                    string2 = "Internal error";
                }
                this.$promise.setError(Promises.createError$default(string2, false, 2, null));
            }
        }, arg_0));
        return promise;
    }

    @NotNull
    public static final ActionCallback toActionCallback(@NotNull Promise<?> $this$toActionCallback) {
        Intrinsics.checkNotNullParameter($this$toActionCallback, (String)"<this>");
        ActionCallback result2 = new ActionCallback();
        $this$toActionCallback.onSuccess(arg_0 -> Promises__PromiseKt.toActionCallback$lambda$7$Promises__PromiseKt(result2, arg_0));
        $this$toActionCallback.onError(arg_0 -> Promises__PromiseKt.toActionCallback$lambda$8$Promises__PromiseKt((Function1)new Function1<Throwable, Unit>(result2){
            final /* synthetic */ ActionCallback $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(Throwable it) {
                this.$result.setRejected();
            }
        }, arg_0));
        return result2;
    }

    @NotNull
    public static final Promise<?> all(@NotNull Collection<? extends Promise<?>> $this$all) {
        Intrinsics.checkNotNullParameter($this$all, (String)"<this>");
        return $this$all.size() == 1 ? (Promise)CollectionsKt.first((Iterable)$this$all) : Promises.all$default($this$all, null, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<T> all(@NotNull Collection<? extends Promise<?>> $this$all, T totalResult, boolean ignoreErrors) {
        Intrinsics.checkNotNullParameter($this$all, (String)"<this>");
        if ($this$all.isEmpty()) {
            return Promises.resolvedPromise();
        }
        AsyncPromise totalPromise = new AsyncPromise();
        CountDownConsumer done = new CountDownConsumer($this$all.size(), totalPromise, totalResult);
        Consumer<Throwable> rejected2 = ignoreErrors ? arg_0 -> Promises__PromiseKt.all$lambda$9$Promises__PromiseKt(done, arg_0) : arg_0 -> Promises__PromiseKt.all$lambda$10$Promises__PromiseKt(totalPromise, arg_0);
        for (Promise<?> promise : $this$all) {
            promise.onSuccess(done);
            promise.onError(rejected2);
        }
        return totalPromise;
    }

    public static /* synthetic */ Promise all$default(Collection collection, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Promises.all(collection, object, bl);
    }

    @NotNull
    public static final <T> Promise<T> any(@NotNull Collection<? extends Promise<T>> promises, @NotNull String totalError) {
        Intrinsics.checkNotNullParameter(promises, (String)"promises");
        Intrinsics.checkNotNullParameter((Object)totalError, (String)"totalError");
        if (promises.isEmpty()) {
            return Promises.resolvedPromise();
        }
        if (promises.size() == 1) {
            return (Promise)CollectionsKt.first((Iterable)promises);
        }
        AsyncPromise totalPromise = new AsyncPromise();
        Consumer<Object> done = arg_0 -> Promises__PromiseKt.any$lambda$11$Promises__PromiseKt(totalPromise, arg_0);
        Consumer<Throwable> rejected2 = new Consumer<Throwable>(promises, totalPromise, totalError){
            @NotNull
            private final AtomicInteger toConsume;
            final /* synthetic */ AsyncPromise<T> $totalPromise;
            final /* synthetic */ String $totalError;
            {
                this.$totalPromise = $totalPromise;
                this.$totalError = $totalError;
                this.toConsume = new AtomicInteger($promises.size());
            }

            public void accept(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                if (this.toConsume.decrementAndGet() <= 0) {
                    this.$totalPromise.setError(this.$totalError);
                }
            }
        };
        for (Promise<Object> promise : promises) {
            promise.onSuccess(done);
            promise.onError(rejected2);
        }
        return totalPromise;
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<List<T>> collectResults(@NotNull Collection<? extends Promise<T>> $this$collectResults) {
        Intrinsics.checkNotNullParameter($this$collectResults, (String)"<this>");
        return Promises.collectResults$default($this$collectResults, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final RuntimeException createError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return Promises.createError$default(error, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final <T> Promise<T> all(@NotNull Collection<? extends Promise<?>> $this$all, T totalResult) {
        Intrinsics.checkNotNullParameter($this$all, (String)"<this>");
        return Promises.all$default($this$all, totalResult, false, 2, null);
    }

    private static final boolean collectResults$arrive$lambda$0$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final <T> void collectResults$arrive$Promises__PromiseKt(AtomicInteger latch, boolean $ignoreErrors, List<T> list, AsyncPromise<List<T>> result2) {
        if (latch.decrementAndGet() == 0) {
            if ($ignoreErrors) {
                list.removeIf(arg_0 -> Promises__PromiseKt.collectResults$arrive$lambda$0$Promises__PromiseKt(collectResults.arrive.1.INSTANCE, arg_0));
            }
            Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<T of org.jetbrains.concurrency.Promises__PromiseKt.collectResults$arrive>");
            result2.setResult(list);
        }
    }

    private static final void collectResults$lambda$1$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void collectResults$lambda$2$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void asPromise$lambda$3$Promises__PromiseKt(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void asPromise$lambda$4$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void toPromise$lambda$5$Promises__PromiseKt(AsyncPromise $promise) {
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        $promise.setResult(null);
    }

    private static final void toPromise$lambda$6$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void toActionCallback$lambda$7$Promises__PromiseKt(ActionCallback $result, Object it) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $result.setDone();
    }

    private static final void toActionCallback$lambda$8$Promises__PromiseKt(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void all$lambda$9$Promises__PromiseKt(CountDownConsumer $done, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$done, (String)"$done");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $done.accept((Object)null);
    }

    private static final void all$lambda$10$Promises__PromiseKt(AsyncPromise $totalPromise, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$totalPromise, (String)"$totalPromise");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $totalPromise.setError(it);
    }

    private static final void any$lambda$11$Promises__PromiseKt(AsyncPromise $totalPromise, Object result2) {
        Intrinsics.checkNotNullParameter((Object)$totalPromise, (String)"$totalPromise");
        $totalPromise.setResult(result2);
    }

    public static final /* synthetic */ void access$collectResults$arrive(AtomicInteger latch, boolean $ignoreErrors, List list, AsyncPromise result2) {
        Promises__PromiseKt.collectResults$arrive$Promises__PromiseKt(latch, $ignoreErrors, list, result2);
    }

    public static final /* synthetic */ RuntimeException access$getObsoleteError() {
        return Promises__PromiseKt.getObsoleteError$Promises__PromiseKt();
    }
}

