/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Function;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CompletablePromise;
import org.jetbrains.concurrency.InternalPromiseUtilKt;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 ;*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001;B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B%\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J \u0010 \u001a\u0004\u0018\u00018\u00002\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"H\u0082\b\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u00020'0&H\u0016J \u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\u0010)\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000&H\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010+\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000&H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u000e\u0010-\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000,H\u0016J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200J\u0010\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020'H\u0016J\u0017\u00101\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\nH\u0014J,\u00105\u001a\b\u0012\u0004\u0012\u0002H60,\"\u0004\b\u0001\u001062\u0016\u00107\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H608H\u0016J2\u00109\u001a\b\u0012\u0004\u0012\u0002H60,\"\u0004\b\u0001\u001062\u001c\u0010:\u001a\u0018\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H60,08H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lorg/jetbrains/concurrency/CompletablePromise;", "()V", "f", "Ljava/util/concurrent/CompletableFuture;", "hasErrorHandler", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addExceptionHandler", "", "(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/atomic/AtomicBoolean;Z)V", "getF$intellij_platform_concurrency", "()Ljava/util/concurrent/CompletableFuture;", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "", "unit", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "isCancelled", "isDone", "nullizeCancelled", "value", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onError", "rejected", "Ljava/util/function/Consumer;", "", "onProcessed", "processed", "onSuccess", "handler", "Lorg/jetbrains/concurrency/Promise;", "child", "setError", "error", "", "setResult", "t", "(Ljava/lang/Object;)V", "shouldLogErrors", "then", "SUB_RESULT", "done", "Lcom/intellij/util/Function;", "thenAsync", "doneF", "Companion", "intellij.platform.concurrency"})
@SourceDebugExtension(value={"SMAP\nAsyncPromise.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncPromise.kt\norg/jetbrains/concurrency/AsyncPromise\n*L\n1#1,179:1\n53#1,9:180\n53#1,9:189\n*S KotlinDebug\n*F\n+ 1 AsyncPromise.kt\norg/jetbrains/concurrency/AsyncPromise\n*L\n47#1:180,9\n49#1:189,9\n*E\n"})
public class AsyncPromise<T>
implements CancellablePromise<T>,
CompletablePromise<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean hasErrorHandler;
    @NotNull
    private final CompletableFuture<T> f;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final CancellationException CANCELED = new CancellationException(){

        @NotNull
        public Throwable fillInStackTrace() {
            return this;
        }
    };

    private AsyncPromise(CompletableFuture<T> f, AtomicBoolean hasErrorHandler, boolean addExceptionHandler) {
        CompletionStage<T> completionStage;
        this.hasErrorHandler = hasErrorHandler;
        if (addExceptionHandler) {
            CompletionStage completionStage2 = f.exceptionally(arg_0 -> AsyncPromise._init_$lambda$0(this, arg_0));
            completionStage = completionStage2;
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"{\n        f.exceptionall\u2026w error\n        }\n      }");
        } else {
            completionStage = f;
        }
        this.f = completionStage;
    }

    @NotNull
    public final CompletableFuture<T> getF$intellij_platform_concurrency() {
        return this.f;
    }

    public AsyncPromise() {
        this(new CompletableFuture(), new AtomicBoolean(), false);
    }

    @Override
    public boolean isDone() {
        return this.f.isDone();
    }

    @Override
    @Nullable
    public T get() {
        Object v0;
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var4_5;
            try {
                boolean bl = false;
                var4_5 = this.f.get();
            }
            catch (CancellationException e$iv) {
                var4_5 = null;
            }
            v0 = var4_5;
        }
        return v0;
    }

    @Override
    @Nullable
    public T get(long timeout, @NotNull TimeUnit unit) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var7_6;
            try {
                boolean bl = false;
                var7_6 = this.f.get(timeout, unit);
            }
            catch (CancellationException e$iv) {
                var7_6 = null;
            }
            v0 = var7_6;
        }
        return v0;
    }

    private final T nullizeCancelled(Function0<? extends T> value) {
        Object object;
        boolean $i$f$nullizeCancelled = false;
        if (this.isCancelled()) {
            return null;
        }
        try {
            object = value.invoke();
        }
        catch (CancellationException e) {
            object = null;
        }
        return (T)object;
    }

    @Override
    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return !this.isCancelled() && this.f.completeExceptionally(CANCELED);
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return !this.f.isDone() ? Promise.State.PENDING : (this.f.isCompletedExceptionally() ? Promise.State.REJECTED : Promise.State.SUCCEEDED);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        CompletionStage completionStage = this.f.whenComplete((arg_0, arg_1) -> AsyncPromise.onSuccess$lambda$3((Function2)new Function2<T, Throwable, Unit>(handler){
            final /* synthetic */ Consumer<? super T> $handler;
            {
                this.$handler = $handler;
                super(2);
            }

            public final void invoke(T value, Throwable error) {
                if (error != null) {
                    throw error;
                }
                if (!InternalPromiseUtilKt.isHandlerObsolete(this.$handler)) {
                    this.$handler.accept(value);
                }
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"handler: Consumer<in T>)\u2026cept(value)\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onError(@NotNull Consumer<? super Throwable> rejected2) {
        Intrinsics.checkNotNullParameter(rejected2, (String)"rejected");
        this.hasErrorHandler.set(true);
        CompletionStage completionStage = this.f.whenComplete((arg_0, arg_1) -> AsyncPromise.onError$lambda$4((Function2)new Function2<T, Throwable, Unit>(rejected2){
            final /* synthetic */ Consumer<? super Throwable> $rejected;
            {
                this.$rejected = $rejected;
                super(2);
            }

            public final void invoke(T t, Throwable exception) {
                if (exception != null && !InternalPromiseUtilKt.isHandlerObsolete(this.$rejected)) {
                    Throwable throwable = exception instanceof CompletionException ? (CompletionException)exception : null;
                    if (throwable == null || (throwable = throwable.getCause()) == null) {
                        throwable = exception;
                    }
                    this.$rejected.accept(throwable);
                }
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"rejected: Consumer<in Th\u2026)\n        }\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, false);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onProcessed(@NotNull Consumer<? super T> processed2) {
        Intrinsics.checkNotNullParameter(processed2, (String)"processed");
        CompletionStage completionStage = this.f.whenComplete((arg_0, arg_1) -> AsyncPromise.onProcessed$lambda$5((Function2)new Function2<T, Throwable, Unit>(processed2){
            final /* synthetic */ Consumer<? super T> $processed;
            {
                this.$processed = $processed;
                super(2);
            }

            public final void invoke(T value, Throwable throwable) {
                if (!InternalPromiseUtilKt.isHandlerObsolete(this.$processed)) {
                    this.$processed.accept(value);
                }
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"processed: Consumer<in T\u2026cept(value)\n      }\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            return this.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throw e;
            }
            Throwable cause = throwable;
            ExceptionUtilRt.rethrowUnchecked(cause);
            throw e;
        }
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done) {
        Intrinsics.checkNotNullParameter(done, (String)"done");
        CompletionStage completionStage = this.f.thenApply(arg_0 -> AsyncPromise.then$lambda$6((Function1)new Function1<T, SUB_RESULT>(done){
            final /* synthetic */ Function<? super T, ? extends SUB_RESULT> $done;
            {
                this.$done = $done;
                super(1);
            }

            public final SUB_RESULT invoke(T it) {
                return this.$done.fun(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"done: Function<in T, out\u2026nApply { done.`fun`(it) }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, ? extends Promise<SUB_RESULT>> doneF) {
        Intrinsics.checkNotNullParameter(doneF, (String)"doneF");
        CompletionStage completionStage = this.f.thenCompose(arg_0 -> AsyncPromise.thenAsync$lambda$7((Function1)new Function1<T, CompletionStage<SUB_RESULT>>(doneF){
            final /* synthetic */ Function<? super T, ? extends Promise<SUB_RESULT>> $doneF;
            {
                this.$doneF = $doneF;
                super(1);
            }

            public final CompletionStage<SUB_RESULT> invoke(T it) {
                Promise<SUB_RESULT> promise = this.$doneF.fun(it);
                CompletableFuture<T> future = new CompletableFuture<T>();
                promise.onSuccess(arg_0 -> thenAsync.1.invoke$lambda$0((Function1)new Function1<SUB_RESULT, Unit>(future){
                    final /* synthetic */ CompletableFuture<SUB_RESULT> $future;
                    {
                        this.$future = $future;
                        super(1);
                    }

                    public final void invoke(SUB_RESULT value) {
                        this.$future.complete(value);
                    }
                }, arg_0)).onError(arg_0 -> thenAsync.1.invoke$lambda$1((Function1)new Function1<Throwable, Unit>(future){
                    final /* synthetic */ CompletableFuture<SUB_RESULT> $future;
                    {
                        this.$future = $future;
                        super(1);
                    }

                    public final void invoke(Throwable error) {
                        this.$future.completeExceptionally(error);
                    }
                }, arg_0));
                return future;
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"doneF: Function<in T, ou\u2026ror) }\n      future\n    }");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        if (!(child instanceof AsyncPromise)) {
            return this;
        }
        return ((AsyncPromise)this.onSuccess(arg_0 -> AsyncPromise.processed$lambda$8((Function1)new Function1<T, Unit>(child){
            final /* synthetic */ Promise<? super T> $child;
            {
                this.$child = $child;
                super(1);
            }

            public final void invoke(T it) {
                ((AsyncPromise)this.$child).setResult(it);
            }
        }, arg_0))).onError(arg_0 -> AsyncPromise.processed$lambda$9((Function1)new Function1<Throwable, Unit>(child){
            final /* synthetic */ Promise<? super T> $child;
            {
                this.$child = $child;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((AsyncPromise)this.$child).setError(it);
            }
        }, arg_0));
    }

    @Override
    public void setResult(@Nullable T t) {
        this.f.complete(t);
    }

    @Override
    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (!this.f.completeExceptionally(error)) {
            return false;
        }
        if (this.shouldLogErrors()) {
            Logger logger = Logger.getInstance(AsyncPromise.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(AsyncPromise::class.java)");
            Promises.errorIfNotMessage(logger, error);
        }
        return true;
    }

    protected boolean shouldLogErrors() {
        return !this.hasErrorHandler.get();
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    private static final Object _init_$lambda$0(AsyncPromise this$0, Throwable originalError) {
        Throwable error;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Throwable throwable = originalError instanceof CompletionException ? (CompletionException)originalError : null;
        if (throwable == null || (throwable = throwable.getCause()) == null) {
            throwable = error = originalError;
        }
        if (this$0.shouldLogErrors()) {
            Logger logger = Logger.getInstance(AsyncPromise.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(AsyncPromise::class.java)");
            Throwable throwable2 = error instanceof CompletionException ? error : null;
            if (throwable2 == null || (throwable2 = throwable2.getCause()) == null) {
                throwable2 = error;
            }
            Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"(error as? CompletionException)?.cause ?: error");
            Promises.errorIfNotMessage(logger, throwable2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)error, (String)"error");
        throw error;
    }

    private static final void onSuccess$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void onError$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void onProcessed$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Object then$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final CompletionStage thenAsync$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final void processed$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processed$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise$Companion;", "", "()V", "CANCELED", "Ljava/util/concurrent/CancellationException;", "intellij.platform.concurrency"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

