/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output.support;

import java.util.List;
import org.jdom.Content;
import org.jdom.Verifier;
import org.jdom.output.support.AbstractFormattedWalker;
import org.jdom.output.support.FormatStack;

final class WalkerNORMALIZE
extends AbstractFormattedWalker {
    WalkerNORMALIZE(List<? extends Content> content, FormatStack fstack, boolean escape) {
        super(content, fstack, escape);
    }

    private static boolean isSpaceFirst(String text2) {
        if (text2.length() > 0) {
            return Verifier.isXMLWhitespace(text2.charAt(0));
        }
        return false;
    }

    private static boolean isSpaceLast(String text2) {
        int tlen = text2.length();
        return tlen > 0 && Verifier.isXMLWhitespace(text2.charAt(tlen - 1));
    }

    @Override
    protected void analyzeMultiText(AbstractFormattedWalker.MultiText mtext, int offset, int len) {
        boolean needspace = false;
        boolean between = false;
        block4: for (int i2 = 0; i2 < len; ++i2) {
            Content c = this.get(offset + i2);
            switch (c.getCType()) {
                case Text: {
                    String ttext = c.getValue();
                    if (Verifier.isAllXMLWhitespace(ttext)) {
                        if (!between || ttext.length() <= 0) continue block4;
                        needspace = true;
                        continue block4;
                    }
                    if (between && (needspace || WalkerNORMALIZE.isSpaceFirst(ttext))) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendText(AbstractFormattedWalker.Trim.COMPACT, ttext);
                    between = true;
                    needspace = WalkerNORMALIZE.isSpaceLast(ttext);
                    continue block4;
                }
                case CDATA: {
                    String ttext = c.getValue();
                    if (Verifier.isAllXMLWhitespace(ttext)) {
                        if (!between || ttext.length() <= 0) continue block4;
                        needspace = true;
                        continue block4;
                    }
                    if (between && (needspace || WalkerNORMALIZE.isSpaceFirst(ttext))) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendCDATA(AbstractFormattedWalker.Trim.COMPACT, ttext);
                    between = true;
                    needspace = WalkerNORMALIZE.isSpaceLast(ttext);
                    continue block4;
                }
                default: {
                    if (between && needspace) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendRaw(c);
                    between = true;
                    needspace = false;
                }
            }
        }
    }
}

