/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.CloneBase;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.util.IteratorIterable;

public final class Document
extends CloneBase
implements Parent,
Serializable {
    private transient ContentList content = new ContentList(this);
    private String baseUri;
    private transient HashMap<String, Object> propertyMap = null;
    private static final long serialVersionUID = 200L;

    public Document() {
    }

    public Document(Element rootElement, DocType docType, String baseURI) {
        if (rootElement != null) {
            this.setRootElement(rootElement);
        }
        if (docType != null) {
            this.setDocType(docType);
        }
        if (baseURI != null) {
            this.setBaseURI(baseURI);
        }
    }

    public Document(Element rootElement, DocType docType) {
        this(rootElement, docType, null);
    }

    public Document(Element rootElement) {
        this(rootElement, null, null);
    }

    public Document(List<? extends Content> content) {
        this.setContent(content);
    }

    @Override
    public int getContentSize() {
        return this.content.size();
    }

    @Override
    public int indexOf(Content child) {
        return this.content.indexOf(child);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int index2 = this.content.indexOfFirstElement();
        if (index2 < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(index2);
    }

    public Document setRootElement(Element rootElement) {
        int index2 = this.content.indexOfFirstElement();
        if (index2 < 0) {
            this.content.add(rootElement);
        } else {
            this.content.set(index2, rootElement);
        }
        return this;
    }

    public Element detachRootElement() {
        int index2 = this.content.indexOfFirstElement();
        if (index2 < 0) {
            return null;
        }
        return (Element)this.removeContent(index2);
    }

    public DocType getDocType() {
        int index2 = this.content.indexOfDocType();
        if (index2 < 0) {
            return null;
        }
        return (DocType)this.content.get(index2);
    }

    public Document setDocType(DocType docType) {
        if (docType == null) {
            int docTypeIndex = this.content.indexOfDocType();
            if (docTypeIndex >= 0) {
                this.content.remove(docTypeIndex);
            }
            return this;
        }
        if (docType.getParent() != null) {
            throw new IllegalAddException(docType, "The DocType already is attached to a document");
        }
        int docTypeIndex = this.content.indexOfDocType();
        if (docTypeIndex < 0) {
            this.content.add(0, docType);
        } else {
            this.content.set(docTypeIndex, docType);
        }
        return this;
    }

    @Override
    public Document addContent(Content child) {
        this.content.add(child);
        return this;
    }

    @Override
    public Document addContent(Collection<? extends Content> c) {
        this.content.addAll(c);
        return this;
    }

    @Override
    public Document addContent(int index2, Content child) {
        this.content.add(index2, child);
        return this;
    }

    @Override
    public Document addContent(int index2, Collection<? extends Content> c) {
        this.content.addAll(index2, c);
        return this;
    }

    @Override
    public List<Content> cloneContent() {
        int size = this.getContentSize();
        ArrayList<Content> list = new ArrayList<Content>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            Content child = this.getContent(i2);
            list.add(child.clone());
        }
        return list;
    }

    @Override
    public Content getContent(int index2) {
        return this.content.get(index2);
    }

    @Override
    public List<Content> getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    @Override
    public List<Content> removeContent() {
        ArrayList<Content> old = new ArrayList<Content>(this.content);
        this.content.clear();
        return old;
    }

    public Document setContent(Collection<? extends Content> newContent) {
        this.content.clearAndSet(newContent);
        return this;
    }

    public void setBaseURI(String uri) {
        this.baseUri = uri;
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    public Document setContent(int index2, Content child) {
        this.content.set(index2, child);
        return this;
    }

    public Document setContent(int index2, Collection<? extends Content> collection) {
        this.content.remove(index2);
        this.content.addAll(index2, collection);
        return this;
    }

    @Override
    public boolean removeContent(Content child) {
        return this.content.remove(child);
    }

    @Override
    public Content removeContent(int index2) {
        return this.content.remove(index2);
    }

    public Document setContent(Content child) {
        this.content.clear();
        this.content.add(child);
        return this;
    }

    public String toString() {
        Element rootElement;
        StringBuilder stringForm = new StringBuilder().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringForm.append(docType).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        Element element = rootElement = this.hasRootElement() ? this.getRootElement() : null;
        if (rootElement != null) {
            stringForm.append("Root is ").append(rootElement);
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return stringForm.toString();
    }

    public boolean equals(Object ob) {
        return ob == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Document clone() {
        Document doc = (Document)super.clone();
        doc.content = new ContentList(doc);
        for (int i2 = 0; i2 < this.content.size(); ++i2) {
            Content obj = this.content.get(i2);
            if (obj instanceof Element) {
                Element element = ((Element)obj).clone();
                doc.content.add(element);
                continue;
            }
            if (obj instanceof Comment) {
                Comment comment = ((Comment)obj).clone();
                doc.content.add(comment);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                ProcessingInstruction pi = ((ProcessingInstruction)obj).clone();
                doc.content.add(pi);
                continue;
            }
            if (!(obj instanceof DocType)) continue;
            DocType dt = ((DocType)obj).clone();
            doc.content.add(dt);
        }
        return doc;
    }

    public IteratorIterable<Content> getDescendants() {
        return new DescendantIterator(this);
    }

    @Override
    public Parent getParent() {
        return null;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    public void setProperty(String id, Object value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(id, value);
    }

    public Object getProperty(String id) {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.get(id);
    }

    @Override
    public void canContainContent(Content child, int index2, boolean replace) {
        if (child instanceof Element) {
            int cre = this.content.indexOfFirstElement();
            if (replace && cre == index2) {
                return;
            }
            if (cre >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (this.content.indexOfDocType() >= index2) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (child instanceof DocType) {
            int cdt = this.content.indexOfDocType();
            if (replace && cdt == index2) {
                return;
            }
            if (cdt >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int firstElt = this.content.indexOfFirstElement();
            if (firstElt != -1 && firstElt < index2) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (child instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (child instanceof Text) {
            if (Verifier.isAllXMLWhitespace(((Text)child).getText())) {
                return;
            }
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (child instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int cs = this.content.size();
        out.writeInt(cs);
        for (int i2 = 0; i2 < cs; ++i2) {
            out.writeObject(this.getContent(i2));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.content = new ContentList(this);
        int cs = in.readInt();
        while (--cs >= 0) {
            this.addContent((Content)in.readObject());
        }
    }
}

