/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import one.util.streamex.Internals;

final class DistinctSpliterator<T>
extends Internals.Box<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private AtomicLong nullCounter;
    private Map<T, Long> counts;
    private final long atLeast;

    DistinctSpliterator(Spliterator<T> source, long atLeast, AtomicLong nullCounter, Map<T, Long> counts) {
        this.source = source;
        this.atLeast = atLeast;
        this.nullCounter = nullCounter;
        this.counts = counts;
    }

    DistinctSpliterator(Spliterator<T> source, long atLeast) {
        this(source, atLeast, null, new HashMap());
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action2) {
        if (this.nullCounter == null) {
            while (this.source.tryAdvance(this)) {
                if (this.counts.merge(this.a, 1L, Long::sum) != this.atLeast) continue;
                action2.accept(this.a);
                return true;
            }
        } else {
            while (this.source.tryAdvance(this)) {
                long count2 = this.a == null ? this.nullCounter.incrementAndGet() : this.counts.merge(this.a, 1L, Long::sum).longValue();
                if (count2 != this.atLeast) continue;
                action2.accept(this.a);
                return true;
            }
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action2) {
        if (this.nullCounter == null) {
            this.source.forEachRemaining(e -> {
                if (this.counts.merge(e, 1L, Long::sum) == this.atLeast) {
                    action2.accept(e);
                }
            });
        } else {
            this.source.forEachRemaining(e -> {
                long count2;
                long l = count2 = e == null ? this.nullCounter.incrementAndGet() : this.counts.merge(e, 1L, Long::sum).longValue();
                if (count2 == this.atLeast) {
                    action2.accept(e);
                }
            });
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> split = this.source.trySplit();
        if (split == null) {
            return null;
        }
        if (this.counts.getClass() == HashMap.class) {
            if (!this.source.hasCharacteristics(256)) {
                Long current2 = this.counts.remove(null);
                this.nullCounter = new AtomicLong(current2 == null ? 0L : current2);
            }
            this.counts = new ConcurrentHashMap<T, Long>(this.counts);
        }
        return new DistinctSpliterator<T>(split, this.atLeast, this.nullCounter, this.counts);
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return 1 | this.source.characteristics() & 0x1514;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.source.getComparator();
    }
}

