/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.matcher;

import java.util.Iterator;
import kotlinx.coroutines.repackaged.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import kotlinx.coroutines.repackaged.net.bytebuddy.matcher.ElementMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class CollectionElementMatcher<T>
extends ElementMatcher.Junction.AbstractBase<Iterable<? extends T>> {
    private final int index;
    private final ElementMatcher<? super T> matcher;

    public CollectionElementMatcher(int index2, ElementMatcher<? super T> matcher) {
        this.index = index2;
        this.matcher = matcher;
    }

    @Override
    public boolean matches(Iterable<? extends T> target) {
        Iterator<T> iterator2 = target.iterator();
        for (int index2 = 0; index2 < this.index; ++index2) {
            if (!iterator2.hasNext()) {
                return false;
            }
            iterator2.next();
        }
        return iterator2.hasNext() && this.matcher.matches(iterator2.next());
    }

    public String toString() {
        return "with(" + this.index + " matches " + this.matcher + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.index != ((CollectionElementMatcher)object).index) {
            return false;
        }
        return this.matcher.equals(((CollectionElementMatcher)object).matcher);
    }

    public int hashCode() {
        return (17 * 31 + this.index) * 31 + this.matcher.hashCode();
    }
}

