/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011H\u0016J,\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u000b0\n\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\tH\u0016R(\u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedStorageChangeImpl;", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "entityStorage", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "storageBefore", "Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "storageAfter", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "(Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;Ljava/util/Map;)V", "getStorageAfter", "()Lcom/intellij/workspaceModel/storage/EntityStorageSnapshot;", "getStorageBefore", "getAllChanges", "Lkotlin/sequences/Sequence;", "getChanges", "T", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityClass", "intellij.platform.workspaceModel.storage"})
final class VersionedStorageChangeImpl
extends VersionedStorageChange {
    @NotNull
    private final EntityStorageSnapshot storageBefore;
    @NotNull
    private final EntityStorageSnapshot storageAfter;
    @NotNull
    private final Map<Class<?>, List<EntityChange<?>>> changes;

    public VersionedStorageChangeImpl(@NotNull VersionedEntityStorage entityStorage, @NotNull EntityStorageSnapshot storageBefore, @NotNull EntityStorageSnapshot storageAfter, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        Intrinsics.checkNotNullParameter((Object)storageBefore, (String)"storageBefore");
        Intrinsics.checkNotNullParameter((Object)storageAfter, (String)"storageAfter");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        super(entityStorage);
        this.storageBefore = storageBefore;
        this.storageAfter = storageAfter;
        this.changes = changes;
    }

    @Override
    @NotNull
    public EntityStorageSnapshot getStorageBefore() {
        return this.storageBefore;
    }

    @Override
    @NotNull
    public EntityStorageSnapshot getStorageAfter() {
        return this.storageAfter;
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> List<EntityChange<T>> getChanges(@NotNull Class<T> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        List list = this.changes.get(entityClass);
        List list2 = list instanceof List ? list : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public Sequence<EntityChange<?>> getAllChanges() {
        return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.changes.values()));
    }
}

