/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.CachedValueWithParameter;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.impl.ValuesCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J5\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00110\u00162\u0006\u0010\u0017\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016J5\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00110\u00162\u0006\u0010\u0017\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageOnStorage;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "(Lcom/intellij/workspaceModel/storage/EntityStorage;)V", "base", "getBase", "()Lcom/intellij/workspaceModel/storage/EntityStorage;", "current", "getCurrent", "valuesCache", "Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "version", "", "getVersion", "()J", "cachedValue", "R", "value", "Lcom/intellij/workspaceModel/storage/CachedValue;", "(Lcom/intellij/workspaceModel/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "intellij.platform.workspaceModel.storage"})
public final class VersionedEntityStorageOnStorage
implements VersionedEntityStorage {
    @NotNull
    private final EntityStorage storage;
    @NotNull
    private final ValuesCache valuesCache;

    public VersionedEntityStorageOnStorage(@NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        if (this.storage instanceof MutableEntityStorage) {
            throw new IllegalStateException(("storage must be immutable, but got: " + this.storage.getClass().getName()).toString());
        }
        this.valuesCache = new ValuesCache();
    }

    @Override
    public long getVersion() {
        return 0L;
    }

    @Override
    @NotNull
    public EntityStorage getCurrent() {
        return this.storage;
    }

    @Override
    @NotNull
    public EntityStorage getBase() {
        return this.storage;
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.valuesCache.cachedValue(value, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.valuesCache.cachedValue(value, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.valuesCache.clearCachedValue(value);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.valuesCache.clearCachedValue(value, parameter);
    }
}

