/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.impl.DummyVersionedEntityStorage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0016B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u000e\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/workspaceModel/storage/impl/DisposableCachedValue;", "R", "Lcom/intellij/openapi/Disposable;", "entityStorage", "Lkotlin/Function0;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "cachedValue", "Lcom/intellij/workspaceModel/storage/CachedValue;", "cacheName", "", "(Lkotlin/jvm/functions/Function0;Lcom/intellij/workspaceModel/storage/CachedValue;Ljava/lang/String;)V", "latestStorageModificationCount", "", "Ljava/lang/Long;", "latestValue", "Lcom/intellij/openapi/Disposable;", "value", "getValue", "()Lcom/intellij/openapi/Disposable;", "dispose", "", "dropCache", "Companion", "intellij.platform.workspaceModel.storage"})
@SourceDebugExtension(value={"SMAP\nDisposableCachedValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisposableCachedValue.kt\ncom/intellij/workspaceModel/storage/impl/DisposableCachedValue\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n12#2,5:68\n10#2:73\n*S KotlinDebug\n*F\n+ 1 DisposableCachedValue.kt\ncom/intellij/workspaceModel/storage/impl/DisposableCachedValue\n*L\n40#1:68,5\n64#1:73\n*E\n"})
public final class DisposableCachedValue<R extends Disposable>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<VersionedEntityStorage> entityStorage;
    @NotNull
    private final CachedValue<R> cachedValue;
    @NotNull
    private final String cacheName;
    @Nullable
    private R latestValue;
    @Nullable
    private Long latestStorageModificationCount;
    @NotNull
    private static final Logger log;

    public DisposableCachedValue(@NotNull Function0<? extends VersionedEntityStorage> entityStorage, @NotNull CachedValue<R> cachedValue, @NotNull String cacheName) {
        Intrinsics.checkNotNullParameter(entityStorage, (String)"entityStorage");
        Intrinsics.checkNotNullParameter(cachedValue, (String)"cachedValue");
        Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
        this.entityStorage = entityStorage;
        this.cachedValue = cachedValue;
        this.cacheName = cacheName;
    }

    public /* synthetic */ DisposableCachedValue(Function0 function0, CachedValue cachedValue, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "-";
        }
        this((Function0<? extends VersionedEntityStorage>)function0, cachedValue, string2);
    }

    @NotNull
    public final synchronized R getValue() {
        Disposable currentValue = null;
        VersionedEntityStorage storage = (VersionedEntityStorage)this.entityStorage.invoke();
        if (storage instanceof DummyVersionedEntityStorage) {
            long storageModificationCount;
            EntityStorage entityStorage = storage.getCurrent();
            Intrinsics.checkNotNull((Object)entityStorage, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.storage.MutableEntityStorage");
            Long l = this.latestStorageModificationCount;
            if (l == null || (storageModificationCount = ((MutableEntityStorage)entityStorage).getModificationCount()) != l) {
                currentValue = (Disposable)storage.cachedValue(this.cachedValue);
                this.latestStorageModificationCount = storageModificationCount;
            } else {
                R r = this.latestValue;
                Intrinsics.checkNotNull(r);
                currentValue = r;
            }
        } else {
            currentValue = (Disposable)storage.cachedValue(this.cachedValue);
        }
        R oldValue = this.latestValue;
        if (oldValue != currentValue && oldValue != null) {
            Logger $this$debug_u24default$iv = log;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Dispose old value. Cache name: `" + this.cacheName + "`. Store type: " + storage.getClass(), e$iv);
            }
            Disposer.dispose(oldValue);
        }
        this.latestValue = currentValue;
        return (R)currentValue;
    }

    @Override
    public void dispose() {
        this.dropCache();
    }

    public final synchronized void dropCache() {
        R oldValue = this.latestValue;
        if (oldValue != null) {
            ((VersionedEntityStorage)this.entityStorage.invoke()).clearCachedValue(this.cachedValue);
            Disposer.dispose(oldValue);
            this.latestStorageModificationCount = null;
            this.latestValue = null;
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DisposableCachedValue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/storage/impl/DisposableCachedValue$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

