/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.BiMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.ImmutableEntityFamily;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.containers.IntIntUniqueBiMap;
import com.intellij.workspaceModel.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.workspaceModel.storage.impl.containers.NonNegativeIntIntBiMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a2\u0010\f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a0\u0010\u0016\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u001c\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\tH\u0000\u00a8\u0006\u001d"}, d2={"assertCorrectEntityClass", "", "connectionClass", "", "entityId", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "assertResolvable", "storage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "clazz", "id", "checkAllStrongConnections", "entityFamilyClass", "keys", "", "debugInfo", "", "checkStrongAbstractConnection", "connectionKeys", "", "entityFamilyClasses", "checkStrongConnection", "Lit/unimi/dsi/fastutil/ints/IntSet;", "connectionTo", "connectionId", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "assertConsistency", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "intellij.platform.workspaceModel.storage"})
@SourceDebugExtension(value={"SMAP\nConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsistencyChecker.kt\ncom/intellij/workspaceModel/storage/impl/ConsistencyCheckerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 NonNegativeIntIntBiMap.kt\ncom/intellij/workspaceModel/storage/impl/containers/NonNegativeIntIntBiMap\n+ 5 IntIntUniqueBiMap.kt\ncom/intellij/workspaceModel/storage/impl/containers/IntIntUniqueBiMap\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ClassToIntConverter.kt\ncom/intellij/workspaceModel/storage/impl/ClassToIntConverterKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n19#2,4:152\n215#3:156\n216#3:159\n215#3:160\n216#3:163\n215#3:164\n215#3,2:165\n216#3:171\n215#3:172\n215#3,2:173\n216#3:179\n100#4,2:157\n107#5,2:161\n1549#6:167\n1620#6,3:168\n1620#6,3:175\n1549#6:178\n1855#6:183\n1856#6:185\n1855#6,2:186\n1864#6,3:188\n70#7:180\n70#7:181\n70#7:182\n1#8:184\n*S KotlinDebug\n*F\n+ 1 ConsistencyChecker.kt\ncom/intellij/workspaceModel/storage/impl/ConsistencyCheckerKt\n*L\n14#1:152,4\n22#1:156\n22#1:159\n39#1:160\n39#1:163\n54#1:164\n59#1:165,2\n54#1:171\n75#1:172\n80#1:173,2\n75#1:179\n28#1:157,2\n45#1:161,2\n71#1:167\n71#1:168,3\n92#1:175,3\n92#1:178\n115#1:183\n115#1:185\n125#1:186,2\n135#1:188,3\n101#1:180\n102#1:181\n108#1:182\n*E\n"})
public final class ConsistencyCheckerKt {
    public static final void assertConsistency(@NotNull EntityStorage $this$assertConsistency) {
        Intrinsics.checkNotNullParameter((Object)$this$assertConsistency, (String)"<this>");
        ConsistencyCheckerKt.assertConsistency((AbstractEntityStorage)$this$assertConsistency);
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertConsistency(@NotNull AbstractEntityStorage $this$assertConsistency) {
        ChildEntityId it;
        Collection collection;
        Object $this$mapTo$iv$iv;
        boolean $i$f$map;
        AbstractEntityStorage abstractEntityStorage;
        Object parentId;
        Object $this$forEach$iv;
        Object map2;
        boolean bl;
        ConnectionId connectionId;
        Map.Entry<ConnectionId, NonNegativeIntIntBiMap> entry;
        Map.Entry<ConnectionId, Object> element$iv;
        Intrinsics.checkNotNullParameter((Object)$this$assertConsistency, (String)"<this>");
        Logger $this$trace$iv = AbstractEntityStorage.Companion.getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Checking consistency of " + $this$assertConsistency);
        }
        $this$assertConsistency.getEntitiesByType$intellij_platform_workspaceModel_storage().assertConsistency($this$assertConsistency);
        Map<ConnectionId, NonNegativeIntIntBiMap> $this$forEach$iv2 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToManyContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<ConnectionId, Object>> iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl3;
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            connectionId = entry.getKey();
            NonNegativeIntIntBiMap map22 = entry.getValue();
            boolean bl4 = bl3 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_MANY;
            if (_Assertions.ENABLED && !bl3) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            NonNegativeIntIntBiMap this_$iv22 = map22;
            boolean $i$f$forEachKey2 = false;
            Int2IntMaps.fastForEach(this_$iv22.getAccess$key2Value(), new Consumer($this$assertConsistency, connectionId){
                final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                final /* synthetic */ ConnectionId $connectionId$inlined;
                {
                    this.$this_assertConsistency$inlined = abstractEntityStorage;
                    this.$connectionId$inlined = connectionId;
                }

                public final void accept(Int2IntMap.Entry it) {
                    int parentId = it.getIntValue();
                    int childId = it.getIntKey();
                    boolean bl = false;
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            ConsistencyCheckerKt.checkStrongConnection($this$assertConsistency, map22.getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        Map<ConnectionId, Object> $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToOneContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv3.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean this_$iv22;
            entry = element$iv = iterator2.next();
            bl = false;
            connectionId = entry.getKey();
            map2 = (IntIntUniqueBiMap)((Object)entry.getValue());
            boolean bl5 = this_$iv22 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE;
            if (_Assertions.ENABLED && !this_$iv22) {
                String $i$f$forEachKey2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$forEachKey2);
            }
            IntIntUniqueBiMap this_$iv = map2;
            boolean $i$f$forEachKey3 = false;
            Int2IntMaps.fastForEach(this_$iv.getAccess$key2Value(), new Consumer($this$assertConsistency, connectionId){
                final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                final /* synthetic */ ConnectionId $connectionId$inlined;
                {
                    this.$this_assertConsistency$inlined = abstractEntityStorage;
                    this.$connectionId$inlined = connectionId;
                }

                public final void accept(Int2IntMap.Entry it) {
                    int parentId = it.getIntValue();
                    int childId = it.getIntKey();
                    boolean bl = false;
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            ConsistencyCheckerKt.checkStrongConnection($this$assertConsistency, ((IntIntUniqueBiMap)map2).getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<Integer> collection2;
            Object item$iv$iv;
            Iterable $this$map$iv;
            boolean this_$iv;
            entry = element$iv = iterator2.next();
            bl = false;
            connectionId = entry.getKey();
            map2 = (LinkedBidirectionalMap)((Object)entry.getValue());
            boolean bl6 = this_$iv = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY;
            if (_Assertions.ENABLED && !this_$iv) {
                String $i$f$forEachKey3 = "Assertion failed";
                throw new AssertionError((Object)$i$f$forEachKey3);
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach3 = false;
            Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = iterator3.next();
                boolean bl62 = false;
                ChildEntityId childId = (ChildEntityId)entry3.getKey();
                parentId = (ParentEntityId)entry3.getValue();
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(((ParentEntityId)parentId).getId()), EntityIdKt.getArrayId(((ParentEntityId)parentId).getId()));
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(childId.getId()), EntityIdKt.getArrayId(childId.getId()));
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getParentClass(), ((ParentEntityId)parentId).getId());
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = ((LinkedBidirectionalMap)map2).keySet();
            abstractEntityStorage = $this$assertConsistency;
            $i$f$map = false;
            iterator3 = $this$map$iv;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl62 = $this$mapTo$iv$iv.iterator();
            while (bl62.hasNext()) {
                item$iv$iv = bl62.next();
                parentId = (ChildEntityId)item$iv$iv;
                collection = collection3;
                boolean bl7 = false;
                collection.add(it.getId());
            }
            $this$map$iv = ((LinkedBidirectionalMap)map2).keySet();
            collection = CollectionsKt.toMutableSet((Iterable)((List)collection3));
            boolean $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            bl62 = $this$mapTo$iv$iv.iterator();
            while (bl62.hasNext()) {
                item$iv$iv = bl62.next();
                it = (ChildEntityId)item$iv$iv;
                collection2 = collection4;
                boolean bl8 = false;
                collection2.add(EntityIdKt.getClazz(it.getId()));
            }
            collection2 = (List)collection4;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, (Set<Long>)collection, CollectionsKt.toSet((Iterable)collection2), connectionId.debugStr());
        }
        $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getAbstractOneToOneContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<Integer> collection5;
            void destination$iv;
            Iterable $this$mapTo$iv;
            boolean $this$map$iv;
            entry = element$iv = iterator2.next();
            bl = false;
            connectionId = entry.getKey();
            map2 = (BiMap)entry.getValue();
            boolean bl7 = $this$map$iv = connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE;
            if (_Assertions.ENABLED && !$this$map$iv) {
                String $i$f$map2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$map2);
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach232 = false;
            $this$mapTo$iv$iv = $this$forEach$iv.entrySet().iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Map.Entry entry4;
                Map.Entry $i$f$mapTo = entry4 = $this$mapTo$iv$iv.next();
                boolean bl10 = false;
                ChildEntityId childId = (ChildEntityId)$i$f$mapTo.getKey();
                parentId = (ParentEntityId)$i$f$mapTo.getValue();
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(((ParentEntityId)parentId).getId()), EntityIdKt.getArrayId(((ParentEntityId)parentId).getId()));
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(childId.getId()), EntityIdKt.getArrayId(childId.getId()));
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getParentClass(), ((ParentEntityId)parentId).getId());
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = map2.keySet();
            Collection $i$f$forEach232 = new HashSet();
            abstractEntityStorage = $this$assertConsistency;
            boolean $i$f$mapTo232 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it2;
                ChildEntityId bl10 = (ChildEntityId)item$iv;
                collection = destination$iv;
                boolean bl11 = false;
                collection.add(it2.getId());
            }
            $this$mapTo$iv = CollectionsKt.toMutableSet((Iterable)map2.keySet());
            collection = (Set)destination$iv;
            $i$f$map = false;
            Iterable $i$f$mapTo232 = $this$map$iv;
            Collection collection6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv = iterator3.next();
                parentId = (ChildEntityId)item$iv$iv;
                collection5 = collection6;
                boolean bl12 = false;
                collection5.add(EntityIdKt.getClazz(it.getId()));
            }
            collection5 = (List)collection6;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, (Set<Long>)collection, CollectionsKt.toSet((Iterable)collection5), connectionId.debugStr());
        }
        $this$assertConsistency.getIndexes$intellij_platform_workspaceModel_storage().assertConsistency($this$assertConsistency);
    }

    private static final void assertCorrectEntityClass(int connectionClass, long entityId) {
        int $this$findEntityClass$iv = connectionClass;
        boolean $i$f$findEntityClass = false;
        Class<?> clazz = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv);
        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
        $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
        $i$f$findEntityClass = false;
        Class<?> clazz2 = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv);
        Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
        boolean bl = clazz.isAssignableFrom(clazz2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            int $this$findEntityClass$iv2 = connectionClass;
            boolean $i$f$findEntityClass2 = false;
            Class<?> clazz3 = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv2);
            Intrinsics.checkNotNull(clazz3, (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
            String string2 = "Entity storage with connection class " + clazz3 + " contains entity data of wrong type " + entityId;
            throw new AssertionError((Object)string2);
        }
    }

    private static final void assertResolvable(AbstractEntityStorage storage, int clazz, int id) {
        boolean bl;
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().get(clazz);
        boolean bl2 = bl = (entityFamily != null ? entityFamily.get(id) : null) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv = clazz;
            boolean $i$f$findEntityClass = false;
            Class<?> clazz2 = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv);
            Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<E of com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt.findEntityClass>");
            String string2 = "Reference to " + clazz2 + "-:-" + id + " cannot be resolved";
            throw new AssertionError((Object)string2);
        }
    }

    private static final void checkAllStrongConnections(AbstractEntityStorage storage, int entityFamilyClass, Set<Long> keys2, String debugInfo) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            throw new IllegalStateException(("Entity family doesn't exist. " + debugInfo).toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEach$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntityData entity2 = (WorkspaceEntityData)element$iv;
            boolean bl = false;
            if (entity2 == null) continue;
            boolean removed = keys2.remove(entity2.createEntityId());
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl2 = false;
            String string2 = "Entity " + entity2 + " doesn't have a correct connection. " + debugInfo;
            throw new AssertionError((Object)string2);
        }
    }

    private static final void checkStrongAbstractConnection(AbstractEntityStorage storage, Set<Long> connectionKeys, Set<Integer> entityFamilyClasses, String debugInfo) {
        Set keys2 = CollectionsKt.toMutableSet((Iterable)connectionKeys);
        Iterable $this$forEach$iv = entityFamilyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int entityFamilyClass = ((Number)element$iv).intValue();
            boolean bl = false;
            ConsistencyCheckerKt.checkAllStrongConnections(storage, entityFamilyClass, keys2, debugInfo);
        }
        boolean bl = keys2.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Store is inconsistent. " + debugInfo;
            throw new AssertionError((Object)string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkStrongConnection(AbstractEntityStorage storage, IntSet connectionKeys, int entityFamilyClass, int connectionTo, ConnectionId connectionId) {
        boolean bl;
        int counter = 0;
        EntityFamily entityFamily = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            entityFamily = new ImmutableEntityFamily();
        }
        EntityFamily entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (entity2 == null) continue;
            boolean bl3 = connectionKeys.contains(i2);
            if (_Assertions.ENABLED && !bl3) {
                boolean bl4 = false;
                String string2 = StringsKt.trimMargin$default((String)("\n            |Storage inconsistency. Hard reference broken.\n            |Existing entity " + (WorkspaceEntityData)entity2 + "\n            |Misses a reference to " + ClassToIntConverterKt.findWorkspaceEntity(connectionTo) + "\n            |Reference id: " + i2 + "\n            |ConnectionId: " + connectionId + "\n            "), null, (int)1, null);
                throw new AssertionError((Object)string2);
            }
            ++counter;
        }
        boolean bl5 = bl = counter == connectionKeys.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string3 = "Store is inconsistent";
            throw new AssertionError((Object)string3);
        }
    }

    public static final /* synthetic */ void access$assertResolvable(AbstractEntityStorage storage, int clazz, int id) {
        ConsistencyCheckerKt.assertResolvable(storage, clazz, id);
    }
}

