/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage;

import com.intellij.workspaceModel.storage.NotThisEntityId;
import com.intellij.workspaceModel.storage.ThisEntityId;
import com.intellij.workspaceModel.storage.UtilsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e*\u00060\u000bj\u0002`\fH\u0000\u00a8\u0006\u000f"}, d2={"currentStackTrace", "", "depth", "", "loadClassByName", "Ljava/lang/Class;", "name", "classLoader", "Ljava/lang/ClassLoader;", "asThis", "Lcom/intellij/workspaceModel/storage/ThisEntityId;", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "notThis", "Lcom/intellij/workspaceModel/storage/NotThisEntityId;", "intellij.platform.workspaceModel.storage"})
public final class UtilsKt {
    @NotNull
    public static final ThisEntityId asThis(long $this$asThis) {
        return new ThisEntityId($this$asThis);
    }

    @NotNull
    public static final NotThisEntityId notThis(long $this$notThis) {
        return new NotThisEntityId($this$notThis);
    }

    @NotNull
    public static final String currentStackTrace(int depth) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"Throwable().stackTrace");
        return CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])stackTraceElementArray, (int)depth), (CharSequence)"\n", null, null, (int)0, null, (Function1)currentStackTrace.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final Class<?> loadClassByName(@NotNull String name2, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        if (StringsKt.startsWith$default((String)name2, (String)"[", (boolean)false, (int)2, null)) {
            Class<?> clazz = Class.forName(name2);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(name)");
            return clazz;
        }
        Class<?> clazz = classLoader.loadClass(name2);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"classLoader.loadClass(name)");
        return clazz;
    }
}

