/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NameUtilCore {
    public static String @NotNull [] splitNameIntoWords(@NotNull String name2) {
        if (name2 == null) {
            NameUtilCore.$$$reportNull$$$0(0);
        }
        String[] underlineDelimited = name2.split("_");
        ArrayList<String> result2 = new ArrayList<String>();
        for (String word : underlineDelimited) {
            NameUtilCore.addAllWords(word, result2);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            NameUtilCore.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private static void addAllWords(@NotNull String text2, @NotNull List<? super String> result2) {
        if (text2 == null) {
            NameUtilCore.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            NameUtilCore.$$$reportNull$$$0(3);
        }
        int start = 0;
        while (start < text2.length()) {
            int next2 = NameUtilCore.nextWord(text2, start);
            result2.add(text2.substring(start, next2));
            start = next2;
        }
    }

    public static int nextWord(@NotNull String text2, int start) {
        int i2;
        if (text2 == null) {
            NameUtilCore.$$$reportNull$$$0(4);
        }
        int ch = text2.codePointAt(start);
        int chLen = Character.charCount(ch);
        if (!Character.isLetterOrDigit(ch)) {
            return start + chLen;
        }
        for (i2 = start; i2 < text2.length() && Character.isDigit(text2.codePointAt(i2)); i2 += Character.charCount(text2.codePointAt(i2))) {
        }
        if (i2 > start) {
            return i2;
        }
        while (i2 < text2.length() && Character.isUpperCase(text2.codePointAt(i2))) {
            i2 += Character.charCount(text2.codePointAt(i2));
        }
        if (i2 > start + chLen) {
            if (i2 == text2.length() || !Character.isLetter(text2.codePointAt(i2))) {
                return i2;
            }
            return i2 - Character.charCount(text2.codePointBefore(i2));
        }
        if (i2 == start) {
            i2 += chLen;
        }
        while (i2 < text2.length() && Character.isLetter(text2.codePointAt(i2)) && !NameUtilCore.isWordStart(text2, i2)) {
            i2 += Character.charCount(text2.codePointAt(i2));
        }
        return i2;
    }

    public static boolean isWordStart(String text2, int i2) {
        int prev;
        int cur = text2.codePointAt(i2);
        int n = prev = i2 > 0 ? text2.codePointBefore(i2) : -1;
        if (Character.isUpperCase(cur)) {
            if (Character.isUpperCase(prev)) {
                int nextPos = i2 + Character.charCount(cur);
                return nextPos < text2.length() && Character.isLowerCase(text2.codePointAt(nextPos));
            }
            return true;
        }
        if (Character.isDigit(cur)) {
            return true;
        }
        if (!Character.isLetter(cur)) {
            return false;
        }
        if (Character.isIdeographic(cur)) {
            return true;
        }
        return i2 == 0 || !Character.isLetterOrDigit(text2.charAt(i2 - 1)) || NameUtilCore.isHardCodedWordStart(text2, i2) || NameUtilCore.isKanaBreak(cur, prev);
    }

    private static boolean isKanaBreak(int cur, int prev) {
        Character.UnicodeScript curScript = Character.UnicodeScript.of(cur);
        Character.UnicodeScript prevScript = Character.UnicodeScript.of(prev);
        if (prevScript == curScript) {
            return false;
        }
        return (curScript == Character.UnicodeScript.KATAKANA || curScript == Character.UnicodeScript.HIRAGANA || prevScript == Character.UnicodeScript.KATAKANA || prevScript == Character.UnicodeScript.HIRAGANA) && prevScript != Character.UnicodeScript.COMMON && curScript != Character.UnicodeScript.COMMON;
    }

    private static boolean isHardCodedWordStart(String text2, int i2) {
        return text2.charAt(i2) == 'l' && i2 < text2.length() - 1 && text2.charAt(i2 + 1) == 'n' && (text2.length() == i2 + 2 || NameUtilCore.isWordStart(text2, i2 + 2));
    }

    public static String @NotNull [] nameToWords(@NotNull String name2) {
        if (name2 == null) {
            NameUtilCore.$$$reportNull$$$0(5);
        }
        ArrayList<String> array2 = new ArrayList<String>();
        int index2 = 0;
        while (index2 < name2.length()) {
            String word;
            int wordStart = index2;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index2 < name2.length()) {
                char c = name2.charAt(index2);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index2;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index2;
            }
            if (StringUtilRt.isEmptyOrSpaces(word = name2.substring(wordStart, index2))) continue;
            array2.add(word);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(array2);
        if (stringArray == null) {
            NameUtilCore.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/NameUtilCore";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/NameUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameIntoWords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitNameIntoWords";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAllWords";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nameToWords";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

