/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

final class StrippedLongArrayList {
    private static final long[] DEFAULT_EMPTY_ARRAY = new long[0];
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private transient long[] a = DEFAULT_EMPTY_ARRAY;
    private int size;

    StrippedLongArrayList() {
    }

    public long[] elements() {
        return this.a;
    }

    private static long[] forceCapacity(long[] array2, int length, int preserve) {
        long[] t = new long[length];
        System.arraycopy(array2, 0, t, 0, preserve);
        return t;
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = StrippedLongArrayList.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    public void add(int index2, long k) {
        this.grow(this.size + 1);
        if (index2 != this.size) {
            System.arraycopy(this.a, index2, this.a, index2 + 1, this.size - index2);
        }
        this.a[index2] = k;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    public boolean add(long k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        assert (this.size <= this.a.length);
        return true;
    }

    public int size() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrippedLongArrayList)) {
            return false;
        }
        int s = this.size();
        if (s != ((StrippedLongArrayList)o).size()) {
            return false;
        }
        long[] a1 = this.a;
        long[] a2 = ((StrippedLongArrayList)o).a;
        if (a1 == a2) {
            return true;
        }
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }
}

