/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.system.CpuArch;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PageCacheUtils {
    private static final Logger LOG = Logger.getInstance(PageCacheUtils.class);
    public static final int DEFAULT_PAGE_SIZE = Math.max(1, SystemProperties.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
    public static final boolean LOCK_FREE_VFS_ENABLED = SystemProperties.getBooleanProperty("vfs.lock-free-impl.enable", false);
    public static final double NEW_PAGE_CACHE_MEMORY_FRACTION = SystemProperties.getFloatProperty("vfs.lock-free-impl.fraction-direct-memory-to-utilize", 0.1f);
    public static final long MAX_DIRECT_MEMORY_TO_USE_BYTES = PageCacheUtils.maxDirectMemory() - 2L * (long)DEFAULT_PAGE_SIZE;
    public static final long FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES = PageCacheUtils.estimateTotalCacheCapacityLimit(MAX_DIRECT_MEMORY_TO_USE_BYTES);
    public static final long FILE_PAGE_CACHE_NEW_CAPACITY_BYTES = LOCK_FREE_VFS_ENABLED ? (long)(NEW_PAGE_CACHE_MEMORY_FRACTION * (double)FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES) : 0L;
    public static final long FILE_PAGE_CACHE_OLD_CAPACITY_BYTES = LOCK_FREE_VFS_ENABLED ? (long)((1.0 - NEW_PAGE_CACHE_MEMORY_FRACTION) * (double)FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES) : FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES;
    static final int ALLOCATOR_SIZE = (int)Math.min(0x6400000L, Math.max(0L, MAX_DIRECT_MEMORY_TO_USE_BYTES - FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES - 314572800L));
    private static final int CHANNELS_CACHE_CAPACITY = SystemProperties.getIntProperty("paged.file.storage.open.channel.cache.capacity", 400);
    static final OpenChannelsCache CHANNELS_CACHE = new OpenChannelsCache(CHANNELS_CACHE_CAPACITY);

    private static long maxDirectMemory() {
        try {
            Class<?> aClass = Class.forName("jdk.internal.misc.VM");
            Method maxDirectMemory = aClass.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass) {
            try {
                Class<?> aClass2 = Class.forName("sun.misc.VM");
                Method maxDirectMemory = aClass2.getMethod("maxDirectMemory", new Class[0]);
                return (Long)maxDirectMemory.invoke(null, new Object[0]);
            }
            catch (Throwable aClass2) {
                try {
                    Class<?> aClass3 = Class.forName("java.nio.Bits");
                    Field maxMemory = aClass3.getDeclaredField("maxMemory");
                    maxMemory.setAccessible(true);
                    return (Long)maxMemory.get(null);
                }
                catch (Throwable aClass3) {
                    try {
                        Class<?> aClass4 = Class.forName("java.nio.Bits");
                        Field maxMemory = aClass4.getDeclaredField("MAX_MEMORY");
                        maxMemory.setAccessible(true);
                        return (Long)maxMemory.get(null);
                    }
                    catch (Throwable throwable) {
                        return Runtime.getRuntime().maxMemory();
                    }
                }
            }
        }
    }

    private static long estimateTotalCacheCapacityLimit(long maxDirectMemoryToUseBytes) {
        int defaultCacheCapacityMb = CpuArch.is32Bit() ? 200 : 500;
        int cacheCapacityMb = SystemProperties.getIntProperty("idea.max.paged.storage.cache", defaultCacheCapacityMb);
        long cacheCapacityBytes = (long)cacheCapacityMb * 0x100000L;
        int minCacheCapacityMb = 100;
        long minCacheCapacityBytes = Math.min(0x6400000L, maxDirectMemoryToUseBytes);
        return Math.min(Math.max(minCacheCapacityBytes, cacheCapacityBytes), maxDirectMemoryToUseBytes);
    }

    private PageCacheUtils() {
        throw new AssertionError((Object)"Not for instantiation");
    }

    static {
        LOG.info("File page caching params:");
        LOG.info("\tDEFAULT_PAGE_SIZE:" + DEFAULT_PAGE_SIZE);
        if (LOCK_FREE_VFS_ENABLED) {
            LOG.info("\tFilePageCache: regular + lock-free (LOCK_FREE_VFS_ENABLED:true)");
            LOG.info("\tNEW_PAGE_CACHE_MEMORY_FRACTION: " + NEW_PAGE_CACHE_MEMORY_FRACTION);
            LOG.info("\tRegular FilePageCache: " + FILE_PAGE_CACHE_OLD_CAPACITY_BYTES + " bytes");
            LOG.info("\tNew     FilePageCache: " + FILE_PAGE_CACHE_NEW_CAPACITY_BYTES + " bytes");
        } else {
            LOG.info("\tFilePageCache: regular");
        }
        LOG.info("\tDirectByteBuffers pool: " + ALLOCATOR_SIZE + " bytes");
    }
}

