/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Matrix;

public class Vector {
    private final double[] array;

    public static Vector create(double ... values2) {
        if (values2.length == 0) {
            throw new IllegalArgumentException("no values");
        }
        return new Vector((double[])values2.clone());
    }

    public boolean equals(Object object) {
        Vector vector;
        int size;
        if (object == this) {
            return true;
        }
        if (object instanceof Vector && (size = (vector = (Vector)object).getSize()) == this.getSize()) {
            for (int i2 = 0; i2 < size; ++i2) {
                if (Double.doubleToLongBits(this.get(i2)) == Double.doubleToLongBits(vector.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int size = this.getSize();
        StringBuilder sb = new StringBuilder();
        sb.append("Vector ").append(size).append(" { ");
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(this.get(i2));
        }
        return sb.append(" }").toString();
    }

    public double get(int index2) {
        return this.array[index2];
    }

    public int getSize() {
        return this.array.length;
    }

    public Vector plus(Vector vector) {
        int size = vector.getSize();
        if (size != this.getSize()) {
            throw new IllegalArgumentException("sizes mismatch");
        }
        double[] result2 = this.toArray();
        for (int i2 = 0; i2 < result2.length; ++i2) {
            int n = i2;
            result2[n] = result2[n] + vector.get(i2);
        }
        return new Vector(result2);
    }

    public Vector minus(Vector vector) {
        int size = vector.getSize();
        if (size != this.getSize()) {
            throw new IllegalArgumentException("sizes mismatch");
        }
        double[] result2 = this.toArray();
        for (int i2 = 0; i2 < result2.length; ++i2) {
            int n = i2;
            result2[n] = result2[n] - vector.get(i2);
        }
        return new Vector(result2);
    }

    public Vector multiply(double value) {
        double[] result2 = this.toArray();
        int i2 = 0;
        while (i2 < result2.length) {
            int n = i2++;
            result2[n] = result2[n] * value;
        }
        return new Vector(result2);
    }

    public Vector multiply(Matrix matrix) {
        int size = matrix.getRows();
        if (size != this.getSize()) {
            throw new IllegalArgumentException("size mismatch rows");
        }
        double[] result2 = new double[matrix.getColumns()];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = this.multiply(matrix.getColumn(i2));
        }
        return new Vector(result2);
    }

    public double multiply(Vector vector) {
        int size = vector.getSize();
        if (size != this.getSize()) {
            throw new IllegalArgumentException("sizes mismatch");
        }
        double result2 = 0.0;
        for (int i2 = 0; i2 < size; ++i2) {
            result2 += this.get(i2) * vector.get(i2);
        }
        return result2;
    }

    public double length() {
        return Math.sqrt(this.multiply(this));
    }

    Vector(double[] array2) {
        this.array = array2;
    }

    double[] toArray() {
        return (double[])this.array.clone();
    }

    static class Modified
    extends Vector {
        Modified(Vector vector) {
            super(vector.array);
        }

        @Override
        double[] toArray() {
            int size = this.getSize();
            double[] result2 = new double[size];
            for (int i2 = 0; i2 < result2.length; ++i2) {
                result2[i2] = this.get(i2);
            }
            return result2;
        }
    }
}

