/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlUtilRt {
    @Nullable
    public static URL internProtocol(@NotNull URL url) {
        String host;
        if (url == null) {
            UrlUtilRt.$$$reportNull$$$0(0);
        }
        String protocol = url.getProtocol();
        boolean interned = false;
        if ("file".equals(protocol) || "jar".equals(protocol)) {
            protocol = protocol.intern();
            interned = true;
        }
        if ((host = url.getHost()) != null && host.isEmpty()) {
            host = "";
            interned = true;
        }
        try {
            if (interned) {
                url = new URL(protocol, host, url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from, int end) {
        int i2;
        if (s == null) {
            UrlUtilRt.$$$reportNull$$$0(1);
        }
        if ((i2 = UrlUtilRt.indexOf(s, from, end)) == -1) {
            CharSequence charSequence = s.subSequence(from, end);
            if (charSequence == null) {
                UrlUtilRt.$$$reportNull$$$0(2);
            }
            return charSequence;
        }
        StringBuilder decoded = new StringBuilder();
        decoded.append(s, from, i2);
        byte[] byteBuffer = null;
        int byteBufferSize = 0;
        while (i2 < end) {
            char c = s.charAt(i2);
            if (c == '%') {
                if (byteBuffer == null) {
                    byteBuffer = new byte[end - from];
                } else {
                    byteBufferSize = 0;
                }
                while (i2 + 2 < end && s.charAt(i2) == '%') {
                    int d1 = UrlUtilRt.decode(s.charAt(i2 + 1));
                    int d2 = UrlUtilRt.decode(s.charAt(i2 + 2));
                    if (d1 == -1 || d2 == -1) break;
                    byteBuffer[byteBufferSize++] = (byte)((d1 & 0xF) << 4 | d2 & 0xF);
                    i2 += 3;
                }
                if (byteBufferSize != 0) {
                    decoded.append(new String(byteBuffer, 0, byteBufferSize, StandardCharsets.UTF_8));
                    continue;
                }
            }
            decoded.append(c);
            ++i2;
        }
        StringBuilder stringBuilder = decoded;
        if (stringBuilder == null) {
            UrlUtilRt.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static int indexOf(@NotNull CharSequence s, int start, int end) {
        if (s == null) {
            UrlUtilRt.$$$reportNull$$$0(4);
        }
        end = Math.min(end, s.length());
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (s.charAt(i2) != '%') continue;
            return i2;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/UrlUtilRt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/UrlUtilRt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePercentSequences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unescapePercentSequences";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

