/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.testFramework.TestModeFlagListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TestModeFlags {
    private static final Map<String, Object> ourFlags = new HashMap<String, Object>();
    private static final List<TestModeFlagListener> ourListeners = new CopyOnWriteArrayList<TestModeFlagListener>();

    @TestOnly
    public static <T> T set(@NotNull Key<T> flag2, @Nullable T value) {
        if (flag2 == null) {
            TestModeFlags.$$$reportNull$$$0(0);
        }
        Object oldValue = ourFlags.get(flag2.toString());
        ourFlags.put(flag2.toString(), value);
        for (TestModeFlagListener listener : ourListeners) {
            listener.testModeFlagChanged(flag2, value);
        }
        return (T)oldValue;
    }

    @TestOnly
    public static void reset(@NotNull Key<?> flag2) {
        if (flag2 == null) {
            TestModeFlags.$$$reportNull$$$0(1);
        }
        TestModeFlags.set(flag2, null);
    }

    @TestOnly
    public static <T> void set(@NotNull Key<T> flag2, T value, @NotNull Disposable parentDisposable) {
        if (flag2 == null) {
            TestModeFlags.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            TestModeFlags.$$$reportNull$$$0(3);
        }
        Object oldValue = TestModeFlags.get(flag2);
        TestModeFlags.set(flag2, value);
        Disposer.register(parentDisposable, () -> TestModeFlags.set(flag2, oldValue));
    }

    public static <T> T get(@NotNull Key<T> flag2) {
        if (flag2 == null) {
            TestModeFlags.$$$reportNull$$$0(4);
        }
        return (T)ourFlags.get(flag2.toString());
    }

    public static boolean is(@NotNull Key<Boolean> flag2) {
        if (flag2 == null) {
            TestModeFlags.$$$reportNull$$$0(5);
        }
        return TestModeFlags.get(flag2) == Boolean.TRUE;
    }

    public static void addListener(@NotNull TestModeFlagListener listener) {
        if (listener == null) {
            TestModeFlags.$$$reportNull$$$0(6);
        }
        ourListeners.add(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestModeFlags";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "is";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

