/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.smRunner;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u001b\u001c\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0006H\u0002J\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H&J\u001c\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016J \u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/smRunner/OutputEventSplitterBase;", "T", "", "serviceMessagePrefix", "", "bufferTextUntilNewLine", "", "cutNewLineBeforeServiceMessage", "(Ljava/lang/String;ZZ)V", "newLinePending", "prevRefs", "", "Lcom/intellij/smRunner/OutputEventSplitterBase$OutputStreamType;", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/smRunner/OutputEventSplitterBase$Output;", "findSuffixLengthToPreserve", "", "text", "flush", "", "flushInternal", "outputType", "Lcom/intellij/smRunner/OutputEventSplitterBase$OutputType;", "lastFlush", "onTextAvailable", "process", "processInternal", "Output", "OutputStreamType", "OutputType", "intellij.platform.util.base"})
@SourceDebugExtension(value={"SMAP\nOutputEventSplitterBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutputEventSplitterBase.kt\ncom/intellij/smRunner/OutputEventSplitterBase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n9496#2,2:163\n9646#2,4:165\n1#3:169\n1855#4,2:170\n*S KotlinDebug\n*F\n+ 1 OutputEventSplitterBase.kt\ncom/intellij/smRunner/OutputEventSplitterBase\n*L\n44#1:163,2\n44#1:165,4\n138#1:170,2\n*E\n"})
public abstract class OutputEventSplitterBase<T> {
    @NotNull
    private final String serviceMessagePrefix;
    private final boolean bufferTextUntilNewLine;
    private final boolean cutNewLineBeforeServiceMessage;
    private boolean newLinePending;
    @NotNull
    private final Map<OutputStreamType, AtomicReference<Output<T>>> prevRefs;

    /*
     * WARNING - void declaration
     */
    public OutputEventSplitterBase(@NotNull String serviceMessagePrefix, boolean bufferTextUntilNewLine, boolean cutNewLineBeforeServiceMessage) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)serviceMessagePrefix, (String)"serviceMessagePrefix");
        this.serviceMessagePrefix = serviceMessagePrefix;
        this.bufferTextUntilNewLine = bufferTextUntilNewLine;
        this.cutNewLineBeforeServiceMessage = cutNewLineBeforeServiceMessage;
        OutputStreamType[] outputStreamTypeArray = OutputStreamType.values();
        OutputEventSplitterBase outputEventSplitterBase = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateWith$iv).length), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = ((void)$this$associateWithTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void var12_13 = element$iv$iv = $this$associateWithTo$iv$iv[j];
            void var16_16 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            AtomicReference atomicReference = new AtomicReference();
            map2.put(var16_16, atomicReference);
        }
        outputEventSplitterBase.prevRefs = result$iv;
    }

    public abstract void onTextAvailable(@NotNull String var1, @NotNull OutputType<T> var2);

    public final void process(@NotNull String text2, @NotNull OutputType<T> outputType) {
        block4: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            AtomicReference<Output<T>> atomicReference = this.prevRefs.get((Object)outputType.getStreamType());
            if (atomicReference == null) {
                boolean bl = false;
                String string2 = "reference to " + (Object)((Object)outputType.getStreamType()) + " stream type is missing";
                throw new IllegalArgumentException(string2.toString());
            }
            AtomicReference<Output<T>> prevRef = atomicReference;
            String mergedText = null;
            mergedText = text2;
            Output output = prevRef.getAndSet(null);
            if (output != null) {
                it = output;
                boolean bl = false;
                if (Intrinsics.areEqual(((Output)it).getOutputType(), outputType)) {
                    mergedText = ((Output)it).getText() + text2;
                } else {
                    OutputEventSplitterBase.flushInternal$default(this, ((Output)it).getText(), ((Output)it).getOutputType(), false, 4, null);
                }
            }
            String string3 = this.processInternal(mergedText, outputType);
            if (string3 == null) break block4;
            it = string3;
            boolean bl = false;
            prevRef.set(new Output<T>((String)it, outputType));
        }
    }

    private final String processInternal(String text2, OutputType<T> outputType) {
        int nextFrom;
        int from = 0;
        boolean processServiceMessages = outputType.getStreamType() == OutputStreamType.STDOUT;
        int newLineInd = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)0, (boolean)false, (int)6, null);
        int teamcityMessageStartInd = processServiceMessages ? StringsKt.indexOf$default((CharSequence)text2, (String)this.serviceMessagePrefix, (int)0, (boolean)false, (int)6, null) : -1;
        boolean serviceMessageStarted = false;
        while (from < text2.length() && (nextFrom = Math.min(newLineInd != -1 ? newLineInd + 1 : Integer.MAX_VALUE, teamcityMessageStartInd != -1 ? teamcityMessageStartInd : Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            boolean bl;
            if (from < nextFrom) {
                String string2 = text2.substring(from, nextFrom);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                OutputEventSplitterBase.flushInternal$default(this, string2, outputType, false, 4, null);
            }
            boolean bl2 = bl = from != nextFrom || from == 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string3 = "``from`` is " + from + " and it hasn't been changed since last check. Loop is frozen";
                throw new AssertionError((Object)string3);
            }
            from = nextFrom;
            boolean bl4 = serviceMessageStarted = processServiceMessages && nextFrom == teamcityMessageStartInd;
            if (serviceMessageStarted) {
                teamcityMessageStartInd = StringsKt.indexOf$default((CharSequence)text2, (String)this.serviceMessagePrefix, (int)(nextFrom + this.serviceMessagePrefix.length()), (boolean)false, (int)4, null);
            }
            if (newLineInd == -1 || nextFrom != newLineInd + 1) continue;
            newLineInd = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)nextFrom, (boolean)false, (int)4, null);
        }
        if (from < text2.length()) {
            int preserveSuffixLength;
            String string4 = text2.substring(from);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            String unprocessed = string4;
            if (serviceMessageStarted) {
                return unprocessed;
            }
            int n = this.bufferTextUntilNewLine ? unprocessed.length() : (preserveSuffixLength = processServiceMessages ? this.findSuffixLengthToPreserve(unprocessed) : 0);
            if (preserveSuffixLength < unprocessed.length()) {
                String string5 = unprocessed.substring(0, unprocessed.length() - preserveSuffixLength);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                OutputEventSplitterBase.flushInternal$default(this, string5, outputType, false, 4, null);
            }
            if (preserveSuffixLength > 0) {
                String string6 = unprocessed.substring(unprocessed.length() - preserveSuffixLength);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                return string6;
            }
        }
        return null;
    }

    private final int findSuffixLengthToPreserve(String text2) {
        for (int suffixSize = this.serviceMessagePrefix.length() - 1; 0 < suffixSize; --suffixSize) {
            if (!StringsKt.regionMatches$default((String)text2, (int)(text2.length() - suffixSize), (String)this.serviceMessagePrefix, (int)0, (int)suffixSize, (boolean)false, (int)16, null)) continue;
            return suffixSize;
        }
        return 0;
    }

    public final void flush() {
        Iterable $this$forEach$iv = this.prevRefs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Output output;
            AtomicReference reference = (AtomicReference)element$iv;
            boolean bl = false;
            Output output2 = output = (Output)reference.getAndSet(null);
            if (output2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)output2, (String)"getAndSet(null)");
            Output it = output;
            boolean bl2 = false;
            this.flushInternal(it.getText(), it.getOutputType(), true);
        }
    }

    private final void flushInternal(String text2, OutputType<T> outputType, boolean lastFlush) {
        if (this.cutNewLineBeforeServiceMessage && outputType.getStreamType() == OutputStreamType.STDOUT) {
            if (this.newLinePending) {
                if (!StringsKt.startsWith$default((String)text2, (String)this.serviceMessagePrefix, (boolean)false, (int)2, null) || lastFlush) {
                    this.onTextAvailable("\n", outputType);
                }
                this.newLinePending = false;
            }
            if (Intrinsics.areEqual((Object)text2, (Object)"\n") && !lastFlush) {
                this.newLinePending = true;
                return;
            }
        }
        this.onTextAvailable(text2, outputType);
    }

    static /* synthetic */ void flushInternal$default(OutputEventSplitterBase outputEventSplitterBase, String string2, OutputType outputType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: flushInternal");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        outputEventSplitterBase.flushInternal(string2, outputType, bl);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/smRunner/OutputEventSplitterBase$OutputStreamType;", "", "(Ljava/lang/String;I)V", "STDOUT", "STDERR", "SYSTEM", "intellij.platform.util.base"})
    public static final class OutputStreamType
    extends Enum<OutputStreamType> {
        public static final /* enum */ OutputStreamType STDOUT = new OutputStreamType();
        public static final /* enum */ OutputStreamType STDERR = new OutputStreamType();
        public static final /* enum */ OutputStreamType SYSTEM = new OutputStreamType();
        private static final /* synthetic */ OutputStreamType[] $VALUES;

        public static OutputStreamType[] values() {
            return (OutputStreamType[])$VALUES.clone();
        }

        public static OutputStreamType valueOf(String value) {
            return Enum.valueOf(OutputStreamType.class, value);
        }

        static {
            $VALUES = outputStreamTypeArray = new OutputStreamType[]{OutputStreamType.STDOUT, OutputStreamType.STDERR, OutputStreamType.SYSTEM};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0003J)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/smRunner/OutputEventSplitterBase$Output;", "T", "", "text", "", "outputType", "Lcom/intellij/smRunner/OutputEventSplitterBase$OutputType;", "(Ljava/lang/String;Lcom/intellij/smRunner/OutputEventSplitterBase$OutputType;)V", "getOutputType", "()Lcom/intellij/smRunner/OutputEventSplitterBase$OutputType;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.util.base"})
    private static final class Output<T> {
        @NotNull
        private final String text;
        @NotNull
        private final OutputType<T> outputType;

        public Output(@NotNull String text2, @NotNull OutputType<T> outputType) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            this.text = text2;
            this.outputType = outputType;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final OutputType<T> getOutputType() {
            return this.outputType;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final OutputType<T> component2() {
            return this.outputType;
        }

        @NotNull
        public final Output<T> copy(@NotNull String text2, @NotNull OutputType<T> outputType) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            return new Output<T>(text2, outputType);
        }

        public static /* synthetic */ Output copy$default(Output output, String string2, OutputType outputType, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = output.text;
            }
            if ((n & 2) != 0) {
                outputType = output.outputType;
            }
            return output.copy(string2, outputType);
        }

        @NotNull
        public String toString() {
            return "Output(text=" + this.text + ", outputType=" + this.outputType + ')';
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.outputType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)output.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.outputType, output.outputType);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/smRunner/OutputEventSplitterBase$OutputType;", "T", "", "data", "streamType", "Lcom/intellij/smRunner/OutputEventSplitterBase$OutputStreamType;", "(Ljava/lang/Object;Lcom/intellij/smRunner/OutputEventSplitterBase$OutputStreamType;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStreamType", "()Lcom/intellij/smRunner/OutputEventSplitterBase$OutputStreamType;", "component1", "component2", "copy", "(Ljava/lang/Object;Lcom/intellij/smRunner/OutputEventSplitterBase$OutputStreamType;)Lcom/intellij/smRunner/OutputEventSplitterBase$OutputType;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.util.base"})
    public static final class OutputType<T> {
        private final T data;
        @NotNull
        private final OutputStreamType streamType;

        public OutputType(T data, @NotNull OutputStreamType streamType) {
            Intrinsics.checkNotNullParameter((Object)((Object)streamType), (String)"streamType");
            this.data = data;
            this.streamType = streamType;
        }

        public final T getData() {
            return this.data;
        }

        @NotNull
        public final OutputStreamType getStreamType() {
            return this.streamType;
        }

        public final T component1() {
            return this.data;
        }

        @NotNull
        public final OutputStreamType component2() {
            return this.streamType;
        }

        @NotNull
        public final OutputType<T> copy(T data, @NotNull OutputStreamType streamType) {
            Intrinsics.checkNotNullParameter((Object)((Object)streamType), (String)"streamType");
            return new OutputType<T>(data, streamType);
        }

        public static /* synthetic */ OutputType copy$default(OutputType outputType, Object object, OutputStreamType outputStreamType, int n, Object object2) {
            if ((n & 1) != 0) {
                object = outputType.data;
            }
            if ((n & 2) != 0) {
                outputStreamType = outputType.streamType;
            }
            return outputType.copy(object, outputStreamType);
        }

        @NotNull
        public String toString() {
            return "OutputType(data=" + this.data + ", streamType=" + (Object)((Object)this.streamType) + ')';
        }

        public int hashCode() {
            int result2 = this.data == null ? 0 : this.data.hashCode();
            result2 = result2 * 31 + this.streamType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OutputType)) {
                return false;
            }
            OutputType outputType = (OutputType)other;
            if (!Intrinsics.areEqual(this.data, outputType.data)) {
                return false;
            }
            return this.streamType == outputType.streamType;
        }
    }
}

