/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiGuardedPattern;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiParenthesizedPattern;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternGuard;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiPatternUtil {
    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariables(@NotNull PsiExpression expression) {
        if (expression == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(0);
        }
        List<PatternVariableWrapper> list = JavaPsiPatternUtil.collectPatternVariableWrappers(expression);
        List<PsiPatternVariable> list2 = ((AbstractStreamEx)((StreamEx)StreamEx.of(list).filter(base -> !base.isFake())).map(PatternVariableWrapper::getVariable)).toList();
        if (list2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PatternVariableWrapper> collectPatternVariableWrappers(@NotNull PsiExpression expression) {
        PsiElement parent;
        boolean parentMayAccept;
        if (expression == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(2);
        }
        boolean bl = parentMayAccept = (parent = PsiUtil.skipParenthesizedExprUp(expression.getParent())) instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent).getOperationTokenType().equals(JavaTokenType.EXCL) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.ANDAND) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.OROR) || parent instanceof PsiConditionalExpression || parent instanceof PsiIfStatement || parent instanceof PsiConditionalLoopStatement;
        if (!parentMayAccept) {
            List<PatternVariableWrapper> list = Collections.emptyList();
            if (list == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<PatternVariableWrapper> list = new ArrayList<PatternVariableWrapper>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression, expression, list, false);
        ArrayList<PatternVariableWrapper> arrayList = list;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariablesIgnoreParent(@NotNull PsiExpression expression) {
        if (expression == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(5);
        }
        ArrayList<PatternVariableWrapper> list = new ArrayList<PatternVariableWrapper>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression, expression, list, true);
        List<PsiPatternVariable> list2 = ((AbstractStreamEx)((StreamEx)StreamEx.of(list).filter(base -> !base.isFake())).map(PatternVariableWrapper::getVariable)).toList();
        if (list2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    public static String getEffectiveInitializerText(@NotNull PsiPatternVariable variable) {
        PsiPattern pattern;
        PsiInstanceOfExpression instanceOf;
        if (variable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(7);
        }
        if ((instanceOf = ObjectUtils.tryCast((pattern = variable.getPattern()).getParent(), PsiInstanceOfExpression.class)) == null) {
            return null;
        }
        PsiExpression operand = instanceOf.getOperand();
        PsiTypeElement checkType = pattern instanceof PsiTypeTestPattern ? ((PsiTypeTestPattern)pattern).getCheckType() : (pattern instanceof PsiDeconstructionPattern ? ((PsiDeconstructionPattern)pattern).getTypeElement() : null);
        if (checkType == null) {
            return null;
        }
        if (checkType.getType().equals(operand.getType())) {
            return operand.getText();
        }
        return "(" + checkType.getText() + ")" + operand.getText();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPattern skipParenthesizedPatternDown(PsiPattern pattern) {
        while (pattern instanceof PsiParenthesizedPattern) {
            pattern = ((PsiParenthesizedPattern)pattern).getPattern();
        }
        return pattern;
    }

    public static PsiElement skipParenthesizedPatternUp(PsiElement parent) {
        while (parent instanceof PsiParenthesizedPattern) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPatternVariable getPatternVariable(@Nullable PsiCaseLabelElement pattern) {
        if (pattern instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiGuardedPattern)pattern).getPrimaryPattern());
        }
        if (pattern instanceof PsiPatternGuard) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiPatternGuard)pattern).getPattern());
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getPatternVariable();
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            return ((PsiDeconstructionPattern)pattern).getPatternVariable();
        }
        return null;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPrimaryPattern getTypedPattern(@Nullable PsiCaseLabelElement element) {
        if (element instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.getTypedPattern(((PsiGuardedPattern)element).getPrimaryPattern());
        }
        if (element instanceof PsiPatternGuard) {
            return JavaPsiPatternUtil.getTypedPattern(((PsiPatternGuard)element).getPattern());
        }
        if (element instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getTypedPattern(((PsiParenthesizedPattern)element).getPattern());
        }
        if (element instanceof PsiDeconstructionPattern) {
            return (PsiDeconstructionPattern)element;
        }
        if (element instanceof PsiTypeTestPattern) {
            return (PsiTypeTestPattern)element;
        }
        return null;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean containsPatternVariable(@Nullable PsiCaseLabelElement pattern) {
        if (pattern instanceof PsiPatternGuard) {
            return JavaPsiPatternUtil.containsPatternVariable(((PsiPatternGuard)pattern).getPattern());
        }
        if (pattern instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.containsPatternVariable(((PsiGuardedPattern)pattern).getPrimaryPattern());
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getPatternVariable() != null;
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.containsPatternVariable(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)pattern;
            return deconstructionPattern.getPatternVariable() != null || ContainerUtil.exists(deconstructionPattern.getDeconstructionList().getDeconstructionComponents(), component -> JavaPsiPatternUtil.containsPatternVariable(component));
        }
        return false;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiType getPatternType(@Nullable PsiCaseLabelElement pattern) {
        PsiTypeElement typeElement = JavaPsiPatternUtil.getPatternTypeElement(pattern);
        if (typeElement == null) {
            return null;
        }
        return typeElement.getType();
    }

    @Nullable
    public static PsiTypeElement getPatternTypeElement(@Nullable PsiCaseLabelElement pattern) {
        if (pattern == null) {
            return null;
        }
        if (pattern instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.getPatternTypeElement(((PsiGuardedPattern)pattern).getPrimaryPattern());
        }
        if (pattern instanceof PsiPatternGuard) {
            return JavaPsiPatternUtil.getPatternTypeElement(((PsiPatternGuard)pattern).getPattern());
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternTypeElement(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            return ((PsiDeconstructionPattern)pattern).getTypeElement();
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getCheckType();
        }
        return null;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isUnconditionalForType(@Nullable PsiCaseLabelElement pattern, @NotNull PsiType type) {
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(8);
        }
        return JavaPsiPatternUtil.isUnconditionalForType(pattern, type, false);
    }

    public static boolean isUnconditionalForType(@Nullable PsiCaseLabelElement pattern, @NotNull PsiType type, boolean forDomination) {
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            return false;
        }
        if (pattern instanceof PsiPatternGuard) {
            PsiPatternGuard guarded = (PsiPatternGuard)pattern;
            Object constVal = JavaPsiPatternUtil.evaluateConstant(guarded.getGuardingExpression());
            return JavaPsiPatternUtil.isUnconditionalForType(guarded.getPattern(), type, forDomination) && Boolean.TRUE.equals(constVal);
        }
        if (pattern instanceof PsiGuardedPattern) {
            PsiGuardedPattern guarded = (PsiGuardedPattern)pattern;
            Object constVal = JavaPsiPatternUtil.evaluateConstant(guarded.getGuardingExpression());
            return JavaPsiPatternUtil.isUnconditionalForType(guarded.getPrimaryPattern(), type, forDomination) && Boolean.TRUE.equals(constVal);
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.isUnconditionalForType(((PsiParenthesizedPattern)pattern).getPattern(), type, forDomination);
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            return forDomination && JavaPsiPatternUtil.dominates(JavaPsiPatternUtil.getPatternType(pattern), type);
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return JavaPsiPatternUtil.dominates(JavaPsiPatternUtil.getPatternType(pattern), type);
        }
        return false;
    }

    public static boolean hasUnconditionalComponents(@NotNull PsiDeconstructionPattern pattern) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(10);
        }
        PsiType type = pattern.getTypeElement().getType();
        PsiPattern[] patternComponents = pattern.getDeconstructionList().getDeconstructionComponents();
        PsiClass selectorClass = PsiUtil.resolveClassInClassTypeOnly(type);
        if (selectorClass == null) {
            return false;
        }
        PsiRecordComponent[] recordComponents = selectorClass.getRecordComponents();
        if (patternComponents.length != recordComponents.length) {
            return false;
        }
        for (int i2 = 0; i2 < patternComponents.length; ++i2) {
            PsiPattern patternComponent = patternComponents[i2];
            PsiType componentType = recordComponents[i2].getType();
            if (JavaPsiPatternUtil.isUnconditionalForType(patternComponent, componentType)) continue;
            return false;
        }
        return true;
    }

    public static boolean dominates(@Nullable PsiType who, @Nullable PsiType overWhom) {
        if (who == null || overWhom == null) {
            return false;
        }
        if (who.getCanonicalText().equals(overWhom.getCanonicalText())) {
            return true;
        }
        overWhom = TypeConversionUtil.erasure(overWhom);
        PsiType baseType = TypeConversionUtil.erasure(who);
        if (overWhom instanceof PsiArrayType || baseType instanceof PsiArrayType) {
            return baseType != null && TypeConversionUtil.isAssignable(baseType, overWhom);
        }
        PsiClass typeClass = PsiTypesUtil.getPsiClass(overWhom);
        PsiClass baseTypeClass = PsiTypesUtil.getPsiClass(baseType);
        return typeClass != null && baseTypeClass != null && InheritanceUtil.isInheritorOrSelf(typeClass, baseTypeClass, true);
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean dominates(@Nullable PsiCaseLabelElement who, @NotNull PsiCaseLabelElement overWhom) {
        if (overWhom == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(11);
        }
        if (who == null) {
            return false;
        }
        PsiType overWhomType = JavaPsiPatternUtil.getPatternType(overWhom);
        if (overWhomType == null || !JavaPsiPatternUtil.isUnconditionalForType(who, overWhomType, true)) {
            return false;
        }
        PsiDeconstructionPattern whoDeconstruction = JavaPsiPatternUtil.findDeconstructionPattern(who);
        if (whoDeconstruction != null) {
            PsiDeconstructionPattern overWhomDeconstruction = JavaPsiPatternUtil.findDeconstructionPattern(overWhom);
            return JavaPsiPatternUtil.dominatesComponents(whoDeconstruction, overWhomDeconstruction);
        }
        return true;
    }

    private static boolean dominatesComponents(@NotNull PsiDeconstructionPattern who, @Nullable PsiDeconstructionPattern overWhom) {
        PsiPattern[] overWhomComponents;
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(12);
        }
        if (overWhom == null) {
            return false;
        }
        PsiPattern[] whoComponents = who.getDeconstructionList().getDeconstructionComponents();
        if (whoComponents.length != (overWhomComponents = overWhom.getDeconstructionList().getDeconstructionComponents()).length) {
            return false;
        }
        for (int i2 = 0; i2 < whoComponents.length; ++i2) {
            PsiPattern whoComponent = whoComponents[i2];
            PsiPattern overWhomComponent = overWhomComponents[i2];
            if (JavaPsiPatternUtil.dominates((PsiCaseLabelElement)whoComponent, overWhomComponent)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiDeconstructionPattern findDeconstructionPattern(@Nullable PsiCaseLabelElement element) {
        if (element instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.findDeconstructionPattern(((PsiParenthesizedPattern)element).getPattern());
        }
        if (element instanceof PsiPatternGuard) {
            return JavaPsiPatternUtil.findDeconstructionPattern(((PsiPatternGuard)element).getPattern());
        }
        if (element instanceof PsiDeconstructionPattern) {
            return (PsiDeconstructionPattern)element;
        }
        return null;
    }

    @Contract(value="_,null -> false", pure=true)
    public static boolean dominates(@NotNull PsiCaseLabelElement who, @Nullable PsiType overWhom) {
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(13);
        }
        if (overWhom == null) {
            return false;
        }
        PsiType whoType = TypeConversionUtil.erasure(JavaPsiPatternUtil.getPatternType(who));
        if (whoType == null) {
            return false;
        }
        PsiType overWhomType = null;
        if (overWhom instanceof PsiPrimitiveType) {
            overWhomType = ((PsiPrimitiveType)overWhom).getBoxedType(who);
        } else if (overWhom instanceof PsiClassType) {
            overWhomType = overWhom;
        }
        return overWhomType != null && TypeConversionUtil.areTypesConvertible(overWhomType, whoType);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiRecordComponent getRecordComponentForPattern(@NotNull PsiPattern pattern) {
        PsiDeconstructionList deconstructionList;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(14);
        }
        if ((deconstructionList = ObjectUtils.tryCast(pattern.getParent(), PsiDeconstructionList.class)) == null) {
            return null;
        }
        @NotNull Object @NotNull [] patterns = deconstructionList.getDeconstructionComponents();
        int index2 = ArrayUtil.indexOf(patterns, pattern);
        PsiDeconstructionPattern deconstructionPattern = ObjectUtils.tryCast(deconstructionList.getParent(), PsiDeconstructionPattern.class);
        if (deconstructionPattern == null) {
            return null;
        }
        PsiClassType classType = ObjectUtils.tryCast(deconstructionPattern.getTypeElement().getType(), PsiClassType.class);
        if (classType == null) {
            return null;
        }
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return null;
        }
        PsiRecordComponent[] components = aClass.getRecordComponents();
        if (components.length <= index2) {
            return null;
        }
        return components[index2];
    }

    @Nullable
    public static PsiType getDeconstructedImplicitPatternVariableType(@NotNull PsiPatternVariable parameter) {
        if (parameter == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(15);
        }
        return JavaPsiPatternUtil.getDeconstructedImplicitPatternType(parameter.getPattern());
    }

    @Nullable
    public static PsiType getDeconstructedImplicitPatternType(@NotNull PsiPattern pattern) {
        PsiRecordComponent recordComponent;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(16);
        }
        if ((recordComponent = JavaPsiPatternUtil.getRecordComponentForPattern(pattern)) != null) {
            PsiDeconstructionList deconstructionList = ObjectUtils.tryCast(pattern.getParent(), PsiDeconstructionList.class);
            if (deconstructionList == null) {
                return null;
            }
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)deconstructionList.getParent();
            PsiType patternType = deconstructionPattern.getTypeElement().getType();
            if (patternType instanceof PsiClassType) {
                patternType = PsiUtil.captureToplevelWildcards(patternType, pattern);
                PsiSubstitutor substitutor = ((PsiClassType)patternType).resolveGenerics().getSubstitutor();
                PsiType recordComponentType = recordComponent.getType();
                return JavaVarTypeUtil.getUpwardProjection(substitutor.substitute(recordComponentType));
            }
        }
        return null;
    }

    private static void collectPatternVariableCandidates(@NotNull PsiExpression scope, @NotNull PsiExpression expression, Collection<PatternVariableWrapper> candidates, boolean strict) {
        PsiPolyadicExpression polyadicExpression;
        IElementType tokenType;
        PsiPrimaryPattern pattern;
        if (scope == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(17);
        }
        if (expression == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(18);
        }
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiPrefixExpression) || !((PsiPrefixExpression)expression).getOperationTokenType().equals(JavaTokenType.EXCL)) break;
            expression = ((PsiPrefixExpression)expression).getOperand();
        }
        if (expression instanceof PsiInstanceOfExpression && ((pattern = ((PsiInstanceOfExpression)expression).getPattern()) instanceof PsiTypeTestPattern || pattern instanceof PsiDeconstructionPattern)) {
            JavaPsiPatternUtil.collectPatternVariableCandidates(pattern, scope, null, candidates, strict);
        }
        if (expression instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)expression).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                JavaPsiPatternUtil.collectPatternVariableCandidates(scope, operand, candidates, strict);
            }
        }
    }

    private static void collectPatternVariableCandidates(@NotNull PsiPattern pattern, @NotNull PsiExpression scope, @Nullable Pair<PsiPatternVariable, PsiRecordComponent> parent, Collection<PatternVariableWrapper> candidates, boolean strict) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(20);
        }
        if (pattern instanceof PsiTypeTestPattern) {
            PsiPatternVariable variable = ((PsiTypeTestPattern)pattern).getPatternVariable();
            if (variable != null && !PsiTreeUtil.isAncestor(scope, variable.getDeclarationScope(), strict)) {
                if (parent == null) {
                    candidates.add(new PatternVariableWrapper(variable, false));
                } else {
                    candidates.add(new DestructionComponent(variable, parent.getFirst(), parent.getSecond(), false));
                }
            }
        } else if (pattern instanceof PsiDeconstructionPattern) {
            PsiPattern[] components;
            PsiRecordComponent[] recordComponents;
            boolean isFake;
            PsiDeconstructionPattern deconstruction = (PsiDeconstructionPattern)pattern;
            PsiTypeElement typeElement = deconstruction.getTypeElement();
            PsiType type = typeElement.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type);
            PsiPatternVariable variable = deconstruction.getPatternVariable();
            boolean bl = isFake = variable == null;
            if (aClass != null && (recordComponents = aClass.getRecordComponents()).length == (components = deconstruction.getDeconstructionList().getDeconstructionComponents()).length && recordComponents.length != 0) {
                if (isFake) {
                    variable = JavaPsiPatternUtil.createFakePatternVariable(pattern, typeElement, type);
                }
                PatternVariableWrapper patternVariableWrapper = parent == null ? new PatternVariableWrapper(variable, isFake) : new DestructionComponent(variable, parent.getFirst(), parent.getSecond(), isFake);
                candidates.add(patternVariableWrapper);
                for (int i2 = 0; i2 < components.length; ++i2) {
                    JavaPsiPatternUtil.collectPatternVariableCandidates(components[i2], scope, Pair.pair(variable, recordComponents[i2]), candidates, strict);
                }
            }
        }
    }

    @NotNull
    private static PsiPatternVariable createFakePatternVariable(@NotNull PsiPattern pattern, @NotNull PsiTypeElement typeElement, @NotNull PsiType type) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(21);
        }
        if (typeElement == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(22);
        }
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(23);
        }
        Project project = pattern.getProject();
        PsiElementFactory factory = PsiElementFactory.getInstance(project);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(project);
        String name2 = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
        name2 = styleManager.suggestUniqueVariableName(name2, (PsiElement)pattern, true);
        PsiElement parent = pattern.getParent();
        String operand = parent instanceof PsiInstanceOfExpression ? ((PsiInstanceOfExpression)parent).getOperand().getText() : "x";
        String text2 = operand + " instanceof " + typeElement.getText() + " " + name2;
        PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)factory.createExpressionFromText(text2, null);
        PsiPatternVariable variable = ((PsiTypeTestPattern)Objects.requireNonNull(instanceOf.getPattern())).getPatternVariable();
        assert (variable != null);
        PsiPatternVariable psiPatternVariable = variable;
        if (psiPatternVariable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(24);
        }
        return psiPatternVariable;
    }

    @Nullable
    public static PsiType getContextType(@NotNull PsiPattern pattern) {
        PsiDeconstructionPattern parentPattern;
        PsiExpression expression;
        PsiSwitchBlock block;
        PsiSwitchLabelStatementBase label;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(25);
        }
        PsiElement parent = pattern.getParent();
        while (parent instanceof PsiParenthesizedPattern || parent instanceof PsiGuardedPattern) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiInstanceOfExpression) {
            return ((PsiInstanceOfExpression)parent).getOperand().getType();
        }
        if (parent instanceof PsiForeachPatternStatement) {
            PsiExpression iteratedValue = ((PsiForeachPatternStatement)parent).getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            return JavaGenericsUtil.getCollectionItemType(iteratedValue);
        }
        if (parent instanceof PsiCaseLabelElementList && (label = ObjectUtils.tryCast(parent.getParent(), PsiSwitchLabelStatementBase.class)) != null && (block = label.getEnclosingSwitchBlock()) != null && (expression = block.getExpression()) != null) {
            return expression.getType();
        }
        if (parent instanceof PsiDeconstructionList && (parentPattern = ObjectUtils.tryCast(parent.getParent(), PsiDeconstructionPattern.class)) != null) {
            int index2 = ArrayUtil.indexOf(((PsiDeconstructionList)parent).getDeconstructionComponents(), pattern);
            if (index2 < 0) {
                return null;
            }
            PsiType patternType = parentPattern.getTypeElement().getType();
            if (!(patternType instanceof PsiClassType)) {
                return null;
            }
            PsiSubstitutor parentSubstitutor = ((PsiClassType)patternType).resolveGenerics().getSubstitutor();
            PsiClass parentRecord = PsiUtil.resolveClassInClassTypeOnly(parentPattern.getTypeElement().getType());
            if (parentRecord == null) {
                return null;
            }
            PsiRecordComponent[] components = parentRecord.getRecordComponents();
            if (index2 >= components.length) {
                return null;
            }
            return parentSubstitutor.substitute(components[index2].getType());
        }
        return null;
    }

    @Nullable
    private static Object evaluateConstant(@Nullable PsiExpression expression) {
        if (expression == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(expression.getProject()).getConstantEvaluationHelper().computeConstantExpression(expression, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overWhom";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "who";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariables";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPatternVariableWrappers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakePatternVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariables";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableWrappers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveInitializerText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnconditionalForType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUnconditionalComponents";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dominatesComponents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRecordComponentForPattern";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDeconstructedImplicitPatternVariableType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDeconstructedImplicitPatternType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableCandidates";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFakePatternVariable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getContextType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PatternVariableWrapper {
        @NotNull
        private final PsiPatternVariable myVariable;
        private final boolean myIsFake;

        PatternVariableWrapper(@NotNull PsiPatternVariable variable, boolean isFake) {
            if (variable == null) {
                PatternVariableWrapper.$$$reportNull$$$0(0);
            }
            this.myVariable = variable;
            this.myIsFake = isFake;
        }

        @NotNull
        public PsiPatternVariable getVariable() {
            PsiPatternVariable psiPatternVariable = this.myVariable;
            if (psiPatternVariable == null) {
                PatternVariableWrapper.$$$reportNull$$$0(1);
            }
            return psiPatternVariable;
        }

        boolean isFake() {
            return this.myIsFake;
        }

        public String getEffectiveInitializerText() {
            return JavaPsiPatternUtil.getEffectiveInitializerText(this.myVariable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/util/JavaPsiPatternUtil$PatternVariableWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/util/JavaPsiPatternUtil$PatternVariableWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DestructionComponent
    extends PatternVariableWrapper {
        @NotNull
        private final PsiPatternVariable myParent;
        @NotNull
        private final PsiRecordComponent myRecordComponent;

        DestructionComponent(@NotNull PsiPatternVariable variable, @NotNull PsiPatternVariable parent, @NotNull PsiRecordComponent recordComponent, boolean isFake) {
            if (variable == null) {
                DestructionComponent.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                DestructionComponent.$$$reportNull$$$0(1);
            }
            if (recordComponent == null) {
                DestructionComponent.$$$reportNull$$$0(2);
            }
            super(variable, isFake);
            this.myParent = parent;
            this.myRecordComponent = recordComponent;
        }

        @Override
        public String getEffectiveInitializerText() {
            String text2 = this.myParent.getName() + "." + this.myRecordComponent.getName() + "()";
            PsiType type = this.getVariable().getType();
            if (!type.equals(this.myRecordComponent.getType())) {
                return "(" + type.getCanonicalText() + ")" + text2;
            }
            return text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "recordComponent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/util/JavaPsiPatternUtil$DestructionComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

