/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ManyProjectsStubIndexMismatch;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.UpToDateStubIndexMismatch;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ApplicationManager.getApplication().getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree<?> readOrBuild(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree<?> build(@Nullable Project var1, @NotNull VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree<?> readFromVFile(@NotNull Project var1, @NotNull VirtualFile var2);

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            StubTreeLoader.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Nullable
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoader.$$$reportNull$$$0(1);
        }
        return null;
    }

    protected boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoader.$$$reportNull$$$0(2);
        }
        return false;
    }

    @NotNull
    public RuntimeException stubTreeAndIndexDoNotMatch(@Nullable ObjectStubTree<?> stubTree, @NotNull PsiFileWithStubSupport psiFile, @Nullable Throwable cause) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(3);
        }
        RuntimeException runtimeException = ProgressManager.getInstance().computeInNonCancelableSection(() -> this.doCreateCoarseExceptionStubTreeAndIndexDoNotMatch(stubTree, psiFile, cause).doCreateCompleteException());
        if (runtimeException == null) {
            StubTreeLoader.$$$reportNull$$$0(4);
        }
        return runtimeException;
    }

    @NotNull
    public StubTreeAndIndexUnmatchCoarseException createCoarseExceptionStubTreeAndIndexDoNotMatch(@Nullable ObjectStubTree<?> stubTree, @NotNull PsiFileWithStubSupport psiFile, @Nullable Throwable cause) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(5);
        }
        StubTreeAndIndexUnmatchCoarseException stubTreeAndIndexUnmatchCoarseException = ProgressManager.getInstance().computeInNonCancelableSection(() -> this.doCreateCoarseExceptionStubTreeAndIndexDoNotMatch(stubTree, psiFile, cause));
        if (stubTreeAndIndexUnmatchCoarseException == null) {
            StubTreeLoader.$$$reportNull$$$0(6);
        }
        return stubTreeAndIndexUnmatchCoarseException;
    }

    @NotNull
    private StubTreeAndIndexUnmatchCoarseException doCreateCoarseExceptionStubTreeAndIndexDoNotMatch(@Nullable ObjectStubTree<?> stubTree, @NotNull PsiFileWithStubSupport psiFile, @Nullable Throwable cause) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(7);
        }
        StubTreeAndIndexUnmatchCoarseException stubTreeAndIndexUnmatchCoarseException = ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            VirtualFile file2 = psiFile.getViewProvider().getVirtualFile();
            boolean compiled = psiFile instanceof PsiCompiledElement;
            Document document = compiled ? null : FileDocumentManager.getInstance().getDocument(file2);
            IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(file2);
            boolean upToDate = indexingStampInfo != null && indexingStampInfo.isUpToDate(document, file2, psiFile);
            @NonNls String msg = "PSI and index do not match.\nPlease report the problem to JetBrains with the files attached\n";
            if (upToDate) {
                msg = msg + "INDEXED VERSION IS THE CURRENT ONE";
            }
            msg = msg + " file=" + psiFile;
            msg = msg + ", file.class=" + psiFile.getClass();
            msg = msg + ", file.lang=" + psiFile.getLanguage();
            msg = msg + ", modStamp=" + psiFile.getModificationStamp();
            if (!compiled) {
                String text2 = psiFile.getText();
                PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text2);
                if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                    boolean consistent = DebugUtil.psiToString(psiFile, false).equals(DebugUtil.psiToString(fromText, false));
                    msg = msg + (consistent ? "\n tree consistent" : "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText);
                }
            }
            if (stubTree != null) {
                msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
            }
            FileViewProvider viewProvider = psiFile.getViewProvider();
            msg = msg + "\n viewProvider=" + viewProvider;
            msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
            msg = msg + "; file stamp: " + file2.getModificationStamp();
            msg = msg + "; file modCount: " + file2.getModificationCount();
            msg = msg + "; file length: " + file2.getLength();
            if (document != null) {
                msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
                msg = msg + "; doc stamp: " + document.getModificationStamp();
                msg = msg + "; doc size: " + document.getTextLength();
                msg = msg + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document);
            }
            msg = msg + "\nindexing info: " + indexingStampInfo;
            ArrayList<Attachment> attachments = StubTreeLoader.createAttachments(stubTree, psiFile, file2);
            return new StubTreeAndIndexUnmatchCoarseException(psiFile, file2, msg, attachments, upToDate, cause, stubTree);
        });
        if (stubTreeAndIndexUnmatchCoarseException == null) {
            StubTreeLoader.$$$reportNull$$$0(8);
        }
        return stubTreeAndIndexUnmatchCoarseException;
    }

    private static RuntimeExceptionWithAttachments handleUpToDateMismatch(@NotNull String message, Attachment[] attachments, @Nullable Throwable cause) {
        if (message == null) {
            StubTreeLoader.$$$reportNull$$$0(9);
        }
        return new UpToDateStubIndexMismatch(message, cause, attachments);
    }

    private static RuntimeExceptionWithAttachments handleManyProjectsMismatch(@NotNull String message, Attachment[] attachments, @Nullable Throwable cause) {
        if (message == null) {
            StubTreeLoader.$$$reportNull$$$0(10);
        }
        return new ManyProjectsStubIndexMismatch(message, cause, attachments);
    }

    @NotNull
    private static ArrayList<Attachment> createAttachments(@Nullable ObjectStubTree<?> stubTree, @NotNull PsiFileWithStubSupport psiFile, @NotNull VirtualFile file2) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            StubTreeLoader.$$$reportNull$$$0(12);
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.add(new Attachment(file2.getPath() + "_file.txt", psiFile instanceof PsiCompiledElement ? "compiled" : psiFile.getText()));
        if (stubTree != null) {
            attachments.add(new Attachment("stubTree.txt", ((PsiFileStubImpl)stubTree.getRoot()).printTree()));
        }
        ArrayList<Attachment> arrayList = attachments;
        if (arrayList == null) {
            StubTreeLoader.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NonNls
    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider) {
        if (provider == null) {
            StubTreeLoader.$$$reportNull$$$0(14);
        }
        Function<PsiFile, String> fileClassName = file2 -> file2.getClass().getSimpleName();
        Function<Pair, String> stubRootToString = pair -> "(" + ((IStubFileElementType)pair.first).toString() + ", " + ((IStubFileElementType)pair.first).getLanguage() + " -> " + (String)fileClassName.fun((PsiFile)pair.second) + ")";
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(provider);
        return ", stubBindingRoot = " + fileClassName.fun(provider.getStubBindingRoot()) + ", languages = [" + StringUtil.join(provider.getLanguages(), Language::getID, ", ") + "], fileTypes = [" + StringUtil.join(provider.getAllFiles(), file2 -> file2.getFileType().getName(), ", ") + "], files = [" + StringUtil.join(provider.getAllFiles(), fileClassName, ", ") + "], roots = [" + StringUtil.join(roots, stubRootToString, ", ") + "], indexingInfo = " + StubTreeLoader.getInstance().getIndexingStampInfo(provider.getVirtualFile()) + ", isTooLarge = " + StubTreeLoader.getInstance().isTooLarge(provider.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTreeLoader";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTreeLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stubTreeAndIndexDoNotMatch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoarseExceptionStubTreeAndIndexDoNotMatch";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateCoarseExceptionStubTreeAndIndexDoNotMatch";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasPsiInManyProjects";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStampInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stubTreeAndIndexDoNotMatch";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCoarseExceptionStubTreeAndIndexDoNotMatch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateCoarseExceptionStubTreeAndIndexDoNotMatch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleUpToDateMismatch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleManyProjectsMismatch";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAttachments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileViewProviderMismatchDiagnostics";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StubTreeAndIndexUnmatchCoarseException
    extends Exception {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final String coarseMessage;
        @NotNull
        private final ArrayList<Attachment> coarseAttachments;
        @Nullable
        private final Throwable cause;
        private final boolean upToDate;
        private final int stubTreePlainListSize;

        private StubTreeAndIndexUnmatchCoarseException(@NotNull PsiFile psiFile, @NotNull VirtualFile file2, @NotNull String msg, @NotNull ArrayList<Attachment> attachments, boolean upToDate, @Nullable Throwable cause, @Nullable ObjectStubTree<?> stubTree) {
            if (psiFile == null) {
                StubTreeAndIndexUnmatchCoarseException.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                StubTreeAndIndexUnmatchCoarseException.$$$reportNull$$$0(1);
            }
            if (msg == null) {
                StubTreeAndIndexUnmatchCoarseException.$$$reportNull$$$0(2);
            }
            if (attachments == null) {
                StubTreeAndIndexUnmatchCoarseException.$$$reportNull$$$0(3);
            }
            this.project = psiFile.getProject();
            this.file = file2;
            this.coarseMessage = msg;
            this.coarseAttachments = attachments;
            this.cause = cause;
            this.upToDate = upToDate;
            this.stubTreePlainListSize = stubTree == null ? -1 : stubTree.getPlainList().size();
        }

        @NotNull
        public RuntimeException createCompleteException() {
            RuntimeException runtimeException = ProgressManager.getInstance().computeInNonCancelableSection(() -> this.doCreateCompleteException());
            if (runtimeException == null) {
                StubTreeAndIndexUnmatchCoarseException.$$$reportNull$$$0(4);
            }
            return runtimeException;
        }

        @NotNull
        private RuntimeException doCreateCompleteException() {
            StubTreeLoader instance = StubTreeLoader.getInstance();
            StubTree stubTreeFromIndex = (StubTree)instance.readFromVFile(this.project, this.file);
            String msg = this.coarseMessage;
            msg = msg + "\nlatestIndexedStub=" + stubTreeFromIndex;
            if (stubTreeFromIndex != null) {
                if (this.stubTreePlainListSize != -1) {
                    msg = msg + "\n   same size=" + (this.stubTreePlainListSize == stubTreeFromIndex.getPlainList().size());
                }
                msg = msg + "\n   debugInfo=" + stubTreeFromIndex.getDebugInfo();
            }
            if (stubTreeFromIndex != null) {
                this.coarseAttachments.add(new Attachment("stubTreeFromIndex.txt", ((PsiFileStubImpl)stubTreeFromIndex.getRoot()).printTree()));
            }
            Attachment[] attachments = this.coarseAttachments.toArray(Attachment.EMPTY_ARRAY);
            return instance.hasPsiInManyProjects(this.file) ? StubTreeLoader.handleManyProjectsMismatch(msg, attachments, this.cause) : (this.upToDate ? StubTreeLoader.handleUpToDateMismatch(msg, attachments, this.cause) : new RuntimeExceptionWithAttachments(msg, this.cause, attachments));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "msg";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attachments";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubTreeLoader$StubTreeAndIndexUnmatchCoarseException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubTreeLoader$StubTreeAndIndexUnmatchCoarseException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCompleteException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

