/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        block17: {
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session.getPresentableText(this.myT)));
                return false;
            }
            PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session.getPresentableText(this.myT)));
                return false;
            }
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
            PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
            PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
            if (lambdaParameters.length != parameters.length) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.parameter.types.in.lambda", parameters.length, lambdaParameters.length));
                return false;
            }
            if (this.myExpression.hasFormalParameterTypes()) {
                for (int i2 = 0; i2 < lambdaParameters.length; ++i2) {
                    constraints.add(new TypeEqualityConstraint(lambdaParameters[i2].getType(), session.substituteWithInferenceVariables(substitutor.substitute(parameters[i2].getType()))));
                }
                constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
            } else {
                for (PsiParameter parameter : parameters) {
                    PsiType type2 = session.substituteWithInferenceVariables(substitutor.substitute(parameter.getType()));
                    if (session.isProperType(type2)) continue;
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (returnType == null) break block17;
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            PsiElement lambdaBody = this.myExpression.getBody();
            if (returnType.equals(PsiTypes.voidType())) {
                if (!(lambdaBody instanceof PsiCodeBlock && this.myExpression.isVoidCompatible() || LambdaUtil.isExpressionStatementExpression(lambdaBody))) {
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.types.expected.void.lambda", new Object[0]));
                    return false;
                }
            } else {
                if (lambdaBody instanceof PsiCodeBlock && !this.myExpression.isValueCompatible()) {
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.expected.value.lambda", new Object[0]));
                    return false;
                }
                PsiSubstitutor nestedSubstitutor = session.getInferenceSessionContainer().findNestedSubstitutor(this.myExpression, session.getInferenceSubstitution());
                returnType = nestedSubstitutor.substitute(substitutor.substitute(returnType));
                boolean isProperType = InferenceSession.collectDependencies(returnType, null, type -> {
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
                    return psiClass instanceof InferenceVariable && nestedSubstitutor.getSubstitutionMap().containsValue(type) ? (InferenceVariable)psiClass : null;
                });
                if (!isProperType || this.myExpression.hasFormalParameterTypes()) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (InferenceSession.ignoreLambdaConstraintTree(returnExpression)) continue;
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType));
                    }
                } else {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression) || TypeConversionUtil.areTypesAssignmentCompatible(returnType, returnExpression)) continue;
                        PsiType type3 = returnExpression.getType();
                        if (type3 != null) {
                            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.bad.lambda.return.type", session.getPresentableText(type3), session.getPresentableText(returnType)));
                        } else {
                            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type", returnExpression.getText(), session.getPresentableText(returnType)));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache2) {
        this.myT = substitutor.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

