/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.GoToInstruction;
import org.jetbrains.annotations.NotNull;

public class ReturnInstruction
extends GoToInstruction {
    private static final Logger LOG = Logger.getInstance(ReturnInstruction.class);
    @NotNull
    private CallInstruction myCallInstruction;
    private boolean myRethrowFromFinally;

    public ReturnInstruction(int offset, @NotNull CallInstruction callInstruction) {
        if (callInstruction == null) {
            ReturnInstruction.$$$reportNull$$$0(0);
        }
        super(offset, BranchingInstruction.Role.END, false);
        this.myCallInstruction = callInstruction;
    }

    @Override
    public String toString() {
        return "RETURN FROM " + this.getProcBegin() + (this.offset == 0 ? "" : " TO " + this.offset);
    }

    int @NotNull [] getPossibleReturnOffsets() {
        int[] nArray;
        if (this.offset == 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = this.getProcBegin() - 5;
            nArray2[1] = this.getProcBegin() - 3;
            nArray = nArray2;
            nArray2[2] = this.getProcBegin() - 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = this.offset;
        }
        if (nArray == null) {
            ReturnInstruction.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    int getProcBegin() {
        return this.myCallInstruction.procBegin;
    }

    int getProcEnd() {
        return this.myCallInstruction.procEnd;
    }

    void setCallInstruction(@NotNull CallInstruction callInstruction) {
        if (callInstruction == null) {
            ReturnInstruction.$$$reportNull$$$0(2);
        }
        this.myCallInstruction = callInstruction;
    }

    @Override
    public int nNext() {
        return this.offset == 0 ? 3 : 1;
    }

    @Override
    public int getNext(int index2, int no) {
        if (this.offset == 0) {
            switch (no) {
                case 0: {
                    return this.getProcBegin() - 5;
                }
                case 1: {
                    return this.getProcBegin() - 3;
                }
                case 2: {
                    return this.getProcBegin() - 1;
                }
            }
            LOG.assertTrue(false);
            return -1;
        }
        if (no == 0) {
            return this.offset;
        }
        LOG.assertTrue(false);
        return -1;
    }

    @Override
    public void accept(@NotNull ControlFlowInstructionVisitor visitor, int offset, int nextOffset) {
        if (visitor == null) {
            ReturnInstruction.$$$reportNull$$$0(3);
        }
        visitor.visitReturnInstruction(this, offset, nextOffset);
    }

    void setRethrowFromFinally() {
        this.myRethrowFromFinally = true;
    }

    boolean isRethrowFromFinally() {
        return this.myRethrowFromFinally;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callInstruction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ReturnInstruction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ReturnInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleReturnOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCallInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

