/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

public final class TrigramBuilder {
    private TrigramBuilder() {
    }

    public static boolean processTrigrams(@NotNull CharSequence text2, @NotNull TrigramProcessor consumer) {
        IntSet trigrams;
        if (text2 == null) {
            TrigramBuilder.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            TrigramBuilder.$$$reportNull$$$0(1);
        }
        if (!consumer.consumeTrigramsCount((trigrams = TrigramBuilder.getTrigrams(text2)).size())) {
            return false;
        }
        IntIterator iterator2 = trigrams.intIterator();
        while (iterator2.hasNext()) {
            int trigram = iterator2.nextInt();
            if (consumer.test(trigram)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Map<Integer, Void> getTrigramsAsMap(final @NotNull CharSequence text2) {
        if (text2 == null) {
            TrigramBuilder.$$$reportNull$$$0(2);
        }
        return new AbstractInt2ObjectMap<Void>(){
            final IntSet trigrams;
            {
                this.trigrams = TrigramBuilder.getTrigrams(text2);
            }

            @Override
            public int size() {
                return this.trigrams.size();
            }

            @Override
            public boolean containsKey(int k) {
                return this.trigrams.contains(k);
            }

            @Override
            public boolean containsValue(Object v) {
                return v == null && !this.isEmpty();
            }

            @Override
            public ObjectSet<Int2ObjectMap.Entry<Void>> int2ObjectEntrySet() {
                return new AbstractObjectSet<Int2ObjectMap.Entry<Void>>(){

                    @Override
                    public ObjectIterator<Int2ObjectMap.Entry<Void>> iterator() {
                        final IntIterator iterator2 = trigrams.intIterator();
                        return new AbstractObjectIterator<Int2ObjectMap.Entry<Void>>(){

                            @Override
                            public boolean hasNext() {
                                return iterator2.hasNext();
                            }

                            @Override
                            public Int2ObjectMap.Entry<Void> next() {
                                final int key = iterator2.nextInt();
                                return new Int2ObjectMap.Entry<Void>(){

                                    @Override
                                    public int getIntKey() {
                                        return key;
                                    }

                                    @Override
                                    public Void getValue() {
                                        return null;
                                    }

                                    @Override
                                    public Void setValue(Void value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return trigrams.size();
                    }
                };
            }

            @Override
            public Void get(int key) {
                return null;
            }
        };
    }

    @NotNull
    public static IntSet getTrigrams(@NotNull CharSequence text2) {
        if (text2 == null) {
            TrigramBuilder.$$$reportNull$$$0(3);
        }
        AddonlyIntSet set = new AddonlyIntSet();
        int index2 = 0;
        char[] fileTextArray = CharArrayUtil.fromSequenceWithoutCopying(text2);
        while (index2 != text2.length()) {
            char c;
            char c2 = c = fileTextArray != null ? fileTextArray[index2] : text2.charAt(index2);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierPart(c))) {
                ++index2;
                continue;
            }
            int identifierStart = index2;
            while (++index2 != text2.length()) {
                char c3;
                char c4 = c3 = fileTextArray != null ? fileTextArray[index2] : text2.charAt(index2);
                if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || Character.isJavaIdentifierPart(c3)) continue;
                break;
            }
            int tc1 = 0;
            int tc2 = 0;
            int i2 = identifierStart;
            int iters = 0;
            while (i2 < index2) {
                char c5 = StringUtil.toLowerCase(fileTextArray != null ? fileTextArray[i2] : text2.charAt(i2));
                int tc3 = (tc2 << 8) + c5;
                tc2 = (tc1 << 8) + c5;
                tc1 = c5;
                if (iters >= 2) {
                    set.add(tc3);
                }
                ++i2;
                ++iters;
            }
        }
        AddonlyIntSet addonlyIntSet = set;
        if (addonlyIntSet == null) {
            TrigramBuilder.$$$reportNull$$$0(4);
        }
        return addonlyIntSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/TrigramBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/TrigramBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrigrams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processTrigrams";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTrigramsAsMap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTrigrams";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class TrigramProcessor
    implements IntPredicate {
        public boolean consumeTrigramsCount(int count2) {
            return true;
        }
    }

    private static class AddonlyIntSet
    extends AbstractIntSet {
        private int size;
        private int[] data;
        private int mask;
        private boolean hasZeroKey;

        AddonlyIntSet() {
            this(21);
        }

        @Override
        public IntIterator iterator() {
            return new AbstractIntIterator(){
                private int pos = -1;

                @Override
                public int nextInt() {
                    if (this.pos == -1 && hasZeroKey) {
                        this.pos = 0;
                        return 0;
                    }
                    for (int i2 = Math.max(0, this.pos); i2 < data.length; ++i2) {
                        if (data[i2] == 0) continue;
                        this.pos = i2 + 1;
                        return data[i2];
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasNext() {
                    if (this.pos == -1 && hasZeroKey) {
                        return true;
                    }
                    for (int i2 = Math.max(0, this.pos); i2 < data.length; ++i2) {
                        if (data[i2] == 0) continue;
                        this.pos = i2;
                        return true;
                    }
                    return false;
                }
            };
        }

        AddonlyIntSet(int expectedSize) {
            int powerOfTwo = Integer.highestOneBit(3 * expectedSize / 2) << 1;
            this.mask = powerOfTwo - 1;
            this.data = new int[powerOfTwo];
        }

        @Override
        public int size() {
            return this.size;
        }

        private int hash(int h) {
            h ^= h >>> 20 ^ h >>> 12;
            return (h ^ h >>> 7 ^ h >>> 4) & this.mask;
        }

        @Override
        public boolean add(int key) {
            boolean updated;
            if (key == 0) {
                if (!this.hasZeroKey) {
                    this.hasZeroKey = true;
                    ++this.size;
                    return true;
                }
                return false;
            }
            if (this.size >= 2 * this.data.length / 3) {
                this.rehash();
            }
            if (updated = this.doPut(this.data, key)) {
                ++this.size;
            }
            return updated;
        }

        private boolean doPut(int[] a, int o) {
            int obj;
            int index2 = this.hash(o);
            while ((obj = a[index2]) != 0 && obj != o) {
                if (index2 == 0) {
                    index2 = a.length;
                }
                --index2;
            }
            a[index2] = o;
            return obj == 0;
        }

        private void rehash() {
            int[] b = new int[this.data.length << 1];
            this.mask = b.length - 1;
            int i2 = this.data.length;
            while (--i2 >= 0) {
                int ns = this.data[i2];
                if (ns == 0) continue;
                this.doPut(b, ns);
            }
            this.data = b;
        }

        @Override
        public boolean contains(int key) {
            int v;
            if (key == 0) {
                return this.hasZeroKey;
            }
            int index2 = this.hash(key);
            while ((v = this.data[index2]) != 0) {
                if (v == key) {
                    return true;
                }
                if (index2 == 0) {
                    index2 = this.data.length;
                }
                --index2;
            }
            return false;
        }

        public boolean forEach(@NotNull IntPredicate consumer) {
            if (consumer == null) {
                AddonlyIntSet.$$$reportNull$$$0(0);
            }
            if (this.hasZeroKey && !consumer.test(0)) {
                return false;
            }
            for (int o : this.data) {
                if (o == 0 || consumer.test(o)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/text/TrigramBuilder$AddonlyIntSet", "forEach"));
        }
    }
}

