/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.util.Processor;
import java.util.function.Predicate;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager
implements SavingRequestor {
    @NotNull
    public static FileDocumentManager getInstance() {
        FileDocumentManager fileDocumentManager = ApplicationManager.getApplication().getService(FileDocumentManager.class);
        if (fileDocumentManager == null) {
            FileDocumentManager.$$$reportNull$$$0(0);
        }
        return fileDocumentManager;
    }

    @Nullable
    public abstract Document getDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveAllDocuments();

    public abstract void saveDocuments(@NotNull Predicate<? super Document> var1);

    public abstract void saveDocument(@NotNull Document var1);

    public abstract void saveDocumentAsIs(@NotNull Document var1);

    public abstract Document @NotNull [] getUnsavedDocuments();

    public boolean processUnsavedDocuments(Processor<? super Document> processor) {
        for (Document doc : this.getUnsavedDocuments()) {
            if (processor.process(doc)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract boolean isFileModified(@NotNull VirtualFile var1);

    public abstract boolean isPartialPreviewOfALargeFile(@NotNull Document var1);

    public abstract void reloadFromDisk(@NotNull Document var1);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    public abstract boolean requestWriting(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public WriteAccessStatus requestWritingStatus(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            FileDocumentManager.$$$reportNull$$$0(1);
        }
        WriteAccessStatus writeAccessStatus = this.requestWriting(document, project) ? WriteAccessStatus.WRITABLE : WriteAccessStatus.NON_WRITABLE;
        if (writeAccessStatus == null) {
            FileDocumentManager.$$$reportNull$$$0(2);
        }
        return writeAccessStatus;
    }

    public static boolean fileForDocumentCheckedOutSuccessfully(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            FileDocumentManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FileDocumentManager.$$$reportNull$$$0(4);
        }
        return FileDocumentManager.getInstance().requestWriting(document, project);
    }

    public abstract void reloadFiles(VirtualFile ... var1);

    @ApiStatus.Internal
    public void reloadBinaryFiles() {
    }

    @ApiStatus.Internal
    @Nullable
    public FileViewProvider findCachedPsiInAnyProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManager.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileForDocumentCheckedOutSuccessfully";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiInAnyProject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WriteAccessStatus {
        public static final WriteAccessStatus NON_WRITABLE = new WriteAccessStatus(false);
        public static final WriteAccessStatus WRITABLE = new WriteAccessStatus(true);
        private final boolean myWithWriteAccess;
        @NotNull
        private final @NlsContexts.HintText String myReadOnlyMessage;
        @Nullable
        private final HyperlinkListener myHyperlinkListener;

        private WriteAccessStatus(boolean withWriteAccess) {
            this.myWithWriteAccess = withWriteAccess;
            this.myReadOnlyMessage = withWriteAccess ? "" : CoreBundle.message("editing.read.only.file.hint", new Object[0]);
            this.myHyperlinkListener = null;
        }

        public WriteAccessStatus(@NotNull @NlsContexts.HintText String readOnlyMessage) {
            if (readOnlyMessage == null) {
                WriteAccessStatus.$$$reportNull$$$0(0);
            }
            this(readOnlyMessage, null);
        }

        public WriteAccessStatus(@NotNull @NlsContexts.HintText String readOnlyMessage, @Nullable HyperlinkListener hyperlinkListener) {
            if (readOnlyMessage == null) {
                WriteAccessStatus.$$$reportNull$$$0(1);
            }
            this.myWithWriteAccess = false;
            this.myReadOnlyMessage = readOnlyMessage;
            this.myHyperlinkListener = hyperlinkListener;
        }

        public boolean hasWriteAccess() {
            return this.myWithWriteAccess;
        }

        @NotNull
        @NlsContexts.HintText
        public String getReadOnlyMessage() {
            String string2 = this.myReadOnlyMessage;
            if (string2 == null) {
                WriteAccessStatus.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myHyperlinkListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager$WriteAccessStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager$WriteAccessStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadOnlyMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

