/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mvstore;

import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/mvstore/StoreErrorHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "dbFile", "Ljava/nio/file/Path;", "logSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/diagnostic/Logger;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)V", "isStoreOpened", "", "uncaughtException", "", "t", "Ljava/lang/Thread;", "e", "", "intellij.platform.util.ex"})
final class StoreErrorHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    private final Path dbFile;
    @NotNull
    private final Function0<Logger> logSupplier;
    @JvmField
    public boolean isStoreOpened;

    public StoreErrorHandler(@NotNull Path dbFile, @NotNull Function0<? extends Logger> logSupplier) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter(logSupplier, (String)"logSupplier");
        this.dbFile = dbFile;
        this.logSupplier = logSupplier;
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Logger log = (Logger)this.logSupplier.invoke();
        if (this.isStoreOpened) {
            log.error("Store error (db=" + this.dbFile + ")", e);
        } else {
            log.warn("Store will be recreated (db=" + this.dbFile + ")", e);
        }
    }
}

