/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.SideEffectGuardImpl;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.EnumSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface SideEffectGuard {
    public static <T, E extends Throwable> T computeWithoutSideEffects(ThrowableComputable<T, E> supplier) throws E {
        return SideEffectGuard.computeWithAllowedSideEffects(SideEffectGuardImpl.NO_EFFECTS, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithAllowedSideEffects(EnumSet<EffectType> effects, ThrowableComputable<T, E> supplier) throws E {
        EnumSet<EffectType> previous = SideEffectGuardImpl.ourSideEffects.get();
        SideEffectGuardImpl.ourSideEffects.set((EnumSet<EffectType>)effects.clone());
        try {
            T t = supplier.compute();
            return t;
        }
        finally {
            SideEffectGuardImpl.ourSideEffects.set(previous);
        }
    }

    public static void checkSideEffectAllowed(@NotNull EffectType effectType) {
        if (effectType == null) {
            SideEffectGuard.$$$reportNull$$$0(0);
        }
        if (!SideEffectGuardImpl.isAllowed(effectType)) {
            throw new SideEffectNotAllowedException(effectType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectType", "com/intellij/model/SideEffectGuard", "checkSideEffectAllowed"));
    }

    public static enum EffectType {
        PROJECT_MODEL,
        SETTINGS,
        EXEC,
        INVOKE_LATER;

    }

    public static final class SideEffectNotAllowedException
    extends IllegalStateException
    implements ControlFlowException {
        public SideEffectNotAllowedException(@NotNull EffectType effectType) {
            if (effectType == null) {
                SideEffectNotAllowedException.$$$reportNull$$$0(0);
            }
            super("Side effect not allowed: " + effectType.name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectType", "com/intellij/model/SideEffectGuard$SideEffectNotAllowedException", "<init>"));
        }
    }
}

