/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmClassUtil {
    private JvmClassUtil() {
    }

    @Nullable
    public static String getJvmClassName(@NotNull JvmClass aClass) {
        String qualifiedName;
        if (aClass == null) {
            JvmClassUtil.$$$reportNull$$$0(0);
        }
        SmartList<String> parts = new SmartList<String>();
        JvmClass current2 = aClass;
        while (true) {
            JvmClass containingClass;
            if ((containingClass = current2.getContainingClass()) == null) {
                qualifiedName = current2.getQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                break;
            }
            String name2 = current2.getName();
            if (name2 == null) {
                return null;
            }
            parts.add(name2);
            current2 = containingClass;
        }
        parts.add(qualifiedName);
        return StringUtil.join(ContainerUtil.reverse(parts), "$");
    }

    @Contract(pure=true)
    @NotNull
    public static Comparator<JvmClass> createScopeComparator(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JvmClassUtil.$$$reportNull$$$0(1);
        }
        Comparator comparator = (c1, c2) -> {
            VirtualFile file1 = PsiUtilCore.getVirtualFile(c1.getSourceElement());
            VirtualFile file2 = PsiUtilCore.getVirtualFile(c2.getSourceElement());
            if (file1 == null) {
                return file2 == null ? 0 : -1;
            }
            if (file2 == null) {
                return 1;
            }
            return scope.compare(file2, file1);
        };
        if (comparator == null) {
            JvmClassUtil.$$$reportNull$$$0(2);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/jvm/util/JvmClassUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/jvm/util/JvmClassUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJvmClassName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createScopeComparator";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

