/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CustomFoldingProvider {
    public static final ExtensionPointName<CustomFoldingProvider> EP_NAME = ExtensionPointName.create("com.intellij.customFoldingProvider");
    private static final Logger LOG = Logger.getInstance(CustomFoldingProvider.class);

    @NotNull
    public static List<CustomFoldingProvider> getAllProviders() {
        List<CustomFoldingProvider> list = EP_NAME.getExtensionList();
        if (list == null) {
            CustomFoldingProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    public abstract boolean isCustomRegionStart(String var1);

    public abstract boolean isCustomRegionEnd(String var1);

    public abstract String getPlaceholderText(String var1);

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String getDescription();

    public boolean wrapStartEndMarkerTextInLanguageSpecificComment() {
        return true;
    }

    public boolean isSupportedBy(FoldingBuilder foldingBuilder) {
        if (!this.wrapStartEndMarkerTextInLanguageSpecificComment()) {
            LOG.error("non-comment based custom folding node need to be filtered in overridden `CustomFoldingBuilder#isCustomFoldingCandidate(ASTNode)`");
        }
        return foldingBuilder instanceof CustomFoldingBuilder;
    }

    public boolean isSupported(@NotNull Language language) {
        if (language == null) {
            CustomFoldingProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    @NonNls
    public abstract String getStartString();

    @NonNls
    public abstract String getEndString();

    public boolean isCollapsedByDefault(String text2) {
        return CodeFoldingSettings.getInstance().COLLAPSE_CUSTOM_FOLDING_REGIONS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/CustomFoldingProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/CustomFoldingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

