/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginPlatform;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerState;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.PluginSetBuilder;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.Java11Shim;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.lang.ZipFilePool;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class PluginManagerCore {
    @NonNls
    public static final String META_INF = "META-INF/";
    public static final String CORE_PLUGIN_ID = "com.intellij";
    public static final PluginId CORE_ID = PluginId.getId("com.intellij");
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId("com.intellij.java");
    static final PluginId JAVA_MODULE_ID = PluginId.getId("com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    static final PluginId ALL_MODULES_MARKER = PluginId.getId("com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    public static final String VENDOR_JETBRAINS_SRO = "JetBrains s.r.o.";
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final String PLATFORM_DEPENDENCY_PREFIX = "com.intellij.platform";
    public static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId("IDEA CORE");
    @NonNls
    static final String DISABLE = "disable";
    @NonNls
    static final String ENABLE = "enable";
    @NonNls
    static final String EDIT = "edit";
    private static volatile boolean IGNORE_COMPATIBILITY = Boolean.getBoolean("idea.ignore.plugin.compatibility");
    private static final boolean QODANA_PLUGINS_THIRD_PARTY_ACCEPT = Boolean.getBoolean("idea.qodana.thirdpartyplugins.accept");
    private static final String THIRD_PARTY_PLUGINS_FILE = "alien_plugins.txt";
    @Nullable
    private static volatile Boolean thirdPartyPluginsNoteAccepted = null;
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;
    @Nullable
    private static volatile PluginSet pluginSet;
    private static Map<PluginId, PluginLoadingError> pluginLoadingErrors;
    @VisibleForTesting
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    private static final List<Supplier<? extends HtmlChunk>> pluginErrors;
    private static Set<PluginId> ourPluginsToDisable;
    private static Set<PluginId> ourPluginsToEnable;
    private static Set<PluginId> shadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile Deferred<PluginSet> initFuture;
    private static BuildNumber ourBuildNumber;

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPluginSet().allPlugins.toArray(new IdeaPluginDescriptor[0]);
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginSet getPluginSet() {
        PluginSet pluginSet = Objects.requireNonNull(PluginManagerCore.pluginSet);
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return pluginSet;
    }

    @Nullable
    static PluginSet getNullablePluginSet() {
        return pluginSet;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        List<IdeaPluginDescriptorImpl> list = PluginManagerCore.getPluginSet().enabledPlugins;
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public static List<HtmlChunk> getAndClearPluginLoadingErrors() {
        List<Supplier<? extends HtmlChunk>> list = pluginErrors;
        // MONITORENTER : list
        if (pluginErrors.isEmpty()) {
            List<HtmlChunk> list2 = Collections.emptyList();
            // MONITOREXIT : list
            if (list2 != null) return list2;
            PluginManagerCore.$$$reportNull$$$0(3);
            return list2;
        }
        ArrayList<HtmlChunk> errors = new ArrayList<HtmlChunk>(pluginErrors.size());
        Iterator<Supplier<? extends HtmlChunk>> iterator2 = pluginErrors.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                pluginErrors.clear();
                ArrayList<HtmlChunk> arrayList = errors;
                // MONITOREXIT : list
                if (arrayList != null) return arrayList;
                PluginManagerCore.$$$reportNull$$$0(4);
                return arrayList;
            }
            Supplier<? extends HtmlChunk> t = iterator2.next();
            errors.add(t.get());
        }
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return pluginSet != null;
    }

    @ApiStatus.Internal
    public static void setPluginSet(@NotNull PluginSet value) {
        if (value == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        pluginSet = value;
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        return PluginEnabler.HEADLESS.isDisabled(pluginId);
    }

    @ApiStatus.Internal
    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Set<String> set = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set != null && set.contains(descriptor2.getVersion());
    }

    @ApiStatus.Internal
    public static void updateBrokenPlugins(Map<PluginId, Set<String>> brokenPlugins) {
        brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(brokenPlugins);
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        try (DataOutputStream out2 = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(updatedBrokenPluginFile, new OpenOption[0]), 32000));){
            out2.write(2);
            out2.writeUTF(PluginManagerCore.getBuildNumber().asString());
            out2.writeInt(brokenPlugins.size());
            for (Map.Entry<PluginId, Set<String>> entry : brokenPlugins.entrySet()) {
                out2.writeUTF(entry.getKey().getIdString());
                out2.writeShort(entry.getValue().size());
                for (String s : entry.getValue()) {
                    out2.writeUTF(s);
                }
            }
        }
        catch (NoSuchFileException out2) {
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + updatedBrokenPluginFile, e);
        }
    }

    @NotNull
    static @NotNull Map<@NotNull PluginId, @NotNull Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2;
        if (PluginEnabler.HEADLESS.isIgnoredDisabledPlugins()) {
            Map<PluginId, Set<String>> map2 = Collections.emptyMap();
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return map2;
        }
        Map<PluginId, Set<String>> map3 = result2 = brokenPluginVersions == null ? null : brokenPluginVersions.get();
        if (result2 == null) {
            result2 = PluginManagerCore.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        }
        Map<PluginId, Set<String>> map4 = result2;
        if (map4 == null) {
            PluginManagerCore.$$$reportNull$$$0(9);
        }
        return map4;
    }

    @NotNull
    private static Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> result2 = null;
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0]) && (result2 = PluginManagerCore.tryReadBrokenPluginsFile(updatedBrokenPluginFile)) != null) {
            PluginManagerCore.getLogger().info("Using cached broken plugins file");
        }
        if (result2 == null && (result2 = PluginManagerCore.tryReadBrokenPluginsFile(Paths.get(PathManager.getBinPath() + "/brokenPlugins.db", new String[0]))) != null) {
            PluginManagerCore.getLogger().info("Using broken plugins file from IDE distribution");
        }
        if (result2 != null) {
            Map<PluginId, Set<String>> map2 = result2;
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(10);
            }
            return map2;
        }
        Map<PluginId, Set<String>> map3 = Collections.emptyMap();
        if (map3 == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        return map3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        try (DataInputStream stream2 = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));){
            int version = stream2.readUnsignedByte();
            if (version != 2) {
                PluginManagerCore.getLogger().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version + ", supportedVersion=2)");
                Map<PluginId, Set<String>> map2 = null;
                return map2;
            }
            String buildNumber = stream2.readUTF();
            if (!buildNumber.equals(PluginManagerCore.getBuildNumber().toString())) {
                PluginManagerCore.getLogger().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ")");
                Map<PluginId, Set<String>> map3 = null;
                return map3;
            }
            int count2 = stream2.readInt();
            HashMap<PluginId, Set<String>> result2 = new HashMap<PluginId, Set<String>>(count2);
            for (int i2 = 0; i2 < count2; ++i2) {
                PluginId pluginId = PluginId.getId(stream2.readUTF());
                String[] versions = new String[stream2.readUnsignedShort()];
                for (int j = 0; j < versions.length; ++j) {
                    versions[j] = stream2.readUTF();
                }
                result2.put(pluginId, versions.length == 1 ? Collections.singleton(versions[0]) : new HashSet<String>(Arrays.asList(versions)));
            }
            HashMap<PluginId, Set<String>> hashMap = result2;
            return hashMap;
        }
        catch (NoSuchFileException stream2) {
            return null;
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + brokenPluginsStorage, e);
        }
        return null;
    }

    @ApiStatus.Internal
    public static boolean disablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        return PluginEnabler.HEADLESS.disableById(Collections.singleton(id));
    }

    @ApiStatus.Internal
    public static boolean enablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        return PluginEnabler.HEADLESS.enableById(Collections.singleton(id));
    }

    @ApiStatus.Internal
    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        String idString;
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        return (idString = dependentPluginId.getIdString()).startsWith(MODULE_DEPENDENCY_PREFIX) || idString.startsWith(PLATFORM_DEPENDENCY_PREFIX) && !"com.intellij.platform.images".equals(idString);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        PluginId id = (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
        return id == null || CORE_ID.equals(id) ? null : id;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
    }

    @ApiStatus.Internal
    public static boolean isPlatformClass(@NotNull @NonNls String className) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.");
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull @NonNls String className) {
        PluginSet pluginSet;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null || PluginManagerCore.isPlatformClass(className) || !className.contains(".")) {
            return null;
        }
        IdeaPluginDescriptorImpl result2 = null;
        for (IdeaPluginDescriptorImpl descriptor2 : pluginSet.getEnabledModules()) {
            ClassLoader classLoader = descriptor2.getPluginClassLoader();
            if (!(classLoader instanceof UrlClassLoader) || !((UrlClassLoader)classLoader).hasLoadedClass(className)) continue;
            result2 = descriptor2;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (!CORE_ID.equals(result2.getPluginId()) || className.startsWith("com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result2;
        }
        return PluginManagerCore.findClassInPluginThatUsesCoreClassloader(className, pluginSet);
    }

    @Nullable
    private static IdeaPluginDescriptorImpl findClassInPluginThatUsesCoreClassloader(@NonNls @NotNull String className, PluginSet pluginSet) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        String root = null;
        for (IdeaPluginDescriptorImpl descriptor2 : pluginSet.enabledPlugins) {
            if (!descriptor2.isUseIdeaClassLoader) continue;
            if (root == null && (root = PathManager.getResourceRoot(descriptor2.getClassLoader(), className.replace('.', '/') + ".class")) == null) {
                return null;
            }
            Path path = descriptor2.getPluginPath();
            if (!root.startsWith(FileUtilRt.toSystemIndependentName(path.toString()))) continue;
            return descriptor2;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorIfIdeaClassLoaderIsUsed(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        String className = aClass.getName();
        PluginSet pluginSet = PluginManagerCore.pluginSet;
        if (pluginSet == null || PluginManagerCore.isPlatformClass(className) || !className.contains(".")) {
            return null;
        }
        return PluginManagerCore.findClassInPluginThatUsesCoreClassloader(className, pluginSet);
    }

    public static boolean isDevelopedByJetBrains(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        return CORE_ID.equals(plugin.getPluginId()) || SPECIAL_IDEA_PLUGIN_ID.equals(plugin.getPluginId()) || PluginManagerCore.isDevelopedByJetBrains(plugin.getVendor()) || PluginManagerCore.isDevelopedByJetBrains(plugin.getOrganization());
    }

    public static boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        if (PluginManagerCore.isVendorJetBrains(vendorString)) {
            return true;
        }
        for (String vendor : vendorString.split(",")) {
            String vendorItem = vendor.trim();
            if (!PluginManagerCore.isVendorJetBrains(vendorItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVendorJetBrains(@NotNull String vendorItem) {
        if (vendorItem == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return VENDOR_JETBRAINS.equals(vendorItem) || VENDOR_JETBRAINS_SRO.equals(vendorItem);
    }

    private static Path getUpdatedBrokenPluginFile() {
        return Paths.get(PathManager.getConfigPath(), new String[0]).resolve("updatedBrokenPlugins.db");
    }

    public static synchronized void invalidatePlugins() {
        pluginSet = null;
        Deferred<PluginSet> future = initFuture;
        if (future != null) {
            initFuture = null;
            future.cancel(new CancellationException("invalidatePlugins"));
        }
        DisabledPluginsState.Companion.invalidate();
        shadowedBundledPlugins = null;
    }

    public static boolean isRunningFromSources() {
        Boolean result2 = isRunningFromSources;
        if (result2 == null) {
            isRunningFromSources = result2 = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result2;
    }

    @NotNull
    private static List<Supplier<HtmlChunk>> preparePluginErrors(@NotNull List<? extends Supplier<@NlsContexts.DetailedDescription String>> globalErrorsSuppliers) {
        if (globalErrorsSuppliers == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        if (pluginLoadingErrors.isEmpty() && globalErrorsSuppliers.isEmpty()) {
            return new ArrayList<Supplier<HtmlChunk>>();
        }
        List<@NlsContexts.DetailedDescription T> globalErrors = globalErrorsSuppliers.stream().map(Supplier::get).collect(Collectors.toList());
        List loadingErrors = pluginLoadingErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        String logMessage = "Problems found loading plugins:\n  " + Stream.concat(globalErrors.stream(), loadingErrors.stream().map(PluginLoadingError::getInternalMessage)).collect(Collectors.joining("\n  "));
        if (isUnitTestMode || !GraphicsEnvironment.isHeadless()) {
            PluginManagerCore.getLogger().warn(logMessage);
            List<Supplier<HtmlChunk>> list = Stream.concat(globalErrors.stream(), loadingErrors.stream().filter(PluginLoadingError::isNotifyUser).map(PluginLoadingError::getDetailedMessage)).map(text2 -> () -> HtmlChunk.text(text2)).collect(Collectors.toList());
            if (list == null) {
                PluginManagerCore.$$$reportNull$$$0(24);
            }
            return list;
        }
        PluginManagerCore.getLogger().error(logMessage);
        return new ArrayList<Supplier<HtmlChunk>>();
    }

    @Nullable
    public static PluginLoadingError getLoadingError(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        return pluginLoadingErrors.get(pluginId);
    }

    @NotNull
    private static List<Supplier<? extends HtmlChunk>> prepareActions(@NotNull Collection<String> pluginNamesToDisable, @NotNull Collection<String> pluginNamesToEnable) {
        if (pluginNamesToDisable == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (pluginNamesToEnable == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (pluginNamesToDisable.isEmpty()) {
            List<Supplier<? extends HtmlChunk>> list = Collections.emptyList();
            if (list == null) {
                PluginManagerCore.$$$reportNull$$$0(28);
            }
            return list;
        }
        ArrayList<Supplier<HtmlChunk>> actions = new ArrayList<Supplier<HtmlChunk>>();
        String pluginNameToDisable = ContainerUtil.getOnlyItem(pluginNamesToDisable);
        String disableMessage = pluginNameToDisable != null ? CoreBundle.message("link.text.disable.plugin", pluginNameToDisable) : CoreBundle.message("link.text.disable.not.loaded.plugins", new Object[0]);
        actions.add(() -> HtmlChunk.link(DISABLE, disableMessage));
        if (!pluginNamesToEnable.isEmpty()) {
            String pluginNameToEnable = ContainerUtil.getOnlyItem(pluginNamesToEnable);
            String enableMessage = pluginNameToEnable != null ? CoreBundle.message("link.text.enable.plugin", pluginNameToEnable) : CoreBundle.message("link.text.enable.all.necessary.plugins", new Object[0]);
            actions.add(() -> HtmlChunk.link(ENABLE, enableMessage));
        }
        actions.add(() -> HtmlChunk.link(EDIT, CoreBundle.message("link.text.open.plugin.manager", new Object[0])));
        List<Supplier<? extends HtmlChunk>> list = Collections.unmodifiableList(actions);
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        return list;
    }

    @ApiStatus.Internal
    static synchronized boolean onEnable(boolean enabled) {
        boolean applied;
        Set<PluginId> pluginIds = enabled ? ourPluginsToEnable : ourPluginsToDisable;
        ourPluginsToEnable = null;
        ourPluginsToDisable = null;
        boolean bl = applied = pluginIds != null;
        if (applied) {
            ArrayList<IdeaPluginDescriptorImpl> descriptors = new ArrayList<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl descriptor2 : PluginManagerCore.getPluginSet().allPlugins) {
                if (!pluginIds.contains(descriptor2.getPluginId())) continue;
                descriptor2.setEnabled(enabled);
                if (descriptor2.moduleName != null) continue;
                descriptors.add(descriptor2);
            }
            PluginEnabler pluginEnabler = PluginEnabler.getInstance();
            if (enabled) {
                pluginEnabler.enable(descriptors);
            } else {
                pluginEnabler.disable(descriptors);
            }
        }
        return applied;
    }

    public static void scheduleDescriptorLoading(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        PluginManagerCore.scheduleDescriptorLoading(coroutineScope, null);
    }

    @ApiStatus.Internal
    public static synchronized void scheduleDescriptorLoading(@NotNull CoroutineScope coroutineScope, @Nullable Deferred<ZipFilePool> zipFilePoolDeferred) {
        if (coroutineScope == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        if (initFuture == null) {
            initFuture = PluginDescriptorLoader.scheduleLoading(coroutineScope, zipFilePoolDeferred);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<List<IdeaPluginDescriptorImpl>> getEnabledPluginRawList() {
        PluginManagerCore.scheduleDescriptorLoading(GlobalScope.INSTANCE, null);
        CompletionStage completionStage = FutureKt.asCompletableFuture(initFuture).thenApply(it -> it.enabledPlugins);
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        return completionStage;
    }

    @ApiStatus.Internal
    @NotNull
    public static Deferred<PluginSet> getInitPluginFuture() {
        Deferred<PluginSet> future = initFuture;
        if (future == null) {
            throw new IllegalStateException("Call scheduleDescriptorLoading() first");
        }
        Deferred<PluginSet> deferred = future;
        if (deferred == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        return deferred;
    }

    @NotNull
    public static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromPluginsCompatibleBuild();
            if (PluginManagerCore.getLogger().isDebugEnabled()) {
                PluginManagerCore.getLogger().debug("getBuildNumber: fromPluginsCompatibleBuild=" + (result2 != null ? result2.asString() : "null"));
            }
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull Collection<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Map<PluginId, PluginLoadingError> errors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        LinkedHashSet<IdeaPluginDescriptorImpl> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set = new HashSet();
            for (String it : selectedIds.split(",")) {
                set.add(PluginId.getId(it));
            }
            set.addAll(ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set.size());
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                PluginId pluginId = (PluginId)iterator2.next();
                IdeaPluginDescriptorImpl descriptor2 = idMap.get(pluginId);
                if (descriptor2 == null) continue;
                explicitlyEnabled.add(descriptor2);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : descriptors) {
                if (!selectedCategory.equals(ideaPluginDescriptorImpl.getCategory())) continue;
                explicitlyEnabled.add(ideaPluginDescriptorImpl);
            }
        }
        if (explicitlyEnabled != null) {
            ArrayList nonOptionalDependencies = new ArrayList();
            for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : explicitlyEnabled) {
                PluginManagerCore.processAllNonOptionalDependencies(ideaPluginDescriptorImpl, idMap, dependency -> {
                    nonOptionalDependencies.add(dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
            explicitlyEnabled.addAll(nonOptionalDependencies);
        }
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        boolean bl = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor5 : descriptors) {
            if (descriptor5 == coreDescriptor) continue;
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor5)) continue;
                descriptor5.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin '" + descriptor5.getName() + "' " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (bl) continue;
            descriptor5.setEnabled(false);
            errors.put(descriptor5.getPluginId(), new PluginLoadingError(descriptor5, PluginManagerCore.message("plugin.loading.error.long.plugin.loading.disabled", descriptor5.getName()), PluginManagerCore.message("plugin.loading.error.short.plugin.loading.disabled", new Object[0])));
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        return PluginManagerCore.isCompatible(descriptor2, null);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        return !PluginManagerCore.isIncompatible(descriptor2, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        return PluginManagerCore.isIncompatible(descriptor2, null);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor2, buildNumber != null ? buildNumber : PluginManagerCore.getBuildNumber()) != null;
    }

    @NotNull
    public static Optional<IdeaPluginPlatform> getIncompatiblePlatform(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        Optional<IdeaPluginPlatform> optional = descriptor2.getDependencies().stream().map(d -> IdeaPluginPlatform.fromModuleId(d.getPluginId())).filter(p -> p != null && !p.isHostPlatform()).findFirst();
        if (optional == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        return optional;
    }

    @Nullable
    public static PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor2, @NotNull BuildNumber ideBuildNumber) {
        Optional<IdeaPluginPlatform> incompatiblePlatform;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (ideBuildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if ((incompatiblePlatform = PluginManagerCore.getIncompatiblePlatform(descriptor2)).isPresent()) {
            IdeaPluginPlatform requiredPlatform = incompatiblePlatform.get();
            return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.with.platform", new Object[]{descriptor2.getName(), descriptor2.getVersion(), requiredPlatform, SystemInfo.getOsName()}), PluginManagerCore.message("plugin.loading.error.short.incompatible.with.platform", new Object[]{requiredPlatform}));
        }
        if (IGNORE_COMPATIBILITY) {
            return null;
        }
        try {
            String pluginName;
            BuildNumber untilBuildNumber;
            String pluginName2;
            BuildNumber sinceBuildNumber;
            String sinceBuild = descriptor2.getSinceBuild();
            if (sinceBuild != null && (sinceBuildNumber = BuildNumber.fromString(sinceBuild, pluginName2 = descriptor2.getName(), null)) != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.since.build", pluginName2, descriptor2.getVersion(), sinceBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.since.build", sinceBuild));
            }
            String untilBuild = descriptor2.getUntilBuild();
            if (untilBuild != null && (untilBuildNumber = BuildNumber.fromString(untilBuild, pluginName = descriptor2.getName(), null)) != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.until.build", pluginName, descriptor2.getVersion(), untilBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.until.build", untilBuild));
            }
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", descriptor2.getName()), PluginManagerCore.message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
        return null;
    }

    @TestOnly
    public static boolean isIgnoreCompatibility() {
        return IGNORE_COMPATIBILITY;
    }

    @TestOnly
    public static void setIgnoreCompatibility(boolean ignoreCompatibility) {
        IGNORE_COMPATIBILITY = ignoreCompatibility;
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        List<PluginId> required = ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id : required) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(id);
            if (descriptor2 != null && descriptor2.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context2, @NotNull PluginLoadingResult loadingResult, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins, @Nullable Activity parentActivity) {
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (loadingResult == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        Map<PluginId, PluginLoadingError> pluginErrorsById = loadingResult.copyPluginErrors$intellij_platform_core_impl();
        List<Supplier<String>> globalErrors = context2.copyGlobalErrors$intellij_platform_core_impl();
        if (loadingResult.duplicateModuleMap != null) {
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : loadingResult.duplicateModuleMap.entrySet()) {
                globalErrors.add(() -> CoreBundle.message("plugin.loading.error.module.declared.by.multiple.plugins", entry.getKey(), ((List)entry.getValue()).stream().map(IdeaPluginDescriptorImpl::toString).collect(Collectors.joining("\n  "))));
            }
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult.getIdMap();
        if (checkEssentialPlugins && !idMap.containsKey(CORE_ID)) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        Activity activity = parentActivity == null ? null : parentActivity.startChild("3rd-party plugins consent");
        ArrayList<IdeaPluginDescriptorImpl> aliens = new ArrayList<IdeaPluginDescriptorImpl>();
        for (PluginId id : PluginManagerCore.get3rdPartyPluginIds()) {
            IdeaPluginDescriptorImpl pluginDescriptor = idMap.get(id);
            if (pluginDescriptor == null) continue;
            aliens.add(pluginDescriptor);
        }
        if (!aliens.isEmpty()) {
            PluginManagerCore.check3rdPartyPluginsPrivacyConsent(aliens);
        }
        if (activity != null) {
            activity.end();
        }
        PluginSetBuilder pluginSetBuilder = new PluginSetBuilder(loadingResult.enabledPluginsById.values());
        PluginManagerCore.disableIncompatiblePlugins(pluginSetBuilder.getUnsortedPlugins(), idMap, pluginErrorsById);
        pluginSetBuilder.checkPluginCycles(globalErrors);
        HashMap pluginsToDisable = new HashMap();
        HashMap pluginsToEnable = new HashMap();
        pluginSetBuilder.computeEnabledModuleMap(descriptor2 -> {
            boolean isLoadableOnDemand;
            Set<PluginId> disabledPlugins = context2.disabledPlugins;
            PluginLoadingError loadingError = pluginSetBuilder.initEnableState$intellij_platform_core_impl((IdeaPluginDescriptorImpl)descriptor2, idMap, disabledPlugins, pluginErrorsById);
            PluginId pluginId = descriptor2.getPluginId();
            boolean isLoadable = loadingError == null;
            boolean bl = isLoadableOnDemand = descriptor2.isOnDemand() && !context2.enabledOnDemandPlugins.contains(pluginId);
            if (!isLoadable) {
                pluginErrorsById.put(pluginId, loadingError);
                pluginsToDisable.put(pluginId, descriptor2.getName());
                PluginId disabledDependencyId = loadingError.disabledDependency;
                if (disabledDependencyId != null && (disabledPlugins.contains(disabledDependencyId) || isLoadableOnDemand)) {
                    pluginsToEnable.put(disabledDependencyId, ((IdeaPluginDescriptorImpl)idMap.get(disabledDependencyId)).getName());
                }
            }
            boolean shouldLoad = !context2.expiredPlugins.contains(pluginId) && !isLoadableOnDemand;
            descriptor2.setEnabled(descriptor2.isEnabled() && isLoadable && shouldLoad);
            return !descriptor2.isEnabled();
        });
        List<Supplier<? extends HtmlChunk>> actions = PluginManagerCore.prepareActions(pluginsToDisable.values(), pluginsToEnable.values());
        pluginLoadingErrors = pluginErrorsById;
        List<Supplier<HtmlChunk>> errorList = PluginManagerCore.preparePluginErrors(globalErrors);
        if (!errorList.isEmpty()) {
            List<Supplier<? extends HtmlChunk>> list = pluginErrors;
            synchronized (list) {
                pluginErrors.addAll(errorList);
                pluginErrors.addAll(actions);
            }
        }
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        PluginSet pluginSet = pluginSetBuilder.createPluginSet(loadingResult.getIncompleteIdMap().values());
        new ClassLoaderConfigurator(pluginSet, coreLoader).configure();
        return new PluginManagerState(pluginSet, pluginsToDisable.keySet(), pluginsToEnable.keySet());
    }

    private static void check3rdPartyPluginsPrivacyConsent(@NotNull List<IdeaPluginDescriptorImpl> aliens) {
        if (aliens == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (GraphicsEnvironment.isHeadless()) {
            if (QODANA_PLUGINS_THIRD_PARTY_ACCEPT) {
                thirdPartyPluginsNoteAccepted = Boolean.TRUE;
                return;
            }
            PluginManagerCore.getLogger().info("3rd-party plugin privacy note not accepted yet; disabling plugins for this headless session");
            aliens.forEach(descriptor2 -> descriptor2.setEnabled(false));
        } else if (!PluginManagerCore.ask3rdPartyPluginsPrivacyConsent(aliens)) {
            PluginManagerCore.getLogger().info("3rd-party plugin privacy note declined; disabling plugins");
            aliens.forEach(descriptor2 -> descriptor2.setEnabled(false));
            PluginEnabler.HEADLESS.disable(aliens);
            thirdPartyPluginsNoteAccepted = Boolean.FALSE;
        } else {
            thirdPartyPluginsNoteAccepted = Boolean.TRUE;
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static Boolean isThirdPartyPluginsNoteAccepted() {
        Boolean result2 = thirdPartyPluginsNoteAccepted;
        thirdPartyPluginsNoteAccepted = null;
        return result2;
    }

    @ApiStatus.Internal
    static synchronized void write3rdPartyPlugins(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        Path path = PathManager.getConfigDir().resolve(THIRD_PARTY_PLUGINS_FILE);
        try {
            PluginManagerCore.writePluginIdsToFile(path, descriptors.stream().map(PluginDescriptor::getPluginId), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error(path.toString(), e);
        }
    }

    @NotNull
    private static Set<PluginId> get3rdPartyPluginIds() {
        Set<PluginId> set;
        Path path = PathManager.getConfigDir().resolve(THIRD_PARTY_PLUGINS_FILE);
        try {
            Set<PluginId> ids = PluginManagerCore.readPluginIdsFromFile(path);
            if (!ids.isEmpty()) {
                Files.delete(path);
            }
            set = ids;
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error(path.toString(), e);
            Set<PluginId> set2 = Collections.emptySet();
            if (set2 == null) {
                PluginManagerCore.$$$reportNull$$$0(53);
            }
            return set2;
        }
        if (set == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        return set;
    }

    /*
     * Loose catch block
     */
    @ApiStatus.Internal
    @NotNull
    public static synchronized Set<PluginId> readPluginIdsFromFile(@NotNull Path path) throws IOException {
        Set<PluginId> set;
        Stream<String> lines;
        block11: {
            if (path == null) {
                PluginManagerCore.$$$reportNull$$$0(54);
            }
            lines = Files.lines(path);
            set = lines.map(String::trim).filter(line -> !line.isEmpty()).map(PluginId::getId).collect(Collectors.toSet());
            if (lines == null) break block11;
            lines.close();
        }
        Set<PluginId> set2 = set;
        if (set2 == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        return set2;
        {
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException ignored) {
                    Set<PluginId> set3 = Collections.emptySet();
                    if (set3 == null) {
                        PluginManagerCore.$$$reportNull$$$0(56);
                    }
                    return set3;
                }
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static synchronized Set<PluginId> tryReadPluginIdsFromFile(@NotNull Path path, @NotNull Logger logger) {
        if (path == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        try {
            return PluginManagerCore.readPluginIdsFromFile(path);
        }
        catch (IOException e) {
            logger.warn("Unable to read plugin id list from: " + path, e);
            Set<PluginId> set = Collections.emptySet();
            if (set == null) {
                PluginManagerCore.$$$reportNull$$$0(59);
            }
            return set;
        }
    }

    @ApiStatus.Internal
    public static synchronized void writePluginIdsToFile(@NotNull Path path, @NotNull Set<PluginId> pluginIds, OpenOption ... openOptions) throws IOException {
        if (path == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        if (pluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        PluginManagerCore.writePluginIdsToFile(path, pluginIds.stream(), openOptions);
    }

    @ApiStatus.Internal
    public static synchronized boolean tryWritePluginIdsToFile(@NotNull Path path, @NotNull Set<PluginId> pluginIds, @NotNull Logger logger, OpenOption ... openOptions) {
        if (path == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (pluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        try {
            PluginManagerCore.writePluginIdsToFile(path, pluginIds, openOptions);
            return true;
        }
        catch (IOException e) {
            logger.warn("Unable to write plugin id list to: " + path, e);
            return false;
        }
    }

    @ApiStatus.Internal
    public static synchronized void writePluginIdsToFile(@NotNull Path path, @NotNull Stream<PluginId> pluginIds, OpenOption ... openOptions) throws IOException {
        if (path == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (pluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        PluginManagerCore.writePluginIdsToFile(path, pluginIds.map(PluginId::getIdString).collect(Collectors.toList()), openOptions);
    }

    @VisibleForTesting
    public static synchronized void writePluginIdsToFile(@NotNull Path path, @NotNull Collection<String> pluginIds, OpenOption ... openOptions) throws IOException {
        if (path == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (pluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        NioFiles.createDirectories(path.getParent());
        Files.write(path, new TreeSet<String>(pluginIds), openOptions);
    }

    @VisibleForTesting
    @NotNull
    public static Set<PluginId> toPluginIds(@NotNull Collection<String> pluginIdStrings) {
        if (pluginIdStrings == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        Set pluginIds = pluginIdStrings.stream().map(String::trim).filter(s -> !s.isEmpty()).map(PluginId::getId).collect(Collectors.toSet());
        Set<PluginId> set = Collections.unmodifiableSet(pluginIds);
        if (set == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        return set;
    }

    private static boolean ask3rdPartyPluginsPrivacyConsent(@NotNull List<IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        String title = CoreBundle.message("third.party.plugins.privacy.note.title", new Object[0]);
        String pluginList = descriptors.stream().map(descriptor2 -> "&nbsp;&nbsp;&nbsp;" + PluginManagerCore.getPluginNameAndVendor(descriptor2)).collect(Collectors.joining("<br>"));
        String text2 = CoreBundle.message("third.party.plugins.privacy.note.text", pluginList);
        Object[] buttons = new String[]{CoreBundle.message("third.party.plugins.privacy.note.accept", new Object[0]), CoreBundle.message("third.party.plugins.privacy.note.disable", new Object[0])};
        int choice = JOptionPane.showOptionDialog(null, text2, title, 2, 2, IconManager.getInstance().getPlatformIcon(PlatformIcons.WarningDialog), buttons, buttons[0]);
        return choice == 0;
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (duplicateMap != null && (duplicates = duplicateMap.get(id)) != null) {
            duplicates.add(descriptor2);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id, descriptor2);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>();
        list.add(existingDescriptor);
        list.add(descriptor2);
        duplicateMap.put(id, list);
        return duplicateMap;
    }

    @NotNull
    @Nls
    public static String getPluginNameAndVendor(@NotNull IdeaPluginDescriptor descriptor2) {
        String vendor;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        String string2 = (vendor = descriptor2.getVendor()) != null ? CoreBundle.message("plugin.name.and.vendor", descriptor2.getName(), vendor) : CoreBundle.message("plugin.name.and.unknown.vendor", descriptor2.getName());
        if (string2 == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        return string2;
    }

    @NotNull
    @Nls
    private static Supplier<String> message(final @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") String key, final Object ... params) {
        if (key == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (params == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        return new Supplier<String>(){

            @Override
            public String get() {
                return CoreBundle.message(key, params);
            }
        };
    }

    @NotNull
    static synchronized PluginSet initializeAndSetPlugins(@NotNull DescriptorListLoadingContext context2, @NotNull PluginLoadingResult loadingResult, @NotNull ClassLoader coreLoader) {
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        if (loadingResult == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        Activity activity = StartUpMeasurer.startActivity("plugin initialization");
        PluginManagerState initResult = PluginManagerCore.initializePlugins(context2, loadingResult, coreLoader, !isUnitTestMode, activity);
        ourPluginsToDisable = Java11Shim.INSTANCE.copyOf(initResult.pluginIdsToDisable);
        ourPluginsToEnable = Java11Shim.INSTANCE.copyOf(initResult.pluginIdsToEnable);
        shadowedBundledPlugins = Java11Shim.INSTANCE.copyOf(loadingResult.shadowedBundledIds);
        activity.end();
        activity.setDescription("plugin count: " + initResult.pluginSet.enabledPlugins.size());
        pluginSet = initResult.pluginSet;
        PluginSet pluginSet = initResult.pluginSet;
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        return pluginSet;
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        return logger;
    }

    @Contract(value="null -> null")
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        return id != null ? PluginManagerCore.findPlugin(id) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPlugin(@NotNull PluginId id) {
        PluginSet pluginSet;
        IdeaPluginDescriptorImpl result2;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        if ((result2 = (pluginSet = PluginManagerCore.getPluginSet()).findEnabledPlugin(id)) != null) {
            return result2;
        }
        return pluginSet.findInstalledPlugin(id);
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPluginByModuleDependency(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : PluginManagerCore.getPluginSet().allPlugins) {
            if (!descriptor2.modules.contains(id)) continue;
            return descriptor2;
        }
        return null;
    }

    public static boolean isPluginInstalled(@NotNull PluginId id) {
        PluginSet pluginSet;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null) {
            return false;
        }
        return pluginSet.isPluginEnabled(id) || pluginSet.isPluginInstalled(id);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        HashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>(PluginManagerCore.getPluginSet().allPlugins.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor2 : PluginManagerCore.getPluginSet().allPlugins) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, descriptor2.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module : descriptor2.modules) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, module, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        HashMap<PluginId, IdeaPluginDescriptorImpl> hashMap = idMap;
        if (hashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        return hashMap;
    }

    @ApiStatus.Internal
    public static void processAllNonOptionalDependencyIds(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Function<? super PluginId, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, new HashSet(), pluginIdMap, (? super PluginId pluginId, ? super IdeaPluginDescriptorImpl __) -> (FileVisitResult)((Object)((Object)consumer.apply((PluginId)pluginId))));
    }

    @ApiStatus.Internal
    public static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Function<? super IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        return PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, new HashSet(), pluginIdMap, consumer);
    }

    @ApiStatus.Internal
    public static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Set<? super IdeaPluginDescriptorImpl> depProcessed, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Function<? super IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        return PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, depProcessed, pluginIdMap, (? super PluginId __, ? super IdeaPluginDescriptorImpl descriptor2) -> (FileVisitResult)((Object)((Object)consumer.apply((IdeaPluginDescriptorImpl)descriptor2))));
    }

    private static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Set<? super IdeaPluginDescriptorImpl> depProcessed, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull BiFunction<? super PluginId, ? super IdeaPluginDescriptorImpl, ? extends FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        for (PluginId dependencyId : PluginManagerCore.getNonOptionalDependenciesIds(rootDescriptor)) {
            IdeaPluginDescriptorImpl descriptor2 = pluginIdMap.get(dependencyId);
            PluginId pluginId = descriptor2 != null ? descriptor2.getPluginId() : dependencyId;
            FileVisitResult result2 = consumer.apply(pluginId, descriptor2);
            switch (result2) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (descriptor2 == null || !depProcessed.add(descriptor2)) break;
                    PluginManagerCore.processAllNonOptionalDependencies(descriptor2, depProcessed, pluginIdMap, consumer);
                    break;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public static Set<PluginId> getNonOptionalDependenciesIds(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        LinkedHashSet<PluginId> dependencies = new LinkedHashSet<PluginId>();
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            if (dependency.isOptional()) continue;
            dependencies.add(dependency.getPluginId());
        }
        for (ModuleDependenciesDescriptor.PluginReference plugin : descriptor2.dependencies.plugins) {
            dependencies.add(plugin.id);
        }
        Set<PluginId> set = Collections.unmodifiableSet(dependencies);
        if (set == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        return set;
    }

    @ApiStatus.Internal
    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        return shadowedBundledPlugins != null && shadowedBundledPlugins.contains(plugin.getPluginId());
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId(id));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId(id));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void addDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        DisabledPluginsState.addDisablePluginListener(listener);
    }

    static {
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        pluginErrors = new ArrayList<Supplier<? extends HtmlChunk>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 7: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 72: 
            case 75: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: 
            case 13: 
            case 73: 
            case 84: 
            case 85: 
            case 86: 
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendorItem";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrorsSuppliers";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNamesToDisable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNamesToEnable";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 35: 
            case 51: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 36: 
            case 46: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideBuildNumber";
                break;
            }
            case 47: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingResult";
                break;
            }
            case 49: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliens";
                break;
            }
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 61: 
            case 63: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdStrings";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 88: 
            case 91: 
            case 94: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 89: 
            case 92: 
            case 96: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 90: 
            case 93: 
            case 97: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearPluginLoadingErrors";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readBrokenPluginFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePluginErrors";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareActions";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitPluginFuture";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncompatiblePlatform";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "get3rdPartyPluginIds";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "readPluginIdsFromFile";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tryReadPluginIdsFromFile";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "toPluginIds";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginNameAndVendor";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeAndSetPlugins";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalDependenciesIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPluginSet";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 12: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 13: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPlatformClass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findClassInPluginThatUsesCoreClassloader";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorIfIdeaClassLoaderIsUsed";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isVendorJetBrains";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "preparePluginErrors";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "prepareActions";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "scheduleDescriptorLoading";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatiblePlatform";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkBuildNumberCompatibility";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "check3rdPartyPluginsPrivacyConsent";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "write3rdPartyPlugins";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "readPluginIdsFromFile";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "tryReadPluginIdsFromFile";
                break;
            }
            case 60: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "writePluginIdsToFile";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "tryWritePluginIdsToFile";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "toPluginIds";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "ask3rdPartyPluginsPrivacyConsent";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getPluginNameAndVendor";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "initializeAndSetPlugins";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isPluginInstalled";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "processAllNonOptionalDependencyIds";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "processAllNonOptionalDependencies";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getNonOptionalDependenciesIds";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + String.join((CharSequence)", ", ids));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

