/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class PluginManager {
    public static final String INSTALLED_TXT = "installed.txt";
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    @NotNull
    public static PluginManager getInstance() {
        PluginManager pluginManager = ApplicationManager.getApplication().getService(PluginManager.class);
        if (pluginManager == null) {
            PluginManager.$$$reportNull$$$0(0);
        }
        return pluginManager;
    }

    private PluginManager() {
    }

    @Nullable
    public static Path getOnceInstalledIfExists() {
        Path onceInstalledFile = PathManager.getConfigDir().resolve(INSTALLED_TXT);
        return Files.isRegularFile(onceInstalledFile, new LinkOption[0]) ? onceInstalledFile : null;
    }

    @Deprecated
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        return PluginManagerCore.getPlugin(id);
    }

    public static IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        if (ideaPluginDescriptorArray == null) {
            PluginManager.$$$reportNull$$$0(1);
        }
        return ideaPluginDescriptorArray;
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManagerCore.isPluginInstalled(id);
    }

    @Nullable
    public static PluginDescriptor getPluginByClass(@NotNull Class<?> aClass) {
        ClassLoader loader;
        if (aClass == null) {
            PluginManager.$$$reportNull$$$0(2);
        }
        return (loader = aClass.getClassLoader()) instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)((Object)loader)).getPluginDescriptor() : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            PluginManager.$$$reportNull$$$0(3);
        }
        return PluginManager.getPluginByClassNameAsNoAccessToClass(className);
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginId getPluginByClassNameAsNoAccessToClass(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManager.$$$reportNull$$$0(4);
        }
        PluginId id = (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
        return id == null || PluginManagerCore.CORE_ID.equals(id) ? null : id;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        List<? extends IdeaPluginDescriptor> list = PluginManagerCore.getLoadedPlugins();
        if (list == null) {
            PluginManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static List<String> getDisabledPlugins() {
        final Set<PluginId> list = DisabledPluginsState.getDisabledIds();
        return new AbstractList<String>(){

            @Override
            public boolean contains(Object o) {
                return list.contains(o);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public String get(int index2) {
                if (index2 < 0 || index2 >= list.size()) {
                    throw new IndexOutOfBoundsException("index=" + index2 + " size=" + list.size());
                }
                Iterator iterator2 = list.iterator();
                for (int i2 = 0; i2 < index2; ++i2) {
                    iterator2.next();
                }
                return ((PluginId)iterator2.next()).getIdString();
            }
        };
    }

    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(6);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId(id));
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(7);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId(id));
    }

    public boolean enablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(8);
        }
        return PluginManagerCore.enablePlugin(id);
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static Logger getLogger() {
        Logger logger = PluginManagerCore.getLogger();
        if (logger == null) {
            PluginManager.$$$reportNull$$$0(9);
        }
        return logger;
    }

    @Nullable
    public IdeaPluginDescriptor findEnabledPlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(10);
        }
        return PluginManagerCore.getPluginSet().findEnabledPlugin(id);
    }

    @NotNull
    public Disposable createDisposable(@NotNull Class<?> requestor) {
        ClassLoader classLoader;
        if (requestor == null) {
            PluginManager.$$$reportNull$$$0(11);
        }
        if (!((classLoader = requestor.getClassLoader()) instanceof PluginAwareClassLoader)) {
            Disposable disposable = Disposer.newDisposable();
            if (disposable == null) {
                PluginManager.$$$reportNull$$$0(12);
            }
            return disposable;
        }
        final int classLoaderId = ((PluginAwareClassLoader)((Object)classLoader)).getInstanceId();
        return new PluginAwareDisposable(){

            @Override
            public int getClassLoaderId() {
                return classLoaderId;
            }

            @Override
            public void dispose() {
            }
        };
    }

    @NotNull
    public Disposable createDisposable(@NotNull Class<?> requestor, @NotNull ComponentManager parentDisposable) {
        if (requestor == null) {
            PluginManager.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            PluginManager.$$$reportNull$$$0(14);
        }
        Disposable disposable = this.createDisposable(requestor);
        Disposer.register(parentDisposable, disposable);
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            PluginManager.$$$reportNull$$$0(15);
        }
        return disposable2;
    }

    @ApiStatus.Internal
    @Nullable
    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build) {
        if (build == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build);
        return matcher.matches() ? matcher.group(1) + ".*" : build;
    }

    @ApiStatus.Internal
    @NotNull
    public static Stream<IdeaPluginDescriptorImpl> getVisiblePlugins(boolean showImplementationDetails) {
        return PluginManager.filterVisiblePlugins(PluginManagerCore.getPluginSet().allPlugins, showImplementationDetails);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends PluginDescriptor> @NotNull Stream<@NotNull T> filterVisiblePlugins(@NotNull @NotNull Collection<@NotNull T> plugins, boolean showImplementationDetails) {
        if (plugins == null) {
            PluginManager.$$$reportNull$$$0(16);
        }
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        Stream<PluginDescriptor> stream = plugins.stream().filter(descriptor2 -> !applicationInfo.isEssentialPlugin(descriptor2.getPluginId())).filter(descriptor2 -> showImplementationDetails || !descriptor2.isImplementationDetail());
        if (stream == null) {
            PluginManager.$$$reportNull$$$0(17);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisposable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterVisiblePlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassNameAsNoAccessToClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findEnabledPlugin";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDisposable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterVisiblePlugins";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static interface PluginAwareDisposable
    extends Disposable {
        public int getClassLoaderId();
    }
}

