/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/plugins/EnabledOnDemandPluginsState;", "Lcom/intellij/ide/plugins/PluginEnabler;", "()V", "disable", "", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enable", "isDisabled", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Experimental
public final class EnabledOnDemandPluginsState
implements PluginEnabler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ENABLED_PLUGINS_FILENAME = "enabled_on_demand_plugins.txt";
    @Nullable
    private static Set<PluginId> enabledPluginIds_;

    public EnabledOnDemandPluginsState() {
        if (IdeaPluginDescriptorImpl.Companion.isOnDemandEnabled()) {
            EnabledOnDemandPluginsState.Companion.getLOG().info(IdeaPluginDescriptorImplKt.joinedPluginIds((Iterable<PluginId>)Companion.getEnabledPluginIds(), "load"));
        }
    }

    @Override
    public boolean isDisabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return !Companion.isEnabled(pluginId);
    }

    @Override
    public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return Companion.setEnabledState(descriptors, true);
    }

    @Override
    public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return Companion.setEnabledState(descriptors, false);
    }

    @JvmStatic
    @NotNull
    public static final EnabledOnDemandPluginsState getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final Set<PluginId> getEnabledPluginIds() {
        return Companion.getEnabledPluginIds();
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull PluginId pluginId) {
        return Companion.isEnabled(pluginId);
    }

    @JvmStatic
    public static final boolean setEnabledState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, boolean enabled) {
        return Companion.setEnabledState(descriptors, enabled);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J\u001e\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u001aH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/plugins/EnabledOnDemandPluginsState$Companion;", "", "()V", "ENABLED_PLUGINS_FILENAME", "", "Lorg/jetbrains/annotations/NonNls;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "defaultFilePath", "Ljava/nio/file/Path;", "getDefaultFilePath", "()Ljava/nio/file/Path;", "enabledPluginIds", "", "Lcom/intellij/openapi/extensions/PluginId;", "getEnabledPluginIds$annotations", "getEnabledPluginIds", "()Ljava/util/Set;", "enabledPluginIds_", "", "getInstance", "Lcom/intellij/ide/plugins/EnabledOnDemandPluginsState;", "isEnabled", "", "pluginId", "setEnabledState", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enabled", "intellij.platform.core.impl"})
    @SourceDebugExtension(value={"SMAP\nEnabledOnDemandPluginsState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnabledOnDemandPluginsState.kt\ncom/intellij/ide/plugins/EnabledOnDemandPluginsState$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n10#2:82\n29#3,3:83\n766#4:86\n857#4,2:87\n*S KotlinDebug\n*F\n+ 1 EnabledOnDemandPluginsState.kt\ncom/intellij/ide/plugins/EnabledOnDemandPluginsState$Companion\n*L\n25#1:82\n28#1:83,3\n59#1:86\n59#1:87,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDefaultFilePath() {
            Path path = PathManager.getConfigDir().resolve(EnabledOnDemandPluginsState.ENABLED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir().resolve(ENABLED_PLUGINS_FILENAME)");
            return path;
        }

        private final Logger getLOG() {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(EnabledOnDemandPluginsState.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            return logger;
        }

        @JvmStatic
        @NotNull
        public final EnabledOnDemandPluginsState getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
            ComponentManager $this$service$iv = application;
            boolean $i$f$service = false;
            Class<EnabledOnDemandPluginsState> serviceClass$iv = EnabledOnDemandPluginsState.class;
            EnabledOnDemandPluginsState enabledOnDemandPluginsState = $this$service$iv.getService(serviceClass$iv);
            if (enabledOnDemandPluginsState == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return enabledOnDemandPluginsState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<PluginId> getEnabledPluginIds() {
            Set set = enabledPluginIds_;
            if (set != null) {
                Set it = set;
                boolean bl = false;
                return it;
            }
            Class<EnabledOnDemandPluginsState> clazz = EnabledOnDemandPluginsState.class;
            synchronized (clazz) {
                boolean bl = false;
                Set result2 = enabledPluginIds_;
                if (result2 == null) {
                    result2 = IdeaPluginDescriptorImpl.Companion.isOnDemandEnabled() ? (Set)new LinkedHashSet(PluginManagerCore.tryReadPluginIdsFromFile(Companion.getDefaultFilePath(), Companion.getLOG())) : (Set)new LinkedHashSet();
                    enabledPluginIds_ = result2;
                }
                Set set2 = result2;
                return set2;
            }
        }

        @JvmStatic
        public static /* synthetic */ void getEnabledPluginIds$annotations() {
        }

        @JvmStatic
        public final boolean isEnabled(@NotNull PluginId pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            return this.getEnabledPluginIds().contains(pluginId);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean setEnabledState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, boolean enabled) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            if (!IdeaPluginDescriptorImpl.Companion.isOnDemandEnabled()) {
                return false;
            }
            Iterable $this$filter$iv = descriptors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
                boolean bl = false;
                if (!it.isOnDemand()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set<PluginId> pluginIds = IdeaPluginDescriptorImplKt.toPluginIdSet((List)destination$iv$iv);
            this.getLOG().info(IdeaPluginDescriptorImplKt.joinedPluginIds((Iterable<PluginId>)pluginIds, "load on demand"));
            Set<PluginId> set = this.getEnabledPluginIds();
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<com.intellij.openapi.extensions.PluginId>");
            Set enabledPluginIds = TypeIntrinsics.asMutableSet(set);
            return (enabled ? enabledPluginIds.addAll((Collection)pluginIds) : enabledPluginIds.removeAll((Collection)pluginIds)) && PluginManagerCore.tryWritePluginIdsToFile(this.getDefaultFilePath(), pluginIds, this.getLOG(), new OpenOption[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

