/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateKeyStore;
import com.intellij.execution.rmi.ssl.SslUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SslKeyStore
extends DelegateKeyStore {
    public static final String SSL_DEFERRED_KEY_LOADING = "sslDeferredKeyLoading";
    public static final String NAME = "idea-key-store";
    private static final Map<PrivateKey, X509Certificate> ourAutoAdded = new LinkedHashMap<PrivateKey, X509Certificate>();

    public SslKeyStore() {
        super("PKCS12");
        SslKeyStore.loadUserCert();
    }

    public static void setDefault() {
        System.setProperty("javax.net.ssl.keyStoreType", NAME);
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            System.setProperty("javax.net.ssl.keyStore", SslKeyStore.getDefaultKeyStorePath());
        }
    }

    private static void loadUserCert() {
        String certPath = System.getProperty("sslClientCertPath");
        String keyPath = System.getProperty("sslClientKeyPath");
        if (certPath != null && keyPath != null) {
            try {
                SslKeyStore.loadKey(certPath, keyPath, null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static void loadKey(@NotNull String clientCertPath, @NotNull String clientKeyPath, @Nullable char[] password) throws CertificateException, IOException {
        PrivateKey key;
        if (clientCertPath == null) {
            SslKeyStore.$$$reportNull$$$0(0);
        }
        if (clientKeyPath == null) {
            SslKeyStore.$$$reportNull$$$0(1);
        }
        if (ourAutoAdded.containsKey(key = SslUtil.readPrivateKey(clientKeyPath, password))) {
            return;
        }
        X509Certificate cert = SslUtil.readCertificate(clientCertPath);
        ourAutoAdded.put(key, cert);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.delegate.load(null, null);
        int i2 = 0;
        for (Map.Entry<PrivateKey, X509Certificate> entry : ourAutoAdded.entrySet()) {
            try {
                this.delegate.setKeyEntry("user-provided-key" + (i2 == 0 ? "" : "#" + i2), entry.getKey(), null, new Certificate[]{entry.getValue()});
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException();
            }
            ++i2;
        }
    }

    static {
        ourProvider.setProperty("KeyStore.idea-key-store", SslKeyStore.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "clientCertPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "clientKeyPath";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/rmi/ssl/SslKeyStore";
        objectArray[2] = "loadKey";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

