/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.CoreVirtualFilePointerManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiReferenceServiceImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Consumer;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.Processor;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.impl.GraphAlgorithmsImpl;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class CoreApplicationEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    protected final MockApplication myApplication;
    private final CoreLocalFileSystem myLocalFileSystem;
    @NotNull
    protected final VirtualFileSystem myJarFileSystem;
    private final VirtualFileSystem myJrtFileSystem;
    @NotNull
    private final Disposable myParentDisposable;
    private final boolean myUnitTestMode;

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(0);
        }
        this(parentDisposable, true);
    }

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable, boolean unitTestMode) {
        if (parentDisposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(1);
        }
        this.myParentDisposable = parentDisposable;
        this.myUnitTestMode = unitTestMode;
        PluginEnabler.HEADLESS.setIgnoredDisabledPlugins(true);
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myApplication = this.createApplication(this.myParentDisposable);
        ApplicationManager.setApplication(this.myApplication, () -> this.myFileTypeRegistry, this.myParentDisposable);
        this.myLocalFileSystem = this.createLocalFileSystem();
        this.myJarFileSystem = this.createJarFileSystem();
        this.myJrtFileSystem = this.createJrtFileSystem();
        this.registerApplicationService(FileDocumentManager.class, new MockFileDocumentManagerImpl(null, DocumentImpl::new));
        CoreApplicationEnvironment.registerApplicationExtensionPoint(new ExtensionPointName("com.intellij.virtualFileManagerListener"), VirtualFileManagerListener.class);
        List<VirtualFileSystem> fs = this.myJrtFileSystem != null ? Arrays.asList(this.myLocalFileSystem, this.myJarFileSystem, this.myJrtFileSystem) : Arrays.asList(this.myLocalFileSystem, this.myJarFileSystem);
        this.registerApplicationService(VirtualFileManager.class, new VirtualFileManagerImpl(fs));
        CoreApplicationEnvironment.registerApplicationExtensionPoint(new ExtensionPointName("com.intellij.virtualFileSystem"), KeyedLazyInstanceEP.class);
        this.registerApplicationService(EncodingManager.class, new CoreEncodingRegistry());
        this.registerApplicationService(VirtualFilePointerManager.class, this.createVirtualFilePointerManager());
        this.registerApplicationService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.registerApplicationService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.registerApplicationService(PsiReferenceService.class, new PsiReferenceServiceImpl());
        this.registerApplicationService(ProgressManager.class, this.createProgressIndicatorProvider());
        this.registerApplicationService(JobLauncher.class, this.createJobLauncher());
        this.registerApplicationService(CodeFoldingSettings.class, new CodeFoldingSettings());
        this.registerApplicationService(CommandProcessor.class, new CoreCommandProcessor());
        this.registerApplicationService(GraphAlgorithms.class, new GraphAlgorithmsImpl());
        this.myApplication.registerService(ApplicationInfo.class, ApplicationInfoImpl.class);
        CoreApplicationEnvironment.registerApplicationExtensionPoint(DynamicBundle.LanguageBundleEP.EP_NAME, DynamicBundle.LanguageBundleEP.class);
    }

    public <T> void registerApplicationService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(2);
        }
        if (serviceImplementation == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(3);
        }
        this.myApplication.registerService(serviceInterface, serviceImplementation);
    }

    @NotNull
    protected VirtualFilePointerManager createVirtualFilePointerManager() {
        return new CoreVirtualFilePointerManager();
    }

    @NotNull
    protected MockApplication createApplication(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(4);
        }
        return new MockApplication(parentDisposable){

            @Override
            public boolean isUnitTestMode() {
                return CoreApplicationEnvironment.this.myUnitTestMode;
            }
        };
    }

    @NotNull
    protected JobLauncher createJobLauncher() {
        return new JobLauncher(){

            @Override
            public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) {
                if (things == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (thingProcessor == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (T thing : things) {
                    if (thingProcessor.process(thing)) continue;
                    return false;
                }
                return true;
            }

            @Override
            @NotNull
            public Job<Void> submitToJobThread(@NotNull Runnable action2, Consumer<? super Future<?>> onDoneCallback) {
                if (action2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                action2.run();
                if (onDoneCallback != null) {
                    onDoneCallback.consume(CompletableFuture.completedFuture(null));
                }
                Job<Void> job = Job.nullJob();
                if (job == null) {
                    2.$$$reportNull$$$0(3);
                }
                return job;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "things";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "thingProcessor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/core/CoreApplicationEnvironment$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/core/CoreApplicationEnvironment$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "submitToJobThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "invokeConcurrentlyUnderProgress";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "submitToJobThread";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    protected ProgressManager createProgressIndicatorProvider() {
        return new CoreProgressManager();
    }

    @NotNull
    protected VirtualFileSystem createJarFileSystem() {
        return new CoreJarFileSystem();
    }

    @NotNull
    protected CoreLocalFileSystem createLocalFileSystem() {
        return new CoreLocalFileSystem();
    }

    @Nullable
    protected VirtualFileSystem createJrtFileSystem() {
        return null;
    }

    @NotNull
    public MockApplication getApplication() {
        MockApplication mockApplication = this.myApplication;
        if (mockApplication == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(5);
        }
        return mockApplication;
    }

    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.myParentDisposable;
        if (disposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(6);
        }
        return disposable;
    }

    public <T> void registerApplicationComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        if (interfaceClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(7);
        }
        if (implementation == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(8);
        }
        CoreApplicationEnvironment.registerComponentInstance(this.myApplication.getPicoContainer(), interfaceClass, implementation);
        if (implementation instanceof Disposable) {
            Disposer.register(this.myApplication, (Disposable)implementation);
        }
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull @NonNls String extension) {
        if (fileType == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(9);
        }
        if (extension == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(10);
        }
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(@NotNull ParserDefinition definition) {
        if (definition == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(11);
        }
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), definition);
    }

    public static <T> void registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        if (container == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(12);
        }
        if (key == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(13);
        }
        if (implementation == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(14);
        }
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    public <T> void addExplicitExtension(@NotNull LanguageExtension<T> instance, @NotNull Language language, @NotNull T object) {
        if (instance == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(15);
        }
        if (language == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(16);
        }
        if (object == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(17);
        }
        instance.addExplicitExtension(language, object, this.myParentDisposable);
    }

    public void registerParserDefinition(@NotNull Language language, @NotNull ParserDefinition parserDefinition) {
        if (language == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(18);
        }
        if (parserDefinition == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(19);
        }
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, language, parserDefinition);
    }

    public <T> void addExplicitExtension(@NotNull FileTypeExtension<T> instance, @NotNull FileType fileType, @NotNull T object) {
        if (instance == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(20);
        }
        if (fileType == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(21);
        }
        if (object == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(22);
        }
        instance.addExplicitExtension(fileType, object, this.myParentDisposable);
    }

    public <T> void addExplicitExtension(@NotNull ClassExtension<T> instance, @NotNull Class aClass, @NotNull T object) {
        if (instance == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(23);
        }
        if (aClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(24);
        }
        if (object == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(25);
        }
        instance.addExplicitExtension(aClass, object, this.myParentDisposable);
    }

    public <T> void addExtension(@NotNull ExtensionPointName<T> name2, @NotNull T extension) {
        if (name2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(26);
        }
        if (extension == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(27);
        }
        ExtensionPoint<T> extensionPoint = Extensions.getRootArea().getExtensionPoint(name2);
        extensionPoint.registerExtension(extension, this.myParentDisposable);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(28);
        }
        if (extensionPointName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(29);
        }
        if (aClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(30);
        }
        CoreApplicationEnvironment.registerExtensionPoint(area, extensionPointName.getName(), aClass);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull String name2, @NotNull Class<? extends T> aClass) {
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(31);
        }
        if (name2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(32);
        }
        if (aClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(33);
        }
        CoreApplicationEnvironment.registerExtensionPoint(area, name2, aClass, false);
    }

    private static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull String name2, @NotNull Class<? extends T> aClass, boolean isDynamic) {
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(34);
        }
        if (name2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(35);
        }
        if (aClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(36);
        }
        if (!area.hasExtensionPoint(name2)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers()) ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name2, aClass.getName(), kind, isDynamic);
        }
    }

    public static <T> void registerApplicationExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (extensionPointName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(37);
        }
        if (aClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(38);
        }
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), extensionPointName.getName(), aClass);
    }

    public static <T> void registerApplicationDynamicExtensionPoint(@NotNull String extensionPointName, @NotNull Class<? extends T> aClass) {
        if (extensionPointName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(39);
        }
        if (aClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(40);
        }
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass, true);
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(41);
        }
        if (fileName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(42);
        }
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(43);
        }
        if ((descriptor2 = PluginDescriptorLoader.loadForCoreEnv(pluginRoot, fileName)) == null) {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
            return;
        }
        List<ExtensionPointDescriptor> extensionPoints = descriptor2.appContainerDescriptor.extensionPoints;
        ExtensionsAreaImpl areaImpl = (ExtensionsAreaImpl)area;
        if (extensionPoints != null) {
            areaImpl.registerExtensionPoints(extensionPoints, descriptor2);
        }
        descriptor2.registerExtensions(areaImpl.extensionPoints, descriptor2.appContainerDescriptor, null);
    }

    @NotNull
    public CoreLocalFileSystem getLocalFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myLocalFileSystem;
        if (coreLocalFileSystem == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(44);
        }
        return coreLocalFileSystem;
    }

    @NotNull
    public VirtualFileSystem getJarFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myJarFileSystem;
        if (virtualFileSystem == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(45);
        }
        return virtualFileSystem;
    }

    @Nullable
    public VirtualFileSystem getJrtFileSystem() {
        return this.myJrtFileSystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 44: 
            case 45: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 5: 
            case 6: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/core/CoreApplicationEnvironment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 24: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 26: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: 
            case 31: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 29: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/core/CoreApplicationEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplication";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDisposable";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileSystem";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createApplication";
                break;
            }
            case 5: 
            case 6: 
            case 44: 
            case 45: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationComponent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 11: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerParserDefinition";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addExtension";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationExtensionPoint";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationDynamicExtensionPoint";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

