/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.dom;

import com.fasterxml.aalto.dom.DOMOutputElement;
import com.fasterxml.aalto.out.WriterConfig;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.stax2.ri.EmptyNamespaceContext;
import org.codehaus.stax2.ri.dom.DOMWrappingWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMWriterImpl
extends DOMWrappingWriter {
    protected final WriterConfig _config;
    protected DOMOutputElement _currElem;
    protected DOMOutputElement _openElement;
    protected int[] _autoNsSeq;
    protected String _suggestedDefNs = null;
    protected String _automaticNsPrefix;
    HashMap<String, String> _suggestedPrefixes = null;

    private DOMWriterImpl(WriterConfig cfg, Node treeRoot) throws XMLStreamException {
        super(treeRoot, true, cfg.willRepairNamespaces());
        this._config = cfg;
        this._autoNsSeq = null;
        this._automaticNsPrefix = cfg.getAutomaticNsPrefix();
        switch (treeRoot.getNodeType()) {
            case 9: 
            case 11: {
                this._currElem = DOMOutputElement.createRoot();
                this._openElement = null;
                break;
            }
            case 1: {
                DOMOutputElement root = DOMOutputElement.createRoot();
                Element elem = (Element)treeRoot;
                this._openElement = this._currElem = root.createChild(elem);
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + treeRoot.getClass());
            }
        }
    }

    public static DOMWriterImpl createFrom(WriterConfig cfg, DOMResult dst) throws XMLStreamException {
        Node rootNode = dst.getNode();
        return new DOMWriterImpl(cfg, rootNode);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (!this.mNsAware) {
            return EmptyNamespaceContext.getInstance();
        }
        return this._currElem;
    }

    @Override
    public String getPrefix(String uri) {
        String prefix;
        if (!this.mNsAware) {
            return null;
        }
        if (this.mNsContext != null && (prefix = this.mNsContext.getPrefix(uri)) != null) {
            return prefix;
        }
        return this._currElem.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name2) {
        return this._config.getProperty(name2, false);
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this._suggestedDefNs = uri == null || uri.length() == 0 ? null : uri;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (prefix.length() == 0) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (prefix.equals("xml")) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                DOMWriterImpl.throwOutputError("Trying to redeclare prefix 'xml' from its default URI 'http://www.w3.org/XML/1998/namespace' to \"" + uri + "\"");
            }
        } else {
            if (prefix.equals("xmlns")) {
                if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                    DOMWriterImpl.throwOutputError("Trying to declare prefix 'xmlns' (illegal as per NS 1.1 #4)");
                }
                return;
            }
            if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                DOMWriterImpl.throwOutputError("Trying to bind URI 'http://www.w3.org/XML/1998/namespace to prefix \"" + prefix + "\" (can only bind to 'xml')");
            } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
                DOMWriterImpl.throwOutputError("Trying to bind URI 'http://www.w3.org/2000/xmlns/ to prefix \"" + prefix + "\" (can not be explicitly bound)");
            }
        }
        if (this._suggestedPrefixes == null) {
            this._suggestedPrefixes = new HashMap(16);
        }
        this._suggestedPrefixes.put(uri, prefix);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.outputAttribute(null, null, localName, value);
    }

    @Override
    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        this.outputAttribute(nsURI, null, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        this.outputAttribute(nsURI, prefix, localName, value);
    }

    @Override
    public void writeDefaultNamespace(String nsURI) {
        if (this._openElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        this.setDefaultNamespace(nsURI);
        this._openElement.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName);
    }

    @Override
    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.createStartElem(nsURI, null, localName, true);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        if (prefix == null) {
            prefix = "";
        }
        this.createStartElem(nsURI, prefix, localName, true);
    }

    @Override
    public void writeEndDocument() {
        this._openElement = null;
        this._currElem = null;
    }

    @Override
    public void writeEndElement() {
        if (this._currElem == null || this._currElem.isRoot()) {
            throw new IllegalStateException("No open start element to close");
        }
        this._openElement = null;
        this._currElem = this._currElem.getParent();
    }

    @Override
    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        if (prefix == null || prefix.length() == 0) {
            this.writeDefaultNamespace(nsURI);
            return;
        }
        if (!this.mNsAware) {
            DOMWriterImpl.throwOutputError("Can not write namespaces with non-namespace writer.");
        }
        this.outputAttribute("http://www.w3.org/2000/xmlns/", "xmlns", prefix, nsURI);
        this._currElem.addPrefix(prefix, nsURI);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, localName);
    }

    @Override
    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.createStartElem(nsURI, null, localName, false);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.createStartElem(nsURI, prefix, localName, false);
    }

    @Override
    public boolean isPropertySupported(String name2) {
        return this._config.isPropertySupported(name2);
    }

    @Override
    public boolean setProperty(String name2, Object value) {
        return this._config.setProperty(name2, value);
    }

    @Override
    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws XMLStreamException {
        if (this._currElem != null) {
            throw new IllegalStateException("Operation only allowed to the document before adding root element");
        }
        this.reportUnsupported("writeDTD()");
    }

    @Override
    protected void appendLeaf(Node n) throws IllegalStateException {
        this._currElem.appendNode(n);
        this._openElement = null;
    }

    protected void createStartElem(String nsURI, String prefix, String localName, boolean isEmpty) throws XMLStreamException {
        DOMOutputElement elem;
        if (!this.mNsAware) {
            if (nsURI != null && nsURI.length() > 0) {
                DOMWriterImpl.throwOutputError("Can not specify non-empty uri/prefix in non-namespace mode");
            }
            elem = this._currElem.createAndAttachChild(this.mDocument.createElement(localName));
        } else if (this.mNsRepairing) {
            String actPrefix = this.validateElemPrefix(prefix, nsURI, this._currElem);
            if (actPrefix != null) {
                elem = actPrefix.length() != 0 ? this._currElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, actPrefix + ":" + localName)) : this._currElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, localName));
            } else {
                boolean hasPrefix;
                if (prefix == null) {
                    prefix = "";
                }
                boolean bl = hasPrefix = (actPrefix = this.generateElemPrefix(prefix, nsURI, this._currElem)).length() != 0;
                if (hasPrefix) {
                    localName = actPrefix + ":" + localName;
                }
                this._openElement = elem = this._currElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, localName));
                if (hasPrefix) {
                    this.writeNamespace(actPrefix, nsURI);
                    elem.addPrefix(actPrefix, nsURI);
                } else {
                    this.writeDefaultNamespace(nsURI);
                    elem.setDefaultNsUri(nsURI);
                }
            }
        } else {
            if (prefix == null && nsURI != null && nsURI.length() > 0) {
                String string2 = prefix = this._suggestedPrefixes == null ? null : this._suggestedPrefixes.get(nsURI);
                if (prefix == null) {
                    DOMWriterImpl.throwOutputError("Can not find prefix for namespace \"" + nsURI + "\"");
                }
            }
            if (prefix != null && prefix.length() != 0) {
                localName = prefix + ":" + localName;
            }
            elem = this._currElem.createAndAttachChild(this.mDocument.createElementNS(nsURI, localName));
        }
        this._openElement = elem;
        if (!isEmpty) {
            this._currElem = elem;
        }
    }

    protected void outputAttribute(String nsURI, String prefix, String localName, String value) throws XMLStreamException {
        if (this._openElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                prefix = this.findOrCreateAttrPrefix(prefix, nsURI, this._openElement);
            }
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            this._openElement.addAttribute(nsURI, localName, value);
        } else {
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            this._openElement.addAttribute(localName, value);
        }
    }

    private final String validateElemPrefix(String prefix, String nsURI, DOMOutputElement elem) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            String currURL = elem.getDefaultNsUri();
            if (currURL == null || currURL.length() == 0) {
                return "";
            }
            return null;
        }
        int status = elem.isPrefixValid(prefix, nsURI, true);
        if (status == 1) {
            return prefix;
        }
        return null;
    }

    protected final String findElemPrefix(String nsURI, DOMOutputElement elem) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            String currDefNsURI = elem.getDefaultNsUri();
            if (currDefNsURI != null && currDefNsURI.length() > 0) {
                return null;
            }
            return "";
        }
        return this._currElem.getPrefix(nsURI);
    }

    protected final String generateElemPrefix(String suggPrefix, String nsURI, DOMOutputElement elem) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            return "";
        }
        if (suggPrefix == null) {
            if (this._suggestedDefNs != null && this._suggestedDefNs.equals(nsURI)) {
                suggPrefix = "";
            } else {
                String string2 = suggPrefix = this._suggestedPrefixes == null ? null : this._suggestedPrefixes.get(nsURI);
                if (suggPrefix == null) {
                    if (this._autoNsSeq == null) {
                        this._autoNsSeq = new int[1];
                        this._autoNsSeq[0] = 1;
                    }
                    suggPrefix = elem.generateMapping(this._automaticNsPrefix, nsURI, this._autoNsSeq);
                }
            }
        }
        return suggPrefix;
    }

    protected final String findOrCreateAttrPrefix(String suggPrefix, String nsURI, DOMOutputElement elem) throws XMLStreamException {
        String prefix;
        if (nsURI == null || nsURI.length() == 0) {
            return null;
        }
        if (suggPrefix != null) {
            int status = elem.isPrefixValid(suggPrefix, nsURI, false);
            if (status == 1) {
                return suggPrefix;
            }
            if (status == 0) {
                elem.addPrefix(suggPrefix, nsURI);
                this.writeNamespace(suggPrefix, nsURI);
                return suggPrefix;
            }
        }
        if ((prefix = elem.getExplicitPrefix(nsURI)) != null) {
            return prefix;
        }
        if (suggPrefix != null) {
            prefix = suggPrefix;
        } else if (this._suggestedPrefixes != null) {
            prefix = this._suggestedPrefixes.get(nsURI);
        }
        if (prefix != null && (prefix.length() == 0 || elem.getNamespaceURI(prefix) != null)) {
            prefix = null;
        }
        if (prefix == null) {
            if (this._autoNsSeq == null) {
                this._autoNsSeq = new int[1];
                this._autoNsSeq[0] = 1;
            }
            prefix = this._currElem.generateMapping(this._automaticNsPrefix, nsURI, this._autoNsSeq);
        }
        elem.addPrefix(prefix, nsURI);
        this.writeNamespace(prefix, nsURI);
        return prefix;
    }
}

