/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.util;

import com.esotericsoftware.kryo.kryo5.util.ObjectIntMap;

public class IdentityObjectIntMap<K>
extends ObjectIntMap<K> {
    public IdentityObjectIntMap() {
    }

    public IdentityObjectIntMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentityObjectIntMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentityObjectIntMap(IdentityObjectIntMap<K> map2) {
        super(map2);
    }

    @Override
    protected int place(K item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    public int get(K key, int defaultValue) {
        int i2 = this.place(key);
        Object other;
        while ((other = this.keyTable[i2]) != null) {
            if (other == key) {
                return this.valueTable[i2];
            }
            i2 = i2 + 1 & this.mask;
        }
        return defaultValue;
    }

    @Override
    int locateKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object[] keyTable = this.keyTable;
        int i2 = this.place(key);
        Object other;
        while ((other = keyTable[i2]) != null) {
            if (other == key) {
                return i2;
            }
            i2 = i2 + 1 & this.mask;
        }
        return -(i2 + 1);
    }

    @Override
    public int hashCode() {
        int h = this.size;
        Object[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Object key = keyTable[i2];
            if (key == null) continue;
            h += System.identityHashCode(key) + valueTable[i2];
        }
        return h;
    }
}

