/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.util;

import com.esotericsoftware.kryo.kryo5.KryoException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class GenericsUtil {
    public static Type resolveType(Class fromClass, Class toClass, Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return GenericsUtil.resolveTypeVariable(fromClass, toClass, type, true);
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            int dimensions = 1;
            while ((type = ((GenericArrayType)type).getGenericComponentType()) instanceof GenericArrayType) {
                ++dimensions;
            }
            Type componentType = GenericsUtil.resolveType(fromClass, toClass, type);
            if (!(componentType instanceof Class)) {
                return type;
            }
            if (dimensions == 1) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
            return Array.newInstance((Class)componentType, new int[dimensions]).getClass();
        }
        if (type instanceof WildcardType) {
            Type upperBound = ((WildcardType)type).getUpperBounds()[0];
            if (upperBound != Object.class) {
                return GenericsUtil.resolveType(fromClass, toClass, upperBound);
            }
            Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
            if (lowerBounds.length != 0) {
                return GenericsUtil.resolveType(fromClass, toClass, lowerBounds[0]);
            }
            return Object.class;
        }
        throw new KryoException("Unable to resolve type: " + type);
    }

    private static Type resolveTypeVariable(Class fromClass, Class current2, Type type, boolean first2) {
        Type genericSuper = current2.getGenericSuperclass();
        if (!(genericSuper instanceof ParameterizedType)) {
            return type;
        }
        Class superClass = current2.getSuperclass();
        if (superClass != fromClass) {
            Type resolved = GenericsUtil.resolveTypeVariable(fromClass, superClass, type, false);
            if (resolved instanceof Class) {
                return resolved;
            }
            type = resolved;
        }
        String name2 = type.toString();
        TypeVariable<Class<T>>[] params = superClass.getTypeParameters();
        int n = params.length;
        for (int i2 = 0; i2 < n; ++i2) {
            TypeVariable param = params[i2];
            if (!param.getName().equals(name2)) continue;
            Type arg2 = ((ParameterizedType)genericSuper).getActualTypeArguments()[i2];
            if (arg2 instanceof Class) {
                return arg2;
            }
            if (arg2 instanceof ParameterizedType) {
                return GenericsUtil.resolveType(fromClass, current2, arg2);
            }
            if (arg2 instanceof GenericArrayType) {
                return GenericsUtil.resolveType(fromClass, current2, arg2);
            }
            if (!(arg2 instanceof TypeVariable)) continue;
            if (first2) {
                return type;
            }
            return arg2;
        }
        return type;
    }

    public static Type[] resolveTypeParameters(Class fromClass, Class toClass, Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualArgs = ((ParameterizedType)type).getActualTypeArguments();
            int n = actualArgs.length;
            Type[] generics = new Type[n];
            for (int i2 = 0; i2 < n; ++i2) {
                generics[i2] = GenericsUtil.resolveType(fromClass, toClass, actualArgs[i2]);
            }
            return generics;
        }
        if (type instanceof GenericArrayType) {
            while ((type = ((GenericArrayType)type).getGenericComponentType()) instanceof GenericArrayType) {
            }
            return GenericsUtil.resolveTypeParameters(fromClass, toClass, type);
        }
        return null;
    }
}

