/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.MapSerializer;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ImmutableCollectionsSerializers {
    public static void addDefaultSerializers(Kryo kryo) {
        if (Util.isClassAvailable("java.util.ImmutableCollections")) {
            JdkImmutableListSerializer.addDefaultSerializers(kryo);
            JdkImmutableMapSerializer.addDefaultSerializers(kryo);
            JdkImmutableSetSerializer.addDefaultSerializers(kryo);
        }
    }

    public static void registerSerializers(Kryo kryo) {
        JdkImmutableListSerializer.registerSerializers(kryo);
        JdkImmutableMapSerializer.registerSerializers(kryo);
        JdkImmutableSetSerializer.registerSerializers(kryo);
    }

    static class JdkImmutableSetSerializer
    extends CollectionSerializer<Set<Object>> {
        private JdkImmutableSetSerializer() {
            this.setElementsCanBeNull(false);
        }

        @Override
        protected Set<Object> create(Kryo kryo, Input input, Class<? extends Set<Object>> type, int size) {
            return new HashSet<Object>();
        }

        @Override
        protected Set<Object> createCopy(Kryo kryo, Set<Object> original) {
            return new HashSet<Object>();
        }

        @Override
        public Set<Object> read(Kryo kryo, Input input, Class<? extends Set<Object>> type) {
            Set set = (Set)super.read(kryo, input, type);
            if (set == null) {
                return null;
            }
            return Set.of(set.toArray());
        }

        @Override
        public Set<Object> copy(Kryo kryo, Set<Object> original) {
            Set<Object> copy2 = super.copy(kryo, original);
            return Set.copyOf(copy2);
        }

        static void addDefaultSerializers(Kryo kryo) {
            JdkImmutableSetSerializer serializer = new JdkImmutableSetSerializer();
            kryo.addDefaultSerializer(Set.of().getClass(), serializer);
            kryo.addDefaultSerializer(Set.of(Integer.valueOf(1)).getClass(), serializer);
            kryo.addDefaultSerializer(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).getClass(), serializer);
        }

        static void registerSerializers(Kryo kryo) {
            JdkImmutableSetSerializer serializer = new JdkImmutableSetSerializer();
            kryo.register(Set.of().getClass(), serializer);
            kryo.register(Set.of(Integer.valueOf(1)).getClass(), serializer);
            kryo.register(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).getClass(), serializer);
        }
    }

    static class JdkImmutableMapSerializer
    extends MapSerializer<Map<Object, Object>> {
        private JdkImmutableMapSerializer() {
            this.setKeysCanBeNull(false);
            this.setValuesCanBeNull(false);
        }

        @Override
        protected Map<Object, Object> create(Kryo kryo, Input input, Class<? extends Map<Object, Object>> type, int size) {
            return new HashMap<Object, Object>();
        }

        @Override
        protected Map<Object, Object> createCopy(Kryo kryo, Map<Object, Object> original) {
            return new HashMap<Object, Object>();
        }

        @Override
        public Map<Object, Object> read(Kryo kryo, Input input, Class<? extends Map<Object, Object>> type) {
            Object map2 = super.read(kryo, input, type);
            if (map2 == null) {
                return null;
            }
            return Map.copyOf(map2);
        }

        @Override
        public Map<Object, Object> copy(Kryo kryo, Map<Object, Object> original) {
            Map<Object, Object> copy2 = super.copy(kryo, original);
            return Map.copyOf(copy2);
        }

        static void addDefaultSerializers(Kryo kryo) {
            JdkImmutableMapSerializer serializer = new JdkImmutableMapSerializer();
            kryo.addDefaultSerializer(Map.of().getClass(), serializer);
            kryo.addDefaultSerializer(Map.of(1, 2).getClass(), serializer);
            kryo.addDefaultSerializer(Map.of(1, 2, 3, 4).getClass(), serializer);
        }

        static void registerSerializers(Kryo kryo) {
            JdkImmutableMapSerializer serializer = new JdkImmutableMapSerializer();
            kryo.register(Map.of().getClass(), serializer);
            kryo.register(Map.of(1, 2).getClass(), serializer);
            kryo.register(Map.of(1, 2, 3, 4).getClass(), serializer);
        }
    }

    static class JdkImmutableListSerializer
    extends CollectionSerializer<List<Object>> {
        private JdkImmutableListSerializer() {
            this.setElementsCanBeNull(false);
        }

        @Override
        protected List<Object> create(Kryo kryo, Input input, Class<? extends List<Object>> type, int size) {
            return new ArrayList<Object>(size);
        }

        @Override
        protected List<Object> createCopy(Kryo kryo, List<Object> original) {
            return new ArrayList<Object>(original.size());
        }

        @Override
        public List<Object> read(Kryo kryo, Input input, Class<? extends List<Object>> type) {
            List list = (List)super.read(kryo, input, type);
            if (list == null) {
                return null;
            }
            return List.of(list.toArray());
        }

        @Override
        public List<Object> copy(Kryo kryo, List<Object> original) {
            List<Object> copy2 = super.copy(kryo, original);
            return List.copyOf(copy2);
        }

        static void addDefaultSerializers(Kryo kryo) {
            JdkImmutableListSerializer serializer = new JdkImmutableListSerializer();
            kryo.addDefaultSerializer(List.of().getClass(), serializer);
            kryo.addDefaultSerializer(List.of(Integer.valueOf(1)).getClass(), serializer);
            kryo.addDefaultSerializer(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).getClass(), serializer);
            kryo.addDefaultSerializer(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).subList(0, 2).getClass(), serializer);
        }

        static void registerSerializers(Kryo kryo) {
            JdkImmutableListSerializer serializer = new JdkImmutableListSerializer();
            kryo.register(List.of().getClass(), serializer);
            kryo.register(List.of(Integer.valueOf(1)).getClass(), serializer);
            kryo.register(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).getClass(), serializer);
            kryo.register(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).subList(0, 2).getClass(), serializer);
        }
    }
}

