/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public class ClosureSerializer
extends Serializer {
    private static Method readResolve;

    public ClosureSerializer() {
        if (readResolve == null) {
            try {
                readResolve = SerializedLambda.class.getDeclaredMethod("readResolve", new Class[0]);
                readResolve.setAccessible(true);
            }
            catch (Exception ex) {
                readResolve = null;
                Log.warn("Unable to obtain SerializedLambda#readResolve via reflection. Falling back on resolving lambdas via capturing class.", ex);
            }
        }
    }

    public void write(Kryo kryo, Output output, Object object) {
        SerializedLambda serializedLambda = this.toSerializedLambda(object);
        int count2 = serializedLambda.getCapturedArgCount();
        output.writeVarInt(count2, true);
        for (int i2 = 0; i2 < count2; ++i2) {
            kryo.writeClassAndObject(output, serializedLambda.getCapturedArg(i2));
        }
        try {
            kryo.writeClass(output, Class.forName(serializedLambda.getCapturingClass().replace('/', '.')));
        }
        catch (ClassNotFoundException ex) {
            throw new KryoException("Error writing closure.", ex);
        }
        output.writeString(serializedLambda.getFunctionalInterfaceClass());
        output.writeString(serializedLambda.getFunctionalInterfaceMethodName());
        output.writeString(serializedLambda.getFunctionalInterfaceMethodSignature());
        output.writeVarInt(serializedLambda.getImplMethodKind(), true);
        output.writeString(serializedLambda.getImplClass());
        output.writeString(serializedLambda.getImplMethodName());
        output.writeString(serializedLambda.getImplMethodSignature());
        output.writeString(serializedLambda.getInstantiatedMethodType());
    }

    public Object read(Kryo kryo, Input input, Class type) {
        int count2 = input.readVarInt(true);
        Object[] capturedArgs = new Object[count2];
        for (int i2 = 0; i2 < count2; ++i2) {
            capturedArgs[i2] = kryo.readClassAndObject(input);
        }
        Class capturingClass = kryo.readClass(input).getType();
        SerializedLambda serializedLambda = new SerializedLambda(capturingClass, input.readString(), input.readString(), input.readString(), input.readVarInt(true), input.readString(), input.readString(), input.readString(), input.readString(), capturedArgs);
        try {
            return this.readResolve(capturingClass, serializedLambda);
        }
        catch (Exception ex) {
            throw new KryoException("Error reading closure.", ex);
        }
    }

    public Object copy(Kryo kryo, Object original) {
        try {
            SerializedLambda lambda = this.toSerializedLambda(original);
            Class<?> capturingClass = Class.forName(lambda.getCapturingClass().replace('/', '.'));
            return this.readResolve(capturingClass, lambda);
        }
        catch (Exception ex) {
            throw new KryoException("Error copying closure.", ex);
        }
    }

    private Object readResolve(Class<?> capturingClass, SerializedLambda lambda) throws Exception {
        if (readResolve != null) {
            return readResolve.invoke((Object)lambda, new Object[0]);
        }
        Method m = capturingClass.getDeclaredMethod("$deserializeLambda$", SerializedLambda.class);
        m.setAccessible(true);
        return m.invoke(null, lambda);
    }

    private SerializedLambda toSerializedLambda(Object object) {
        Object replacement;
        try {
            Method writeReplace = object.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            replacement = writeReplace.invoke(object, new Object[0]);
        }
        catch (Exception ex) {
            if (object instanceof Serializable) {
                throw new KryoException("Error serializing closure.", ex);
            }
            throw new KryoException("Closure must implement java.io.Serializable.", ex);
        }
        try {
            return (SerializedLambda)replacement;
        }
        catch (Exception ex) {
            throw new KryoException("writeReplace must return a SerializedLambda: " + Util.className(replacement.getClass()), ex);
        }
    }

    public static class Closure {
    }
}

