/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastErrorType;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J6\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060#H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010*\u001a\u00020$H\u0002J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020$H\u0002J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010-\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u0018H\u0016R.\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b0\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "mFormatStrings", "", "", "", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "mIgnoreStrings", "", "mNotFormatStrings", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkStringFormatCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "call", "Lorg/jetbrains/uast/UCallExpression;", "specifiesLocale", "checkTextNode", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "text", "checkTrivialString", "args", "", "Lorg/jetbrains/uast/UExpression;", "getApplicableElements", "", "getApplicableMethodNames", "getStringType", "Lcom/intellij/psi/PsiType;", "expression", "isInStringExpression", "visitElement", "visitMethodCall", "node", "method", "Companion", "lint-checks"})
public final class StringFormatDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    @NotNull
    private final Map<String, Location.Handle> mNotFormatStrings = new LinkedHashMap();
    @Nullable
    private Set<String> mIgnoreStrings;
    @NotNull
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    @NotNull
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA;
    @JvmField
    @NotNull
    public static final Issue INVALID;
    @JvmField
    @NotNull
    public static final Issue ARG_COUNT;
    @NotNull
    private static final Issue TRIVIAL;
    @JvmField
    @NotNull
    public static final Issue ARG_TYPES;
    @JvmField
    @NotNull
    public static final Issue POTENTIAL_PLURAL;
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    @JvmField
    public static final Pattern FORMAT;
    @NotNull
    private static final Companion.TypeTest isCharacterType;
    @NotNull
    private static final Companion.TypeTest isBooleanType;
    @NotNull
    private static final Companion.TypeTest isIntType;
    @NotNull
    private static final Companion.TypeTest isFloatType;
    @NotNull
    private static final Companion.TypeTest isNumericType;
    @NotNull
    private static final Companion.TypeTest isNumericOrBigNumberType;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"string");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0) {
            if (childNodes.getLength() == 1) {
                Node child = childNodes.item(0);
                short type = child.getNodeType();
                if (type == 3 || type == 4) {
                    String string = child.getNodeValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"child.nodeValue");
                    this.checkTextNode(context, element, Companion.stripQuotes(string));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                Companion.addText(sb, element);
                if (((CharSequence)sb).length() > 0) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    this.checkTextNode(context, element, string);
                }
            }
        }
    }

    private final void checkTextNode(XmlContext context, Element element, String text) {
        String name = element.getAttribute("name");
        boolean found = false;
        boolean foundPlural = false;
        int m = text.length();
        for (int j = 0; j < m; ++j) {
            char c = text.charAt(j);
            if (c == '\\') {
                ++j;
            }
            if (c != '%') continue;
            String formatted = element.getAttribute("formatted");
            Intrinsics.checkNotNullExpressionValue((Object)formatted, (String)"formatted");
            if (!(((CharSequence)formatted).length() == 0) && !Boolean.parseBoolean(formatted)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle((Node)element);
                    handle.setClientData((Object)element);
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            Matcher matcher = FORMAT.matcher(text);
            if (!matcher.find(j)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle((Node)element);
                    handle.setClientData((Object)element);
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            String conversion = matcher.group(6);
            int conversionClass = StringFormatDetector.Companion.getConversionClass(conversion.charAt(0));
            if (conversionClass == 0 || matcher.group(5) != null) {
                if (this.mIgnoreStrings == null) {
                    this.mIgnoreStrings = new HashSet();
                }
                Set<String> set = this.mIgnoreStrings;
                Intrinsics.checkNotNull(set);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                set.add(name);
                return;
            }
            if (conversionClass == 3 && !foundPlural) {
                for (int k = matcher.end(); k < m; ++k) {
                    char nc = text.charAt(k);
                    if (Character.isWhitespace(nc)) continue;
                    if (!Character.isLetter(nc)) break;
                    foundPlural = StringFormatDetector.Companion.checkPotentialPlural(context, element, text, k);
                    break;
                }
            }
            found = true;
            ++j;
        }
        if (!context.getProject().getReportIssues()) {
            return;
        }
        if (name != null) {
            Location.Handle handle = context.createLocationHandle((Node)element);
            handle.setClientData((Object)element);
            if (found) {
                if (this.mFormatStrings == null) {
                    this.mFormatStrings = new LinkedHashMap();
                }
                Map<String, List<Pair<Location.Handle, String>>> map = this.mFormatStrings;
                Intrinsics.checkNotNull(map);
                List list = map.get(name);
                if (list == null) {
                    list = new ArrayList();
                    Map<String, List<Pair<Location.Handle, String>>> map2 = this.mFormatStrings;
                    Intrinsics.checkNotNull(map2);
                    map2.put(name, list);
                }
                list.add(TuplesKt.to((Object)handle, (Object)text));
            } else if (!StringFormatDetector.Companion.isReference(text)) {
                this.mNotFormatStrings.put(name, handle);
            }
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.mFormatStrings != null) {
            boolean checkCount = context.isEnabled(ARG_COUNT);
            boolean checkValid = context.isEnabled(INVALID);
            boolean checkTypes = context.isEnabled(ARG_TYPES);
            Map<String, List<Pair<Location.Handle, String>>> map = this.mFormatStrings;
            Intrinsics.checkNotNull(map);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : map.entrySet()) {
                String name = entry.getKey();
                List list = entry.getValue();
                if (checkCount) {
                    Location.Handle notFormatted = this.mNotFormatStrings.get(name);
                    if (notFormatted != null) {
                        ImmutableList immutableList = ImmutableList.builder().add((Object)TuplesKt.to((Object)notFormatted, (Object)name)).addAll((Iterable)list).build();
                        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder<Pair<Location.Ha\u2026\n                .build()");
                        list = (List)immutableList;
                    }
                    StringFormatDetector.Companion.checkArity(context, name, list);
                }
                if (!checkValid && !checkTypes) continue;
                StringFormatDetector.Companion.checkTypes(context, checkValid, checkTypes, name, list);
            }
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"format", "getString"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block7: {
            block8: {
                JavaEvaluator evaluator;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    evaluator = context.getEvaluator();
                    String string = method.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
                    String methodName = string;
                    if (!Intrinsics.areEqual((Object)methodName, (Object)"format")) break block6;
                    if (evaluator.isMemberInClass((PsiMember)method, "java.lang.String")) {
                        this.checkStringFormatCall(context, method, node, method.getParameterList().getParametersCount() == 3);
                    }
                    break block7;
                }
                if (method.getParameterList().getParametersCount() < 2) {
                    return;
                }
                if (evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.res.Resources", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.Context", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Fragment", false)) break block8;
                PsiMember psiMember = (PsiMember)method;
                String string = AndroidXConstants.CLASS_V4_FRAGMENT.oldName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLASS_V4_FRAGMENT.oldName()");
                if (evaluator.isMemberInSubClassOf(psiMember, string, false)) break block8;
                PsiMember psiMember2 = (PsiMember)method;
                String string2 = AndroidXConstants.CLASS_V4_FRAGMENT.newName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CLASS_V4_FRAGMENT.newName()");
                if (!evaluator.isMemberInSubClassOf(psiMember2, string2, false)) break block7;
            }
            this.checkStringFormatCall(context, method, node, false);
        }
    }

    private final void checkStringFormatCall(JavaContext context, PsiMethod calledMethod, UCallExpression call, boolean specifiesLocale) {
        block56: {
            List list;
            int argIndex = specifiesLocale ? 1 : 0;
            List args = call.getValueArguments();
            if (args.size() <= argIndex) {
                return;
            }
            UExpression argument = (UExpression)args.get(argIndex);
            ResourceUrl resource = ResourceEvaluator.getResource((JavaEvaluator)context.getEvaluator(), (UElement)((UElement)argument));
            if (resource == null || resource.isFramework() || resource.type != ResourceType.STRING) {
                this.checkTrivialString(context, calledMethod, call, args, specifiesLocale);
                return;
            }
            String name = resource.name;
            if (this.mIgnoreStrings != null) {
                Set<String> set = this.mIgnoreStrings;
                Intrinsics.checkNotNull(set);
                if (set.contains(name)) {
                    return;
                }
            }
            boolean passingVarArgsArray = false;
            int callCount = args.size() - 1 - argIndex;
            if (callCount == 1) {
                UExpression lastArg = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(args.size() - 1)));
                PsiParameterList psiParameterList = calledMethod.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"calledMethod.parameterList");
                PsiParameterList parameterList = psiParameterList;
                int parameterCount = parameterList.getParametersCount();
                if (parameterCount > 0 && parameterList.getParameters()[parameterCount - 1].isVarArgs()) {
                    PsiElement resolved;
                    boolean knownArity = false;
                    boolean argWasReference = false;
                    if (lastArg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lastArg).resolve()) instanceof PsiVariable) {
                        UExpression initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved);
                        if (initializer != null) {
                            initializer = UastUtils.skipParenthesizedExprDown((UExpression)initializer);
                        }
                        if (initializer != null && (UastExpressionUtils.isNewArray((UElement)((UElement)initializer)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)initializer)))) {
                            argWasReference = true;
                            lastArg = initializer;
                        }
                    }
                    if (lastArg != null && (UastExpressionUtils.isNewArray((UElement)((UElement)lastArg)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)lastArg)))) {
                        Object o;
                        UExpression first;
                        Object arrayDimensions;
                        UCallExpression arrayInitializer = (UCallExpression)lastArg;
                        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)((UElement)lastArg)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)lastArg))) {
                            callCount = arrayInitializer.getValueArgumentCount();
                            knownArity = true;
                        } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)((UElement)lastArg)) && (arrayDimensions = arrayInitializer.getValueArguments()).size() == 1 && (first = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arrayDimensions.get(0)))) instanceof ULiteralExpression && (o = ((ULiteralExpression)first).getValue()) instanceof Integer) {
                            callCount = ((Number)o).intValue();
                            knownArity = true;
                        }
                        if (!knownArity) {
                            if (!argWasReference) {
                                return;
                            }
                        } else {
                            passingVarArgsArray = true;
                        }
                    }
                }
            }
            if (callCount > 0 && this.mNotFormatStrings.containsKey(name)) {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                StringFormatDetector.Companion.checkNotFormattedHandle(context, call, name, this.mNotFormatStrings.get(name));
                return;
            }
            if (this.mFormatStrings != null) {
                Map<String, List<Pair<Location.Handle, String>>> map = this.mFormatStrings;
                Intrinsics.checkNotNull(map);
                v3 = map.get(name);
            } else {
                v3 = list = null;
            }
            if (list == null) {
                LintClient client = context.getClient();
                boolean full = context.isGlobalAnalysis();
                Project project = full ? context.getMainProject() : context.getProject();
                ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                List items = null;
                List list2 = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, name);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"resources.getResources(R\u2026esourceType.STRING, name)");
                items = list2;
                for (ResourceItem item : items) {
                    String value;
                    ResourceValue v;
                    if (item.getResourceValue() == null || v.getRawXmlValue() == null) continue;
                    if (StringFormatDetector.Companion.isReference(value)) {
                        List l;
                        ResourceUrl url;
                        for (int i = 0; i < 3 && (url = ResourceUrl.parse((String)value)) != null && !url.isFramework() && !(l = resources.getResources(ResourceNamespace.TODO(), url.type, url.name)).isEmpty() && (v = ((ResourceItem)l.get(0)).getResourceValue()) != null && (value = v.getValue()) != null && StringFormatDetector.Companion.isReference(value); ++i) {
                        }
                    }
                    if (value == null || StringFormatDetector.Companion.isReference(value)) continue;
                    boolean isFormattingString = StringsKt.indexOf$default((CharSequence)value, (char)'%', (int)0, (boolean)false, (int)6, null) != -1;
                    int m = value.length();
                    for (int j = 0; j < m && isFormattingString; ++j) {
                        char c = value.charAt(j);
                        if (c == '\\') {
                            ++j;
                            continue;
                        }
                        if (c != '%') continue;
                        Matcher matcher = FORMAT.matcher(value);
                        if (!matcher.find(j)) {
                            isFormattingString = false;
                        } else {
                            String conversion = matcher.group(6);
                            int conversionClass = StringFormatDetector.Companion.getConversionClass(conversion.charAt(0));
                            if (conversionClass == 0 || matcher.group(5) != null) {
                                return;
                            }
                        }
                        ++j;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                    Location.Handle handle2 = (Location.Handle)client.createResourceItemHandle(item, false, true);
                    if (isFormattingString) {
                        if (list == null) {
                            list = Lists.newArrayList();
                            if (this.mFormatStrings == null) {
                                this.mFormatStrings = new LinkedHashMap();
                            }
                            Map<String, List<Pair<Location.Handle, String>>> map = this.mFormatStrings;
                            Intrinsics.checkNotNull(map);
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            map.put(name, list);
                        }
                        List list3 = list;
                        Intrinsics.checkNotNull((Object)list3);
                        list3.add(TuplesKt.to((Object)handle2, (Object)value));
                        continue;
                    }
                    if (callCount <= 0) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    StringFormatDetector.Companion.checkNotFormattedHandle(context, call, name, handle2);
                }
            }
            if (list == null || list.isEmpty()) break block56;
            CollectionsKt.sortWith(list, (Comparator)checkStringFormatCall.1.INSTANCE);
            Set reported = null;
            block3: for (Pair<Location.Handle, String> pair : list) {
                String s = (String)pair.getSecond();
                if (reported != null && reported.contains(s)) continue;
                int count = Companion.getFormatArgumentCount(s, null);
                Location.Handle handle = (Location.Handle)pair.getFirst();
                if (count != callCount) {
                    String message2;
                    Location location = context.getLocation((UElement)call);
                    Location secondary = handle.resolve();
                    Locale isFormattingString = Locale.US;
                    Object j = "This definition requires %1$d argument%2$s";
                    Object m = new Object[]{count, count != 1 ? "s" : ""};
                    String string = String.format(isFormattingString, (String)j, Arrays.copyOf(m, ((Object[])m).length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, format, *args)");
                    secondary.setMessage(string);
                    location.setSecondary(secondary);
                    j = Locale.US;
                    m = "Wrong argument count, format string `%1$s` requires `%2$d` but format call supplies `%3$d`";
                    Object[] handle2 = new Object[]{name, count, callCount};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format((Locale)j, (String)m, Arrays.copyOf(handle2, handle2.length)), (String)"format(locale, format, *args)");
                    JavaContext.report$default((JavaContext)context, (Issue)ARG_TYPES, (UElement)((UElement)call), (Location)location, (String)message2, null, (int)16, null);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    Set set = reported;
                    Intrinsics.checkNotNull((Object)set);
                    set.add(s);
                    continue;
                }
                if (passingVarArgsArray) {
                    return;
                }
                int i = 1;
                if (i > count) continue;
                while (true) {
                    block57: {
                        char last;
                        String formatType;
                        boolean valid;
                        PsiType type;
                        int argumentIndex;
                        block59: {
                            char matcher;
                            block61: {
                                block60: {
                                    block58: {
                                        argumentIndex = i + argIndex;
                                        UExpression expression = (UExpression)args.get(argumentIndex);
                                        type = expression.getExpressionType();
                                        if (this.isInStringExpression(call, expression)) {
                                            type = this.getStringType(context, expression);
                                        }
                                        if (type == null || type instanceof UastErrorType) break block57;
                                        valid = true;
                                        if (Companion.getFormatArgumentType(s, i) == null) break block57;
                                        last = formatType.charAt(formatType.length() - 1);
                                        if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') break block57;
                                        matcher = last;
                                        if (!(matcher == 'b' ? true : matcher == 'B')) break block58;
                                        valid = isBooleanType.invoke(type);
                                        break block59;
                                    }
                                    if (!((((((((((matcher == 'x' ? true : matcher == 'X') ? true : matcher == 'd') ? true : matcher == 'o') ? true : matcher == 'e') ? true : matcher == 'E') ? true : matcher == 'f') ? true : matcher == 'g') ? true : matcher == 'G') ? true : matcher == 'a') ? true : matcher == 'A')) break block60;
                                    valid = isNumericOrBigNumberType.invoke(type);
                                    break block59;
                                }
                                if (!(matcher == 'c' ? true : matcher == 'C')) break block61;
                                valid = isCharacterType.invoke(type);
                                break block59;
                            }
                            if (matcher == 'h' ? true : matcher == 'H') break block57;
                            if (matcher == 's' ? true : matcher == 'S') {
                                boolean bl = valid = isBooleanType.invoke(type) == false && isNumericType.invoke(type) == false;
                            }
                        }
                        if (!valid) {
                            Location location = context.getLocation((UElement)args.get(argumentIndex));
                            Location secondary = handle.resolve();
                            secondary.setMessage("Conflicting argument declaration here");
                            location.setSecondary(secondary);
                            if (!StringFormatDetector.Companion.isSuppressed((Context)context, StringFormatDetector.ARG_TYPES, secondary)) {
                                String message3;
                                Object suggestion = null;
                                if (isBooleanType.invoke(type).booleanValue()) {
                                    suggestion = "`b`";
                                } else if (isCharacterType.invoke(type).booleanValue()) {
                                    suggestion = "'c'";
                                } else if (isIntType.invoke(type).booleanValue()) {
                                    suggestion = "`d`, 'o' or `x`";
                                } else if (isFloatType.invoke(type).booleanValue()) {
                                    suggestion = "`e`, 'f', 'g' or `a`";
                                } else if (type instanceof PsiClassType && Intrinsics.areEqual((Object)((PsiClassType)type).getCanonicalText(), (Object)"java.lang.Object")) {
                                    suggestion = "'s' or 'h'";
                                }
                                suggestion = suggestion != null ? " (Did you mean formatting character " + (String)suggestion + "?)" : "";
                                String string = type.getCanonicalText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.canonicalText");
                                String canonicalText = string;
                                String string2 = canonicalText.substring(StringsKt.lastIndexOf$default((CharSequence)canonicalText, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                                canonicalText = string2;
                                Locale locale = Locale.US;
                                String string3 = "Wrong argument type for formatting argument '#%1$d' in `%2$s`: conversion is '`%3$s`', received `%4$s` (argument #%5$d in method call)%6$s";
                                Object[] objectArray = new Object[]{i, name, formatType, canonicalText, argumentIndex + 1, suggestion};
                                Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(locale, format, *args)");
                                if ((last == 's' || last == 'S') && isNumericType.invoke(type).booleanValue()) {
                                    locale = Locale.US;
                                    string3 = "Suspicious argument type for formatting argument #%1$d in `%2$s`: conversion is `%3$s`, received `%4$s` (argument #%5$d in method call)%6$s";
                                    objectArray = new Object[]{i, name, formatType, canonicalText, argumentIndex + 1, suggestion};
                                    String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
                                    message3 = string4;
                                }
                                JavaContext.report$default((JavaContext)context, (Issue)ARG_TYPES, (UElement)((UElement)call), (Location)location, (String)message3, null, (int)16, null);
                                if (reported == null) {
                                    reported = Sets.newHashSet();
                                }
                                Set set = reported;
                                Intrinsics.checkNotNull((Object)set);
                                set.add(s);
                            }
                        }
                    }
                    if (i == count) continue block3;
                    ++i;
                }
            }
        }
    }

    private final boolean isInStringExpression(UCallExpression call, UExpression expression) {
        PsiElement psiElement = expression.getSourcePsi();
        if (psiElement == null) {
            return false;
        }
        PsiElement sourcePsi = psiElement;
        PsiElement psiElement2 = sourcePsi.getParent();
        KtStringTemplateEntry ktStringTemplateEntry = psiElement2 instanceof KtStringTemplateEntry ? (KtStringTemplateEntry)psiElement2 : null;
        if (ktStringTemplateEntry == null) {
            return false;
        }
        KtStringTemplateEntry parent = ktStringTemplateEntry;
        PsiElement stringElement = parent.getParent();
        PsiElement callPsi = call.getSourcePsi();
        if (callPsi instanceof KtCallExpression) {
            for (KtValueArgument argument : ((KtCallExpression)callPsi).getValueArguments()) {
                KtExpression valueExpression = argument.getArgumentExpression();
                if (valueExpression != stringElement) continue;
                return true;
            }
        }
        return false;
    }

    private final PsiType getStringType(JavaContext context, UExpression expression) {
        PsiElement psiElement = expression.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)element.getProject());
        PsiClass javaLangClass = facade.findClass("java.lang.String", element.getResolveScope());
        return javaLangClass != null ? (PsiType)context.getEvaluator().getClassType(javaLangClass) : null;
    }

    private final void checkTrivialString(JavaContext context, PsiMethod calledMethod, UCallExpression call, List<? extends UExpression> args, boolean specifiesLocale) {
        int stringIndex = specifiesLocale ? 1 : 0;
        String string = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)args.get(stringIndex)), (boolean)false);
        if (string == null) {
            return;
        }
        String s = string;
        boolean uppercase = false;
        int i = 1;
        int count = Companion.getFormatArgumentCount(s, null);
        if (i <= count) {
            while (true) {
                int argumentIndex;
                if ((argumentIndex = i + stringIndex) >= args.size()) {
                    return;
                }
                PsiType type = args.get(argumentIndex).getExpressionType();
                if (type != null) {
                    String formatType;
                    if (Companion.getFormatArgumentType(s, i) == null) {
                        return;
                    }
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') {
                        return;
                    }
                    char c = last;
                    if ((((((((((((c == 'x' ? true : c == 'X') ? true : c == 'd') ? true : c == 'o') ? true : c == 'e') ? true : c == 'E') ? true : c == 'f') ? true : c == 'g') ? true : c == 'G') ? true : c == 'a') ? true : c == 'A') ? true : c == 'h') ? true : c == 'H') {
                        return;
                    }
                    if ((c == 'b' ? true : c == 'B') && Lint.isKotlin((PsiElement)((PsiElement)calledMethod))) {
                        return;
                    }
                    if (Companion.hasFormatArgumentModifiers(s, i)) {
                        return;
                    }
                    if (Character.isUpperCase(last)) {
                        uppercase = true;
                    }
                }
                if (i == count) break;
                ++i;
            }
        }
        Object message2 = "This formatting string is trivial. Rather than using `String.format` to create your String, it will be more performant to concatenate your arguments with `+`. ";
        if (uppercase) {
            message2 = (String)message2 + "If uppercase formatting is necessary, use `String.toUpperCase()`.";
        }
        JavaContext.report$default((JavaContext)context, (Issue)TRIVIAL, (UElement)((UElement)call), (Location)context.getLocation((UElement)args.get(stringIndex)), (String)message2, null, (int)16, null);
    }

    @JvmStatic
    @NotNull
    public static final String stripQuotes(@NotNull String s) {
        return Companion.stripQuotes(s);
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final String getFormatArgumentType(@NotNull String s, int argument) {
        return Companion.getFormatArgumentType(s, argument);
    }

    @JvmStatic
    public static final int getFormatArgumentCount(@NotNull String s, @Nullable Set<Integer> seenArguments) {
        return Companion.getFormatArgumentCount(s, seenArguments);
    }

    @JvmStatic
    public static final boolean isLocaleSpecific(@NotNull String format) {
        return Companion.isLocaleSpecific(format);
    }

    static {
        Object[] objectArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION_XML_AND_JAVA = new Implementation(StringFormatDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.JAVA_FILE), (EnumSet[])objectArray);
        INVALID = Issue.Companion.create("StringFormatInvalid", "Invalid format string", "\n          If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\n          This lint warning checks for two related problems:\n          (1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n          (2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\n          NOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.\n          ", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML);
        ARG_COUNT = Issue.Companion.create("StringFormatCount", "Formatting argument types incomplete or inconsistent", "\n          When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\n          There are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.\n          ", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML);
        TRIVIAL = Issue.Companion.create("StringFormatTrivial", "`String.format` string only contains trivial conversions", "Every call to `String.format` creates a new `Formatter` instance, which will decrease the performance of your app. `String.format` should only be used when necessary--if the formatted string contains only trivial conversions (e.g. `b`, `s`, `c`) and there are no translation concerns, it will be more efficient to replace them and concatenate with `+`.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION_XML_AND_JAVA).setAndroidSpecific(true).setEnabledByDefault(false);
        ARG_TYPES = Issue.Companion.create("StringFormatMatches", "`String.format` string doesn't match the XML format string", "\n          This lint check ensures the following:\n          (1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n          (2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.\n          ", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML_AND_JAVA);
        POTENTIAL_PLURAL = Issue.Companion.create("PluralsCandidate", "Potential Plurals", "This lint check looks for potential errors in internationalization where you have translated a message which involves a quantity and it looks like other parts of the string may need grammatical changes.\n\nFor example, rather than something like this:\n```xml\n  <string name=\"try_again\">Try again in %d seconds.</string>\n```\nyou should be using a plural:\n```xml\n   <plurals name=\"try_again\">\n        <item quantity=\"one\">Try again in %d second</item>\n        <item quantity=\"other\">Try again in %d seconds</item>\n    </plurals>\n```\nThis will ensure that in other languages the right set of translations are provided for the different quantity classes.\n\n(This check depends on some heuristics, so it may not accurately determine whether a string really should be a quantity. You can use tools:ignore to filter out false positives.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML).addMoreInfo("https://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
        FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
        isCharacterType = new Companion.TypeTest(CollectionsKt.listOf((Object)PsiTypes.charType()), CollectionsKt.listOf((Object)"java.lang.Character"));
        isBooleanType = new Companion.TypeTest(CollectionsKt.listOf((Object)PsiTypes.booleanType()), CollectionsKt.listOf((Object)"java.lang.Boolean"));
        objectArray = new PsiPrimitiveType[]{PsiTypes.intType(), PsiTypes.longType(), PsiTypes.byteType(), PsiTypes.shortType()};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.Integer", "java.lang.Long", "java.lang.Byte", "java.lang.Short"};
        isIntType = new Companion.TypeTest(list, CollectionsKt.listOf((Object[])objectArray));
        objectArray = new PsiPrimitiveType[]{PsiTypes.floatType(), PsiTypes.doubleType()};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.Float", "java.lang.Double"};
        isFloatType = new Companion.TypeTest(list2, CollectionsKt.listOf((Object[])objectArray));
        isNumericType = isIntType.or(isFloatType);
        objectArray = new String[]{"java.math.BigInteger", "java.math.BigDecimal"};
        isNumericOrBigNumberType = isNumericType.or(new Companion.TypeTest(CollectionsKt.emptyList(), CollectionsKt.listOf((Object[])objectArray)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001_B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010(\u001a\u00020)J4\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u001a\u0010/\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020.01\u0018\u000100H\u0002J*\u00103\u001a\u00020$2\u0006\u0010+\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020.2\b\u00107\u001a\u0004\u0018\u000102H\u0002J(\u00108\u001a\u0002092\u0006\u0010+\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020\u0007H\u0002JB\u0010?\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010@\u001a\u0002092\u0006\u0010?\u001a\u0002092\u0006\u0010-\u001a\u00020.2\u0018\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020.0100H\u0002J\u0010\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020CH\u0002J \u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020.2\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010GH\u0007J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u0010E\u001a\u00020.H\u0002J\"\u0010K\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020J010I2\u0006\u0010E\u001a\u00020.H\u0002J\u001a\u0010L\u001a\u0004\u0018\u00010.2\u0006\u0010E\u001a\u00020.2\u0006\u0010M\u001a\u00020\u0007H\u0007J\u0016\u0010N\u001a\u0002092\u0006\u0010E\u001a\u00020.2\u0006\u0010M\u001a\u00020\u0007J\u0018\u0010O\u001a\u0002092\u0006\u0010P\u001a\u00020C2\u0006\u0010Q\u001a\u00020CH\u0002J\u0010\u0010R\u001a\u0002092\u0006\u0010S\u001a\u00020.H\u0007J\u0010\u0010T\u001a\u0002092\u0006\u0010=\u001a\u00020.H\u0002J \u0010U\u001a\u0002092\u0006\u0010+\u001a\u00020,2\u0006\u0010V\u001a\u00020\u00042\u0006\u0010W\u001a\u00020XH\u0002J\"\u0010U\u001a\u0002092\u0006\u0010+\u001a\u00020,2\u0006\u0010V\u001a\u00020\u00042\b\u00107\u001a\u0004\u0018\u000102H\u0002J\"\u0010U\u001a\u0002092\u0006\u0010+\u001a\u00020,2\u0006\u0010V\u001a\u00020\u00042\b\u0010Y\u001a\u0004\u0018\u00010\u0001H\u0002J0\u0010Z\u001a\u00020X2\u0006\u0010+\u001a\u00020,2\u0006\u0010W\u001a\u00020X2\u0006\u0010[\u001a\u00020.2\u0006\u0010\\\u001a\u00020\u00072\u0006\u0010]\u001a\u00020\u0007H\u0002J\u0010\u0010^\u001a\u00020.2\u0006\u0010E\u001a\u00020.H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector$Companion;", "", "()V", "ARG_COUNT", "Lcom/android/tools/lint/detector/api/Issue;", "ARG_TYPES", "CONVERSION_CLASS_BOOLEAN", "", "CONVERSION_CLASS_CHARACTER", "CONVERSION_CLASS_DATETIME", "CONVERSION_CLASS_FLOAT", "CONVERSION_CLASS_HASHCODE", "CONVERSION_CLASS_INTEGER", "CONVERSION_CLASS_NEWLINE", "CONVERSION_CLASS_PERCENT", "CONVERSION_CLASS_STRING", "CONVERSION_CLASS_UNKNOWN", "FORMAT", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "IMPLEMENTATION_XML", "Lcom/android/tools/lint/detector/api/Implementation;", "IMPLEMENTATION_XML_AND_JAVA", "INVALID", "POTENTIAL_PLURAL", "TRIVIAL", "getTRIVIAL", "()Lcom/android/tools/lint/detector/api/Issue;", "isBooleanType", "Lcom/android/tools/lint/checks/StringFormatDetector$Companion$TypeTest;", "isCharacterType", "isFloatType", "isIntType", "isNumericOrBigNumberType", "isNumericType", "addText", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "node", "Lorg/w3c/dom/Node;", "checkArity", "context", "Lcom/android/tools/lint/detector/api/Context;", "name", "", "list", "", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "checkNotFormattedHandle", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "handle", "checkPotentialPlural", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "text", "wordBegin", "checkTypes", "checkValid", "getConversionClass", "conversion", "", "getFormatArgumentCount", "s", "seenArguments", "", "getFormatArgumentSequence", "Lkotlin/sequences/Sequence;", "Ljava/util/regex/MatchResult;", "getFormatArgumentSequenceWithIndex", "getFormatArgumentType", "argument", "hasFormatArgumentModifiers", "isIncompatible", "conversion1", "conversion2", "isLocaleSpecific", "format", "isReference", "isSuppressed", "issue", "location", "Lcom/android/tools/lint/detector/api/Location;", "source", "refineLocation", "formatString", "substringStart", "substringEnd", "stripQuotes", "TypeTest", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nStringFormatDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringFormatDetector.kt\ncom/android/tools/lint/checks/StringFormatDetector$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1452:1\n107#2:1453\n79#2,22:1454\n1174#3,2:1476\n1#4:1478\n1247#5,2:1479\n*S KotlinDebug\n*F\n+ 1 StringFormatDetector.kt\ncom/android/tools/lint/checks/StringFormatDetector$Companion\n*L\n907#1:1453\n907#1:1454,22\n928#1:1476,2\n1382#1:1479,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getTRIVIAL() {
            return TRIVIAL;
        }

        /*
         * WARNING - void declaration
         */
        public final void addText(@NotNull StringBuilder sb, @NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            short nodeType = node.getNodeType();
            if (nodeType == 3 || nodeType == 4) {
                void $this$trim$iv;
                String string = node.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeValue");
                String string2 = string;
                Companion companion = this;
                StringBuilder stringBuilder = sb;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                stringBuilder.append(companion.stripQuotes(string3));
            } else {
                NodeList childNodes = node.getChildNodes();
                int n = childNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = childNodes.item(i);
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"childNodes.item(i)");
                    this.addText(sb, node2);
                }
            }
        }

        @JvmStatic
        @NotNull
        public final String stripQuotes(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            StringBuilder sb = new StringBuilder();
            boolean isEscaped = false;
            boolean isQuotedBlock = false;
            CharSequence $this$forEach$iv = s;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char current = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                if (isEscaped) {
                    sb.append(current);
                    isEscaped = false;
                    continue;
                }
                isEscaped = current == '\\';
                char c = current;
                if (c == '\"') {
                    isQuotedBlock = !isQuotedBlock;
                    continue;
                }
                if (c == '\'') {
                    if (!isQuotedBlock) continue;
                    sb.append(current);
                    continue;
                }
                sb.append(current);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        private final boolean isReference(String text) {
            boolean bl;
            Character c;
            block3: {
                CharSequence charSequence = text;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char c2;
                    char it = c2 = charSequence.charAt(i);
                    boolean bl2 = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    c = Character.valueOf(c2);
                    break block3;
                }
                c = null;
            }
            if (c != null) {
                char it = c.charValue();
                boolean bl3 = false;
                bl = it == '@' || it == '?';
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean checkPotentialPlural(XmlContext context, Element element, String text, int wordBegin) {
            int wordEnd;
            boolean bl = Character.isLetter(text.charAt(wordBegin));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            for (wordEnd = wordBegin; wordEnd < text.length() && Character.isLetter(text.charAt(wordEnd)); ++wordEnd) {
            }
            if (wordEnd - wordBegin <= 2) {
                return false;
            }
            boolean hasVowel = false;
            int n = wordEnd;
            for (int i = wordBegin; i < n; ++i) {
                char c = text.charAt(i);
                if (i > wordBegin && Character.isUpperCase(c)) {
                    return false;
                }
                if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u' && c != 'y') continue;
                hasVowel = true;
            }
            if (!hasVowel) {
                return false;
            }
            String string = text.substring(wordBegin, wordEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String word = string;
            if (Intrinsics.areEqual((Object)word, (Object)"min")) {
                return false;
            }
            if (Lint.isEnglishResource((XmlContext)context, (boolean)true)) {
                String string2 = "Formatting %%d followed by words (\"%1$s\"): This should probably be a plural rather than a string";
                Object[] objectArray = new Object[]{word};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                String message2 = string3;
                XmlContext.report$default((XmlContext)context, (Issue)POTENTIAL_PLURAL, (Node)element, (Location)context.getLocation((Node)element), (String)message2, null, (int)16, null);
                return true;
            }
            return false;
        }

        private final boolean isSuppressed(Context context, Issue issue, Object source) {
            return source instanceof Node ? context.getDriver().isSuppressed(null, issue, (Node)source) : false;
        }

        private final boolean isSuppressed(Context context, Issue issue, Location location) {
            Object source = location.getSource();
            return this.isSuppressed(context, issue, source);
        }

        private final boolean isSuppressed(Context context, Issue issue, Location.Handle handle) {
            Location.Handle handle2 = handle;
            Intrinsics.checkNotNull((Object)handle2);
            Object source = handle2.getClientData();
            return this.isSuppressed(context, issue, source) || this.isSuppressed(context, issue, handle.resolve());
        }

        private final void checkTypes(Context context, boolean checkValid, boolean checkTypes, String name, List<? extends Pair<? extends Location.Handle, String>> list) {
            Map types = new HashMap();
            Map typeDefinition = new HashMap();
            block0: for (Pair<? extends Location.Handle, String> pair : list) {
                Location.Handle handle = (Location.Handle)pair.component1();
                String formatString = (String)pair.component2();
                for (Pair pair2 : this.getFormatArgumentSequenceWithIndex(formatString)) {
                    String message2;
                    char last;
                    String str;
                    int number = ((Number)pair2.component1()).intValue();
                    MatchResult matcher = (MatchResult)pair2.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)formatString.substring(matcher.start(), matcher.end()), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                        String message3;
                        if (this.isSuppressed(context, INVALID, handle)) {
                            return;
                        }
                        Location location = handle.resolve();
                        String string = "Incorrect formatting string `%1$s`; missing conversion character in '`%2$s`'?";
                        Object[] objectArray = new Object[]{name, str};
                        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                        Context.report$default((Context)context, (Issue)INVALID, (Location)location, (String)message3, null, (int)8, null);
                        continue;
                    }
                    if (!checkTypes) continue;
                    String format = matcher.group(6);
                    String currentFormat = (String)types.get(number);
                    if (currentFormat == null) {
                        Integer n = number;
                        Intrinsics.checkNotNullExpressionValue((Object)format, (String)"format");
                        types.put(n, format);
                        n = number;
                        typeDefinition.put(n, handle);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)currentFormat, (Object)format) || !this.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                    if (this.isSuppressed(context, ARG_TYPES, handle)) {
                        return;
                    }
                    Location location = handle.resolve();
                    if (this.isSuppressed(context, ARG_TYPES, location)) {
                        return;
                    }
                    location = this.refineLocation(context, location, formatString, matcher.start(), matcher.end());
                    Object v = typeDefinition.get(number);
                    Intrinsics.checkNotNull(v);
                    Location otherLocation = ((Location.Handle)v).resolve();
                    otherLocation.setMessage("Conflicting argument type (`" + currentFormat + "') here");
                    location.setSecondary(otherLocation);
                    File f2 = otherLocation.getFile();
                    Locale locale = Locale.US;
                    String string = "Inconsistent formatting types for argument #%1$d in format string `%2$s` ('%3$s'): Found both '`%4$s`' here and '`%5$s`' in %6$s";
                    Object[] objectArray = new Object[]{number, name, str, format, currentFormat, Lint.getFileNameWithParent((LintClient)context.getClient(), (File)f2)};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(locale, format, *args)");
                    Context.report$default((Context)context, (Issue)ARG_TYPES, (Location)location, (String)message2, null, (int)8, null);
                    continue block0;
                }
            }
        }

        private final boolean isIncompatible(char conversion1, char conversion2) {
            int class2;
            int class1 = this.getConversionClass(conversion1);
            return class1 != (class2 = this.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
        }

        private final int getConversionClass(char conversion) {
            char c = conversion;
            if (c == 't' ? true : c == 'T') {
                return 9;
            }
            if (c == 's' ? true : c == 'S') {
                return 1;
            }
            if (c == 'c' ? true : c == 'C') {
                return 2;
            }
            if (((c == 'd' ? true : c == 'o') ? true : c == 'x') ? true : c == 'X') {
                return 3;
            }
            if ((((((c == 'f' ? true : c == 'e') ? true : c == 'E') ? true : c == 'g') ? true : c == 'G') ? true : c == 'a') ? true : c == 'A') {
                return 4;
            }
            if (c == 'b' ? true : c == 'B') {
                return 5;
            }
            if (c == 'h' ? true : c == 'H') {
                return 6;
            }
            if (c == '%') {
                return 7;
            }
            if (c == 'n') {
                return 8;
            }
            return 0;
        }

        private final Location refineLocation(Context context, Location location, String formatString, int substringStart, int substringEnd) {
            Position startLocation = location.getStart();
            Position endLocation = location.getEnd();
            if (startLocation != null && endLocation != null) {
                int formatOffset;
                CharSequence contents;
                int startOffset = startLocation.getOffset();
                int endOffset = endLocation.getOffset();
                if (startOffset >= 0 && endOffset <= (contents = context.getClient().readFile(location.getFile())).length() && startOffset < endOffset && (formatOffset = CharSequences.indexOf((CharSequence)contents, (CharSequence)formatString, (int)startOffset)) != -1 && formatOffset <= endOffset) {
                    return Location.Companion.create(location.getFile(), contents, formatOffset + substringStart, formatOffset + substringEnd);
                }
            }
            return location;
        }

        private final void checkArity(Context context, String name, List<? extends Pair<? extends Location.Handle, String>> list) {
            int prevCount = -1;
            List<? extends Pair<? extends Location.Handle, String>> list2 = list;
            Intrinsics.checkNotNull(list2);
            for (Pair<? extends Location.Handle, String> pair : list2) {
                Object[] objectArray;
                String string;
                Set indices = new HashSet();
                int count = this.getFormatArgumentCount((String)pair.getSecond(), indices);
                Location.Handle handle = (Location.Handle)pair.getFirst();
                if (prevCount != -1 && prevCount != count) {
                    if (this.isSuppressed(context, ARG_COUNT, handle)) {
                        return;
                    }
                    Location location = handle.resolve();
                    if (this.isSuppressed(context, ARG_COUNT, location)) {
                        return;
                    }
                    Location secondary = ((Location.Handle)list.get(0).getFirst()).resolve();
                    if (this.isSuppressed(context, ARG_COUNT, secondary)) {
                        return;
                    }
                    secondary.setMessage("Conflicting number of arguments (" + prevCount + ") here");
                    location.setSecondary(secondary);
                    String path = Lint.getFileNameWithParent((LintClient)context.getClient(), (File)secondary.getFile());
                    Locale locale = Locale.US;
                    string = "Inconsistent number of arguments in formatting string `%1$s`; found both %2$d here and %3$d in %4$s";
                    objectArray = new Object[]{name, count, prevCount, path};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                    String message2 = string2;
                    Context.report$default((Context)context, (Issue)ARG_COUNT, (Location)location, (String)message2, null, (int)8, null);
                    break;
                }
                int i = 1;
                if (i <= count) {
                    while (true) {
                        if (!indices.contains(i)) {
                            String message3;
                            if (this.isSuppressed(context, ARG_COUNT, handle)) {
                                return;
                            }
                            Set all = new HashSet();
                            for (int j = 1; j < count; ++j) {
                                all.add(j);
                            }
                            all.removeAll(indices);
                            List sorted = new ArrayList(all);
                            Collections.sort(sorted);
                            Location location = handle.resolve();
                            string = "Formatting string '`%1$s`' is not referencing numbered arguments %2$s";
                            objectArray = new Object[]{name, sorted};
                            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                            Context.report$default((Context)context, (Issue)ARG_COUNT, (Location)location, (String)message3, null, (int)8, null);
                            break;
                        }
                        if (i == count) break;
                        ++i;
                    }
                }
                prevCount = count;
            }
        }

        private final Sequence<MatchResult> getFormatArgumentSequence(String s) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MatchResult>, Continuation<? super Unit>, Object>(s, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ String $s;
                {
                    this.$s = $s;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            matcher = StringFormatDetector.FORMAT.matcher(this.$s);
                            index = 0;
lbl8:
                            // 2 sources

                            while (matcher.find(index)) {
                                it = matcher.group(6);
                                $i$a$-let-StringFormatDetector$Companion$getFormatArgumentSequence$1$1 = false;
                                v0 = Intrinsics.areEqual((Object)it, (Object)"%") || Intrinsics.areEqual((Object)it, (Object)"n");
                                if (!v0) ** GOTO lbl16
                                v1 = matcher.end();
                                ** GOTO lbl41
lbl16:
                                // 1 sources

                                if (0 > matcher.start() - 1 || this.$s.charAt(matcher.start() - 1) != '\\') ** GOTO lbl19
                                v1 = matcher.start() + 1;
                                ** GOTO lbl41
lbl19:
                                // 1 sources

                                var5_6 = Boxing.boxInt((int)matcher.end());
                                ((Number)var5_6).intValue();
                                $i$a$-also-StringFormatDetector$Companion$getFormatArgumentSequence$1$2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher");
                                this.L$0 = $this$sequence;
                                this.L$1 = matcher;
                                this.L$2 = var5_6;
                                this.label = 1;
                                v2 = $this$sequence.yield((Object)matcher, (Continuation)this);
                                if (v2 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl40
                            }
                            break;
                        }
                        case 1: {
                            $i$a$-also-StringFormatDetector$Companion$getFormatArgumentSequence$1$2 = false;
                            var5_6 = (Integer)this.L$2;
                            matcher = (Matcher)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl40:
                            // 2 sources

                            v1 = ((Number)var5_6).intValue();
lbl41:
                            // 3 sources

                            index = v1;
                            ** GOTO lbl8
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super MatchResult> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final Sequence<Pair<Integer, MatchResult>> getFormatArgumentSequenceWithIndex(String s) {
            Ref.IntRef nextNumber = new Ref.IntRef();
            nextNumber.element = 1;
            return SequencesKt.map(this.getFormatArgumentSequence(s), (Function1)((Function1)new Function1<MatchResult, Pair<? extends Integer, ? extends MatchResult>>(nextNumber){
                final /* synthetic */ Ref.IntRef $nextNumber;
                {
                    this.$nextNumber = $nextNumber;
                    super(1);
                }

                @NotNull
                public final Pair<Integer, MatchResult> invoke(@NotNull MatchResult matcher) {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                    String numberString = matcher.group(1);
                    if (numberString == null) {
                        var4_3 = this.$nextNumber.element;
                        this.$nextNumber.element = var4_3 + 1;
                        n = var4_3;
                    } else {
                        String string = numberString.substring(0, numberString.length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        var4_3 = Integer.parseInt(string);
                        Ref.IntRef intRef = this.$nextNumber;
                        int it = var4_3;
                        boolean bl = false;
                        intRef.element = it + 1;
                        n = var4_3;
                    }
                    int number = n;
                    return TuplesKt.to((Object)number, (Object)matcher);
                }
            }));
        }

        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final String getFormatArgumentType(@NotNull String s, int argument) {
            String string;
            Object v0;
            Pair pair;
            block3: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                pair = this.getFormatArgumentSequenceWithIndex(s);
                for (Object e : pair) {
                    Pair pair2 = (Pair)e;
                    boolean bl = false;
                    int number = ((Number)pair2.component1()).intValue();
                    if (!(number == argument)) continue;
                    v0 = e;
                    break block3;
                }
                v0 = null;
            }
            Pair pair3 = v0;
            if (pair3 != null) {
                pair = pair3;
                boolean bl = false;
                MatchResult matcher = (MatchResult)pair.component2();
                string = matcher.group(6);
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        public final int getFormatArgumentCount(@NotNull String s, @Nullable Set<Integer> seenArguments) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map(this.getFormatArgumentSequenceWithIndex(s), (Function1)getFormatArgumentCount.1.INSTANCE), (Function1)((Function1)new Function1<Integer, Unit>(seenArguments){
                final /* synthetic */ Set<Integer> $seenArguments;
                {
                    this.$seenArguments = $seenArguments;
                    super(1);
                }

                public final void invoke(int it) {
                    block0: {
                        Set<Integer> set = this.$seenArguments;
                        if (set == null) break block0;
                        set.add(it);
                    }
                }
            })));
            return n != null ? n : 0;
        }

        public final boolean hasFormatArgumentModifiers(@NotNull String s, int argument) {
            boolean bl;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                Sequence<Pair<Integer, MatchResult>> sequence = this.getFormatArgumentSequenceWithIndex(s);
                for (Object e : sequence) {
                    Pair pair = (Pair)e;
                    boolean bl2 = false;
                    int number = ((Number)pair.component1()).intValue();
                    if (!(number == argument)) continue;
                    v0 = e;
                    break block3;
                }
                v0 = null;
            }
            Pair pair = v0;
            if (pair != null) {
                Iterator iterator = pair;
                boolean bl3 = false;
                MatchResult matcher = (MatchResult)iterator.component2();
                CharSequence charSequence = matcher.group(2);
                bl = !((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)matcher.group(3)) == null || charSequence.length() == 0) && ((charSequence = (CharSequence)matcher.group(4)) == null || charSequence.length() == 0));
            } else {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        public final boolean isLocaleSpecific(@NotNull String format) {
            boolean bl;
            block15: {
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                Sequence<MatchResult> $this$any$iv = this.getFormatArgumentSequence(format);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    boolean bl8;
                    Character c;
                    MatchResult matcher = (MatchResult)element$iv;
                    boolean bl9 = false;
                    String string = matcher.group(6);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(6)");
                    Character c2 = c = StringsKt.firstOrNull((CharSequence)string);
                    char c3 = 'd';
                    if (c2 != null && c2.charValue() == c3) {
                        bl8 = true;
                    } else {
                        Character c4 = c;
                        c3 = 'e';
                        bl8 = c4 != null && c4.charValue() == c3;
                    }
                    if (bl8) {
                        bl7 = true;
                    } else {
                        Character c5 = c;
                        c3 = 'E';
                        bl7 = c5 != null && c5.charValue() == c3;
                    }
                    if (bl7) {
                        bl6 = true;
                    } else {
                        Character c6 = c;
                        c3 = 'f';
                        bl6 = c6 != null && c6.charValue() == c3;
                    }
                    if (bl6) {
                        bl5 = true;
                    } else {
                        Character c7 = c;
                        c3 = 'g';
                        bl5 = c7 != null && c7.charValue() == c3;
                    }
                    if (bl5) {
                        bl4 = true;
                    } else {
                        Character c8 = c;
                        c3 = 'G';
                        bl4 = c8 != null && c8.charValue() == c3;
                    }
                    if (bl4) {
                        bl3 = true;
                    } else {
                        Character c9 = c;
                        c3 = 't';
                        bl3 = c9 != null && c9.charValue() == c3;
                    }
                    if (bl3) {
                        bl2 = true;
                    } else {
                        Character c10 = c;
                        c3 = 'T';
                        bl2 = c10 != null && c10.charValue() == c3;
                    }
                    boolean bl10 = bl2;
                    if (!bl10) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
            return bl;
        }

        private final void checkNotFormattedHandle(JavaContext context, UCallExpression call, String name, Location.Handle handle) {
            if (this.isSuppressed((Context)context, INVALID, handle)) {
                return;
            }
            Location location = context.getLocation((UElement)call);
            Location.Handle handle2 = handle;
            Intrinsics.checkNotNull((Object)handle2);
            Location secondary = handle2.resolve();
            secondary.setMessage("This definition does not require arguments");
            location.setSecondary(secondary);
            String string = "Format string '`%1$s`' is not a valid format string so it should not be passed to `String.format`";
            Object[] objectArray = new Object[]{name};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String message2 = string2;
            JavaContext.report$default((JavaContext)context, (Issue)INVALID, (UElement)((UElement)call), (Location)location, (String)message2, null, (int)16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/StringFormatDetector$Companion$TypeTest;", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiType;", "", "prims", "", "tags", "", "(Ljava/util/List;Ljava/util/List;)V", "invoke", "t", "(Lcom/intellij/psi/PsiType;)Ljava/lang/Boolean;", "or", "that", "lint-checks"})
        private static final class TypeTest
        implements Function1<PsiType, Boolean> {
            @NotNull
            private final List<PsiType> prims;
            @NotNull
            private final List<String> tags;

            public TypeTest(@NotNull List<? extends PsiType> prims, @NotNull List<String> tags) {
                Intrinsics.checkNotNullParameter(prims, (String)"prims");
                Intrinsics.checkNotNullParameter(tags, (String)"tags");
                this.prims = prims;
                this.tags = tags;
            }

            @NotNull
            public Boolean invoke(@NotNull PsiType t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return this.prims.contains(t) || t instanceof PsiClassType && this.tags.contains(t.getCanonicalText());
            }

            @NotNull
            public final TypeTest or(@NotNull TypeTest that) {
                Intrinsics.checkNotNullParameter((Object)that, (String)"that");
                return new TypeTest(CollectionsKt.plus((Collection)this.prims, (Iterable)that.prims), CollectionsKt.plus((Collection)this.tags, (Iterable)that.tags));
            }
        }
    }
}

