/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;

public class SetTextDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(SetTextDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue SET_TEXT_I18N = Issue.create((String)"SetTextI18n", (String)"TextView Internationalization", (String)"When calling `TextView#setText`\n* Never call `Number#toString()` to format numbers; it will not handle fraction separators and locale-specific digits properly. Consider using `String#format` with proper format specifications (`%d` or `%f`) instead.\n* Do not pass a string literal (e.g. \"Hello\") to display text. Hardcoded text can not be properly translated to other languages. Consider using Android resource strings instead.\n* Do not build messages by concatenating text chunks. Such messages can not be properly translated.", (Category)Category.I18N, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/resources/localization.html").setAndroidSpecific(true);
    private static final String METHOD_NAME = "setText";
    private static final String TO_STRING_NAME = "toString";
    private static final String CHAR_SEQUENCE_CLS = "java.lang.CharSequence";
    private static final String NUMBER_CLS = "java.lang.Number";
    private static final String TEXT_VIEW_CLS = "android.widget.TextView";
    private static final String WORD_PATTERN = ".*\\w{2,}.*";

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(METHOD_NAME);
    }

    public void visitMethodCall(JavaContext context, UCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInSubClassOf((PsiMember)method, TEXT_VIEW_CLS, false)) {
            return;
        }
        if (method.getParameterList().getParametersCount() > 0 && evaluator.parameterHasType(method, 0, CHAR_SEQUENCE_CLS)) {
            SetTextDetector.checkNode(context, (UElement)call.getValueArguments().get(0));
        }
    }

    private static void checkNode(JavaContext context, UElement node) {
        if (node instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)node).getValue();
            if (value instanceof String && value.toString().matches(WORD_PATTERN)) {
                context.report(SET_TEXT_I18N, node, context.getLocation(node), "String literal in `setText` can not be translated. Use Android resources instead.");
            }
        } else if (node instanceof UCallExpression) {
            PsiMethod calledMethod = ((UCallExpression)node).resolve();
            if (calledMethod != null && TO_STRING_NAME.equals(calledMethod.getName())) {
                PsiClass containingClass = calledMethod.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                PsiClass superClass = containingClass.getSuperClass();
                if (superClass != null && NUMBER_CLS.equals(superClass.getQualifiedName())) {
                    context.report(SET_TEXT_I18N, node, context.getLocation(node), "Number formatting does not take into account locale settings. Consider using `String.format` instead.");
                }
            }
        } else if (node instanceof UQualifiedReferenceExpression) {
            UQualifiedReferenceExpression expression = (UQualifiedReferenceExpression)node;
            SetTextDetector.checkNode(context, (UElement)expression.getReceiver());
            SetTextDetector.checkNode(context, (UElement)expression.getSelector());
        } else if (node instanceof UPolyadicExpression) {
            UPolyadicExpression expression = (UPolyadicExpression)node;
            if (expression.getOperator() == UastBinaryOperator.PLUS) {
                context.report(SET_TEXT_I18N, node, context.getLocation(node), "Do not concatenate text displayed with `setText`. Use resource string with placeholders.");
            }
            for (UExpression operand : expression.getOperands()) {
                SetTextDetector.checkNode(context, (UElement)operand);
            }
        } else if (node instanceof UParenthesizedExpression) {
            SetTextDetector.checkNode(context, (UElement)((UParenthesizedExpression)node).getExpression());
        }
    }
}

