/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightFieldForSourceDeclarationSupport;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"CLASS_LIFECYCLE", "", "CLASS_LIFECYCLE_OLD", "isAppContext", "", "cls", "Lcom/intellij/psi/PsiClass;", "field", "Lcom/intellij/psi/PsiField;", "isInitializedToAppContext", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "typeClass", "Lorg/jetbrains/uast/UField;", "isLeakCandidate", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nLeakDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakDetector.kt\ncom/android/tools/lint/checks/LeakDetectorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,410:1\n12474#2,2:411\n1747#3,3:413\n*S KotlinDebug\n*F\n+ 1 LeakDetector.kt\ncom/android/tools/lint/checks/LeakDetectorKt\n*L\n302#1:411,2\n312#1:413,3\n*E\n"})
public final class LeakDetectorKt {
    @NotNull
    private static final String CLASS_LIFECYCLE = "androidx.lifecycle.Lifecycle";
    @NotNull
    private static final String CLASS_LIFECYCLE_OLD = "android.arch.lifecycle.Lifecycle";

    private static final boolean isAppContext(PsiClass cls, PsiField field) {
        String name;
        KtDeclaration origin;
        boolean bl;
        PsiAnnotation it;
        block9: {
            PsiAnnotation[] psiAnnotationArray = field.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"field.annotations");
            Object[] $this$any$iv = psiAnnotationArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                boolean bl2;
                String string;
                it = (PsiAnnotation)element$iv;
                boolean bl3 = false;
                String string2 = string = it.getQualifiedName();
                if (string2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"qualifiedName");
                    bl2 = StringsKt.endsWith$default((String)string, (String)"ApplicationContext", (boolean)false, (int)2, null);
                } else {
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        if (field instanceof KtLightFieldForSourceDeclarationSupport && (origin = ((KtLightFieldForSourceDeclarationSupport)field).getKotlinOrigin()) != null) {
            boolean bl4;
            block10: {
                List list = origin.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"origin.annotationEntries");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KtAnnotationEntry)element$iv;
                        boolean bl5 = false;
                        Name name2 = it.getShortName();
                        if (!Intrinsics.areEqual((Object)(name2 != null ? name2.getIdentifier() : null), (Object)"ApplicationContext")) continue;
                        bl4 = true;
                        break block10;
                    }
                    bl4 = false;
                }
            }
            if (bl4) {
                return true;
            }
        }
        String string = field.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
        String string3 = name = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        String lower = string4;
        return (StringsKt.contains$default((CharSequence)lower, (CharSequence)"appcontext", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"application", (boolean)false, (int)2, null)) && Intrinsics.areEqual((Object)"android.content.Context", (Object)cls.getQualifiedName());
    }

    private static final boolean isInitializedToAppContext(JavaContext context, PsiField field, PsiClass typeClass) {
        if (!context.getEvaluator().extendsClass(typeClass, "android.content.Context", false)) {
            return false;
        }
        UField uField = (UField)UastContextKt.toUElement((PsiElement)((PsiElement)field), UField.class);
        if (uField == null) {
            return true;
        }
        UField uField2 = uField;
        return LeakDetectorKt.isInitializedToAppContext(context, uField2, typeClass);
    }

    private static final boolean isInitializedToAppContext(JavaContext context, UField field, PsiClass typeClass) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)field));
        if (uClass == null) {
            return false;
        }
        UClass containingClass = uClass;
        if (!context.getEvaluator().extendsClass(typeClass, "android.content.Context", false)) {
            return false;
        }
        for (UDeclaration method : containingClass.getUastDeclarations()) {
            UExpression methodBody;
            if (!(method instanceof UMethod) || !((UMethod)method).isConstructor() || ((UMethod)method).getUastBody() == null) continue;
            Ref assignedToAppContext = new Ref((Object)false);
            methodBody.accept((UastVisitor)new AbstractUastVisitor(field, (Ref<Boolean>)assignedToAppContext){
                final /* synthetic */ UField $field;
                final /* synthetic */ Ref<Boolean> $assignedToAppContext;
                {
                    this.$field = $field;
                    this.$assignedToAppContext = $assignedToAppContext;
                }

                public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (UastExpressionUtils.isAssignment((UElement)((UElement)node)) && node.getLeftOperand() instanceof UResolvable) {
                        PsiElement psiElement = this.$field.getSourcePsi();
                        UExpression uExpression = node.getLeftOperand();
                        Intrinsics.checkNotNull((Object)uExpression, (String)"null cannot be cast to non-null type org.jetbrains.uast.UResolvable");
                        if (Intrinsics.areEqual((Object)psiElement, (Object)((UResolvable)uExpression).resolve())) {
                            UElement rhs = (UElement)node.getRightOperand();
                            while (rhs instanceof UQualifiedReferenceExpression) {
                                rhs = (UElement)((UQualifiedReferenceExpression)rhs).getSelector();
                            }
                            if (rhs instanceof UCallExpression && Intrinsics.areEqual((Object)"getApplicationContext", (Object)Lint.getMethodName((UCallExpression)((UCallExpression)rhs)))) {
                                this.$assignedToAppContext.set((Object)true);
                            }
                        }
                    }
                    return super.visitBinaryExpression(node);
                }
            });
            Object object = assignedToAppContext.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assignedToAppContext.get()");
            if (!((Boolean)object).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static final boolean isLeakCandidate(PsiClass cls, JavaEvaluator evaluator) {
        return evaluator.extendsClass(cls, "android.content.Context", false) && !evaluator.extendsClass(cls, "android.app.Application", false) || evaluator.extendsClass(cls, "android.view.View", false) || evaluator.extendsClass(cls, "android.app.Fragment", false) || evaluator.extendsClass(cls, CLASS_LIFECYCLE, false) || evaluator.extendsClass(cls, CLASS_LIFECYCLE_OLD, false);
    }

    public static final /* synthetic */ boolean access$isLeakCandidate(PsiClass cls, JavaEvaluator evaluator) {
        return LeakDetectorKt.isLeakCandidate(cls, evaluator);
    }

    public static final /* synthetic */ boolean access$isAppContext(PsiClass cls, PsiField field) {
        return LeakDetectorKt.isAppContext(cls, field);
    }

    public static final /* synthetic */ boolean access$isInitializedToAppContext(JavaContext context, UField field, PsiClass typeClass) {
        return LeakDetectorKt.isInitializedToAppContext(context, field, typeClass);
    }

    public static final /* synthetic */ boolean access$isInitializedToAppContext(JavaContext context, PsiField field, PsiClass typeClass) {
        return LeakDetectorKt.isInitializedToAppContext(context, field, typeClass);
    }
}

