/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public class FirebaseMessagingDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(FirebaseMessagingDetector.class, Scope.JAVA_FILE_SCOPE);
    private static final String FIREBASE_MESSAGING_SERVICE = "com.google.firebase.messaging.FirebaseMessagingService";
    public static final Issue MISSING_TOKEN_REFRESH = Issue.create((String)"MissingFirebaseInstanceTokenRefresh", (String)"Missing Firebase Messaging Callback", (String)"Apps that use Firebase Cloud Messaging should implement the `FirebaseMessagingService#onNewToken()` callback in order to observe token changes.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://firebase.google.com/docs/cloud-messaging/android/client#monitor-token-generation").setAndroidSpecific(true);

    public void visitClass(JavaContext context, UClass declaration) {
        if (FIREBASE_MESSAGING_SERVICE.equals(declaration.getQualifiedName())) {
            return;
        }
        for (UMethod method : declaration.getMethods()) {
            if (!method.getName().equals("onNewToken")) continue;
            return;
        }
        context.report(MISSING_TOKEN_REFRESH, declaration, context.getNameLocation(declaration), "Apps that use Firebase Cloud Messaging should implement `onNewToken()` in order to observe token changes");
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList(FIREBASE_MESSAGING_SERVICE);
    }
}

