/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/ConstraintLayoutDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class ConstraintLayoutDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{AndroidXConstants.CONSTRAINT_LAYOUT.oldName(), AndroidXConstants.CONSTRAINT_LAYOUT.newName(), AndroidXConstants.MOTION_LAYOUT.oldName(), AndroidXConstants.MOTION_LAYOUT.newName()};
        return SetsKt.setOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.hasAttributeNS("http://schemas.android.com/apk/res-auto", "layoutDescription")) {
            return;
        }
        Node child = element.getFirstChild();
        ArrayList flowList = new ArrayList();
        while (child != null) {
            if (child.getNodeType() != 1) {
                child = child.getNextSibling();
                continue;
            }
            String elementTagName = ((Element)child).getTagName();
            if (AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_FLOW.isEquals(elementTagName)) {
                NamedNodeMap attributes = ((Element)child).getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    String name;
                    Node attribute = attributes.item(i);
                    if (attribute.getLocalName() == null) continue;
                    String value = attribute.getNodeValue();
                    if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"constraint_referenced_ids", (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    String[] stringArray = new String[]{","};
                    flowList.addAll(StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                }
            }
            child = ((Element)child).getNextSibling();
        }
        child = element.getFirstChild();
        while (child != null) {
            block20: {
                boolean isConstrainedVertically;
                boolean isConstrainedHorizontally;
                Element layout;
                block19: {
                    String elementTagName;
                    block18: {
                        block17: {
                            if (child.getNodeType() != 1) {
                                child = child.getNextSibling();
                                continue;
                            }
                            layout = (Element)child;
                            elementTagName = layout.getTagName();
                            if (AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(elementTagName) || AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.isEquals(elementTagName) || Intrinsics.areEqual((Object)"include", (Object)elementTagName)) break block17;
                            Intrinsics.checkNotNullExpressionValue((Object)elementTagName, (String)"elementTagName");
                            if (!Lint.isLayoutMarkerTag((String)elementTagName)) break block18;
                        }
                        child = child.getNextSibling();
                        continue;
                    }
                    if (!StringsKt.isBlank((CharSequence)elementTagName) && AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_BARRIER.isEquals(elementTagName) && ConstraintLayoutDetector.Companion.scanForBarrierConstraint(layout)) break;
                    isConstrainedHorizontally = false;
                    isConstrainedVertically = false;
                    NamedNodeMap attributes = layout.getAttributes();
                    int n = attributes.getLength();
                    for (int i = 0; i < n; ++i) {
                        String name;
                        Node attribute = attributes.item(i);
                        if (attribute.getLocalName() == null) continue;
                        if (Intrinsics.areEqual((Object)"id", (Object)name)) {
                            String string = attribute.getNodeValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.nodeValue");
                            String[] stringArray = new String[]{"/"};
                            String value = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                            if (flowList.contains(value)) {
                                isConstrainedHorizontally = true;
                                isConstrainedVertically = true;
                                break;
                            }
                        }
                        if (!StringsKt.startsWith$default((String)name, (String)"layout_", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_creator", (boolean)false, (int)2, null)) continue;
                        if (Intrinsics.areEqual((Object)"layout_width", (Object)name) && Intrinsics.areEqual((Object)"match_parent", (Object)attribute.getNodeValue()) || StringsKt.endsWith$default((String)name, (String)"toLeftOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"toRightOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"toStartOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"toEndOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"toCenterX", (boolean)false, (int)2, null)) {
                            isConstrainedHorizontally = true;
                            if (!isConstrainedVertically) continue;
                            break;
                        }
                        if ((!Intrinsics.areEqual((Object)"layout_height", (Object)name) || !Intrinsics.areEqual((Object)"match_parent", (Object)attribute.getNodeValue())) && !StringsKt.endsWith$default((String)name, (String)"toTopOf", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)"toBottomOf", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)"toCenterY", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)"toBaselineOf", (boolean)false, (int)2, null)) continue;
                        isConstrainedVertically = true;
                        if (isConstrainedHorizontally) break;
                    }
                    if (!isConstrainedHorizontally) break block19;
                    if (isConstrainedVertically) break block20;
                }
                String message2 = isConstrainedVertically ? "This view is not constrained horizontally: at runtime it will jump to the left unless you add a horizontal constraint" : (isConstrainedHorizontally ? "This view is not constrained vertically: at runtime it will jump to the top unless you add a vertical constraint" : "This view is not constrained. It only has designtime positions, so it will jump to (0,0) at runtime unless you add the constraints");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)layout, (Location)context.getNameLocation((Node)layout), (String)message2, null, (int)16, null);
            }
            child = child.getNextSibling();
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(ConstraintLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"MissingConstraints", (String)"Missing Constraints in ConstraintLayout", (String)"\n                    The layout editor allows you to place widgets anywhere on the canvas, \\\n                    and it records the current position with designtime attributes (such as \\\n                    `layout_editor_absoluteX`). These attributes are **not** applied at \\\n                    runtime, so if you push your layout on a device, the widgets may appear \\\n                    in a different location than shown in the editor. To fix this, make sure \\\n                    a widget has both horizontal and vertical constraints by dragging from \\\n                    the edge connections.\n                    ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/ConstraintLayoutDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "scanForBarrierConstraint", "", "element", "Lorg/w3c/dom/Element;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean scanForBarrierConstraint(Element element) {
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String name;
                Node attribute = attributes.item(i);
                if (attribute.getLocalName() == null || !StringsKt.endsWith$default((String)name, (String)"barrierDirection", (boolean)false, (int)2, null)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

