/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.sdklib.SdkVersionInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0010J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/detector/api/ExtensionSdk;", "", "name", "", "id", "", "reference", "(Ljava/lang/String;ILjava/lang/String;)V", "getId", "()I", "getName", "()Ljava/lang/String;", "getReference", "compareTo", "other", "equals", "", "", "getSdkExtensionField", "fullyQualified", "hashCode", "toString", "Companion", "lint-api"})
public final class ExtensionSdk
implements Comparable<ExtensionSdk> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int id;
    @Nullable
    private final String reference;
    public static final int ANDROID_SDK_ID = 0;
    @NotNull
    private static final ExtensionSdk ANDROID_SDK = new ExtensionSdk("Android SDK", 0, null);
    public static final int MAX_PLATFORM_SDK_ID = 999999;

    public ExtensionSdk(@NotNull String name, int id, @Nullable String reference) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.id = id;
        this.reference = reference;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final String getReference() {
        return this.reference;
    }

    @NotNull
    public final String getSdkExtensionField(boolean fullyQualified) {
        String string = this.reference;
        if (string != null) {
            String fqn = string;
            boolean bl = false;
            if (fullyQualified) {
                return fqn;
            }
            return StringsKt.substringAfterLast$default((String)fqn, (char)'.', null, (int)2, null);
        }
        return Companion.getSdkExtensionField(this.id, fullyQualified);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ExtensionSdk && this.id == ((ExtensionSdk)other).id;
    }

    @Override
    public int compareTo(@NotNull ExtensionSdk other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)this.id, (int)other.id);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/detector/api/ExtensionSdk$Companion;", "", "()V", "ANDROID_SDK", "Lcom/android/tools/lint/detector/api/ExtensionSdk;", "getANDROID_SDK", "()Lcom/android/tools/lint/detector/api/ExtensionSdk;", "ANDROID_SDK_ID", "", "MAX_PLATFORM_SDK_ID", "deserialize", "s", "", "getAndroidVersionField", "sdkId", "fullyQualified", "", "getSdkExtensionField", "serialize", "sdk", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionSdk getANDROID_SDK() {
            return ANDROID_SDK;
        }

        @NotNull
        public final String getAndroidVersionField(int sdkId, boolean fullyQualified) {
            String codeName = SdkVersionInfo.getBuildCode((int)sdkId);
            return codeName == null ? String.valueOf(sdkId) : (fullyQualified ? "android.os.Build.VERSION_CODES." + codeName : codeName);
        }

        @NotNull
        public final String getSdkExtensionField(int sdkId, boolean fullyQualified) {
            if (sdkId <= 999999) {
                return this.getAndroidVersionField(sdkId, fullyQualified);
            }
            return String.valueOf(sdkId);
        }

        @NotNull
        public final String serialize(@NotNull ExtensionSdk sdk) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            int n = sdk.getId();
            String string = sdk.getName();
            String string2 = sdk.getReference();
            if (string2 == null) {
                string2 = "";
            }
            return n + ";" + string + ";" + string2;
        }

        @NotNull
        public final ExtensionSdk deserialize(@NotNull String s) {
            String string;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int index = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)0, (boolean)false, (int)6, null);
            int index2 = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)(index + 1), (boolean)false, (int)4, null);
            String string2 = s.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            int id = Integer.parseInt(string2);
            String string3 = s.substring(index + 1, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String name = string3;
            if (index2 < s.length() - 1) {
                String string4 = s.substring(index2 + 1);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            String reference = string;
            return new ExtensionSdk(name, id, reference);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

