/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.rewriter;

import com.android.tools.smali.dexlib2.base.reference.BaseMethodReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.rewriter.Rewriter;
import com.android.tools.smali.dexlib2.rewriter.RewriterUtils;
import com.android.tools.smali.dexlib2.rewriter.Rewriters;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

public class MethodReferenceRewriter
implements Rewriter<MethodReference> {
    @Nonnull
    protected final Rewriters rewriters;

    public MethodReferenceRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public MethodReference rewrite(@Nonnull MethodReference methodReference) {
        return new RewrittenMethodReference(methodReference);
    }

    protected class RewrittenMethodReference
    extends BaseMethodReference {
        @Nonnull
        protected MethodReference methodReference;

        public RewrittenMethodReference(MethodReference methodReference) {
            this.methodReference = methodReference;
        }

        @Override
        @Nonnull
        public String getDefiningClass() {
            return MethodReferenceRewriter.this.rewriters.getTypeRewriter().rewrite(this.methodReference.getDefiningClass());
        }

        @Override
        @Nonnull
        public String getName() {
            return this.methodReference.getName();
        }

        @Override
        @Nonnull
        public List<? extends CharSequence> getParameterTypes() {
            return RewriterUtils.rewriteList(MethodReferenceRewriter.this.rewriters.getTypeRewriter(), Lists.transform(this.methodReference.getParameterTypes(), (Function)new Function<CharSequence, String>(){

                @Nonnull
                public String apply(CharSequence input) {
                    return input.toString();
                }
            }));
        }

        @Override
        @Nonnull
        public String getReturnType() {
            return MethodReferenceRewriter.this.rewriters.getTypeRewriter().rewrite(this.methodReference.getReturnType());
        }
    }
}

