/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/Helper;", "", "()V", "collectSourceFilePaths", "", "root", "Ljava/nio/file/Path;", "result", "", "", "getSourceFilePaths", "", "javaSourceRoots", "", "includeDirectoryRoot", "", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nFirUastEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUastEnvironment.kt\ncom/android/tools/lint/Helper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,407:1\n1855#2,2:408\n*S KotlinDebug\n*F\n+ 1 FirUastEnvironment.kt\ncom/android/tools/lint/Helper\n*L\n348#1:408,2\n*E\n"})
final class Helper {
    @NotNull
    public static final Helper INSTANCE = new Helper();

    private Helper() {
    }

    @NotNull
    public final Set<String> getSourceFilePaths(@NotNull Collection<String> javaSourceRoots, boolean includeDirectoryRoot) {
        Set set;
        Intrinsics.checkNotNullParameter(javaSourceRoots, (String)"javaSourceRoots");
        Set $this$getSourceFilePaths_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = javaSourceRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String srcRoot = (String)element$iv;
            boolean bl2 = false;
            Path path = Paths.get(srcRoot, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                INSTANCE.collectSourceFilePaths(path, $this$getSourceFilePaths_u24lambda_u241);
                if (!includeDirectoryRoot) continue;
                $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
                continue;
            }
            $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
        }
        return SetsKt.build((Set)set);
    }

    public static /* synthetic */ Set getSourceFilePaths$default(Helper helper, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return helper.getSourceFilePaths(collection, bl);
    }

    private final void collectSourceFilePaths(Path root, Set<String> result) {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(result){
            final /* synthetic */ Set<String> $result;
            {
                this.$result = $result;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                return Files.isReadable(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
                    return FileVisitResult.CONTINUE;
                }
                String ext = com.google.common.io.Files.getFileExtension((String)((Object)file.getFileName()).toString());
                if (Intrinsics.areEqual((Object)ext, (Object)"kt") || Intrinsics.areEqual((Object)ext, (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX) || Intrinsics.areEqual((Object)ext, (Object)"java")) {
                    this.$result.add(((Object)file).toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@NotNull Path file, @Nullable IOException exc) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

